/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4cics.typemapping.cobol;

import it.imolinfo.jbi4cics.Logger;
import it.imolinfo.jbi4cics.LoggerFactory;
import it.imolinfo.jbi4cics.exception.FormatException;
import it.imolinfo.jbi4cics.jbi.Messages;
import it.imolinfo.jbi4cics.typemapping.cobol.CobolTypeDescriptor;
import java.math.BigDecimal;

public class PackedDecimalMarshaller {
    private static final Logger LOG = LoggerFactory.getLogger(PackedDecimalMarshaller.class);
    private static final Messages MESSAGES = Messages.getMessages(PackedDecimalMarshaller.class);
    public static final byte POSITIVE_SIGN = 12;
    public static final byte NEGATIVE_SIGN = 13;
    public static final byte NO_SIGN = 15;

    public static void marshallBigDecimal(BigDecimal value, byte[] buffer, CobolTypeDescriptor cobolType, int startingOffset) throws FormatException {
        LOG.debug("value: " + value);
        value = value.movePointRight(cobolType.getVirtualDecimalPoint());
        value = value.setScale(0);
        boolean isNegative = false;
        if (value.compareTo(new BigDecimal(0)) == -1) {
            value = value.abs();
            isNegative = true;
        }
        String stringValue = value.toPlainString();
        StringBuffer stringBufferValue = new StringBuffer();
        int numberSize = cobolType.getIntegerPartLength() + cobolType.getDecimalPartLength();
        for (int i = 0; i < numberSize - stringValue.length(); ++i) {
            stringBufferValue.append('0');
        }
        stringValue = stringBufferValue + stringValue;
        byte[] valueArray = stringValue.toString().getBytes();
        int bufferedLength = cobolType.getBufferedLength();
        for (int i = bufferedLength - 1; i >= 0; --i) {
            byte result;
            if (i == bufferedLength - 1) {
                int signByte = cobolType.isSigned() ? (isNegative ? 13 : 12) : 15;
                result = (byte)(valueArray[i * 2 + valueArray.length % 2 - 1] << 4 | signByte);
            } else if (i == 0 && valueArray.length % 2 == 0) {
                result = (byte)(0xF & valueArray[0]);
            } else {
                byte lowSemibyte = (byte)(0xF & valueArray[i * 2 + valueArray.length % 2]);
                byte highSemibyte = (byte)(0xF & valueArray[i * 2 + valueArray.length % 2 - 1]);
                result = (byte)(highSemibyte << 4 | lowSemibyte);
            }
            buffer[startingOffset + i] = result;
        }
    }

    public static BigDecimal unmarshallBigDecimal(byte[] buffer, CobolTypeDescriptor cobolType, int startingOffset) throws FormatException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean positive = true;
        for (int i = 0; i < cobolType.getBufferedLength(); ++i) {
            byte currentByte = buffer[startingOffset + i];
            if (i == cobolType.getBufferedLength() - 1) {
                if (cobolType.isSigned()) {
                    byte signbyte = (byte)(currentByte & 0xF);
                    switch (signbyte) {
                        case 12: {
                            positive = true;
                            break;
                        }
                        case 13: {
                            positive = false;
                            break;
                        }
                        default: {
                            LOG.error("CIC002115_Signed_decimal_int_not_found", signbyte);
                            throw new FormatException(MESSAGES.getString("CIC002115_Signed_decimal_int_not_found", signbyte));
                        }
                    }
                }
                byte firstChar = (byte)((currentByte & 0xF0) >> 4);
                stringBuffer.append(String.valueOf(firstChar));
                continue;
            }
            byte lowSemiByte = (byte)(currentByte & 0xF);
            byte highSemiByte = (byte)((currentByte & 0xF0) >> 4);
            stringBuffer.append(String.valueOf(highSemiByte));
            stringBuffer.append(String.valueOf(lowSemiByte));
        }
        BigDecimal result = new BigDecimal(stringBuffer.toString());
        result = result.setScale(0);
        result = result.movePointLeft(cobolType.getVirtualDecimalPoint());
        if (!positive) {
            result = result.negate();
        }
        return result;
    }
}

