/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4cics.commareaparser;

import it.imolinfo.jbi4cics.exception.ParseException;
import it.imolinfo.jbi4cics.typemapping.cobol.CobolType;
import it.imolinfo.jbi4cics.typemapping.cobol.CobolTypeDescriptor;

public class PictureDefinition {
    public static final int NUMERIC = 0;
    public static final int STRING = 1;
    private int type;
    private int stringLength;
    private int integerLength;
    private int decimalLength;
    private boolean signed;
    private boolean signPlus;

    public int getDecimalLength() {
        return this.decimalLength;
    }

    public void setDecimalLength(int decimalLength) {
        this.decimalLength = decimalLength;
    }

    public int getIntegerLength() {
        return this.integerLength;
    }

    public void setIntegerLength(int integerLength) {
        this.integerLength = integerLength;
    }

    public int getStringLength() {
        return this.stringLength;
    }

    public void setStringLength(int stringLength) {
        this.stringLength = stringLength;
    }

    public int getType() {
        return this.type;
    }

    public final void setType(int type) {
        this.type = type;
    }

    public void populate(CobolTypeDescriptor cobolTypeDescriptor) throws ParseException {
        switch (this.type) {
            case 0: {
                cobolTypeDescriptor.setType(CobolType.ZONED);
                cobolTypeDescriptor.setDecimalPartLength(this.decimalLength);
                cobolTypeDescriptor.setIntegerPartLength(this.integerLength);
                cobolTypeDescriptor.setSigned(this.signed);
                if (!this.signPlus) break;
                cobolTypeDescriptor.setZonedSignFormat(2);
                break;
            }
            case 1: {
                cobolTypeDescriptor.setType(CobolType.STRING);
                cobolTypeDescriptor.setStringLength(this.stringLength);
                cobolTypeDescriptor.setPadCharacter(" ");
                cobolTypeDescriptor.setJustification(0);
                break;
            }
            default: {
                throw new ParseException("CIC000002_Unrecognized_type", new Object[]{this.type});
            }
        }
    }

    public boolean isSigned() {
        return this.signed;
    }

    public void setSigned(boolean signed) {
        this.signed = signed;
    }

    public boolean isSignPlus() {
        return this.signPlus;
    }

    public void setSignPlus(boolean signPlus) {
        this.signPlus = signPlus;
    }
}

