/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.colorchooser;

import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.swing.colorchooser.ColorChooser;
import org.netbeans.swing.colorchooser.Palette;

class PalettePopup
extends MouseAdapter
implements MouseMotionListener,
PropertyChangeListener {
    private Popup pop = null;
    private PalettePanel panel = null;
    private Palette pal = null;
    private static PalettePopup defaultInstance = null;
    private ColorChooser lastOwner;
    private Point lastCoords;

    private PalettePopup() {
    }

    public static PalettePopup getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new PalettePopup();
        }
        return defaultInstance;
    }

    private PalettePanel getPalettePanel() {
        if (this.panel == null) {
            this.panel = new PalettePanel();
        }
        return this.panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPalette(Palette palette) {
        if (palette != this.pal) {
            if (this.isPopupVisible()) {
                Dimension dimension;
                Dimension dimension2 = palette.getSize();
                if (dimension2.equals(dimension = this.pal.getSize())) {
                    this.panel.setPalette(palette);
                    this.panel.repaint();
                } else {
                    Object object = this.lastOwner.getTreeLock();
                    synchronized (object) {
                        this.pop.hide();
                        this.panel.setPalette(palette);
                        this.pop = PopupFactory.getSharedInstance().getPopup(this.lastOwner, this.getPalettePanel(), this.lastCoords.x, this.lastCoords.y);
                        this.pop.show();
                    }
                }
            }
            this.pal = palette;
        }
    }

    private Palette getPalette() {
        return this.pal;
    }

    public void showPopup(ColorChooser colorChooser, Point point) {
        if (this.pal == null) {
            throw new IllegalStateException("No palette specified");
        }
        this.setPopupOwner(colorChooser);
        this.lastCoords = point;
        if (this.pop != null) {
            this.pop.hide();
            this.pop = null;
        }
        PalettePanel palettePanel = this.getPalettePanel();
        palettePanel.setPalette(this.getPalette());
        this.pop = PopupFactory.getSharedInstance().getPopup(colorChooser, palettePanel, point.x, point.y);
        this.pop.show();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(this);
    }

    private void setPopupOwner(ColorChooser colorChooser) {
        if (this.lastOwner == colorChooser) {
            return;
        }
        if (this.lastOwner != null) {
            this.detachFromOwner();
        }
        this.attachToOwner(colorChooser);
    }

    private void detachFromOwner() {
        if (this.lastOwner != null) {
            this.lastOwner.removeMouseMotionListener(this);
            this.lastOwner.removeMouseListener(this);
        }
        this.lastOwner = null;
    }

    private void attachToOwner(ColorChooser colorChooser) {
        this.lastOwner = colorChooser;
        colorChooser.addMouseListener(this);
        colorChooser.addMouseMotionListener(this);
    }

    public void hidePopup(ColorChooser colorChooser) {
        if (colorChooser != this.lastOwner) {
            return;
        }
        this.hidePopup();
    }

    private void hidePopup() {
        if (this.pop != null) {
            this.pop.hide();
            this.pop = null;
            this.detachFromOwner();
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(this);
        }
    }

    private boolean isPopupVisible() {
        return this.pop != null;
    }

    public boolean isPopupVisible(ColorChooser colorChooser) {
        return this.lastOwner == colorChooser && this.isPopupVisible();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        SwingUtilities.convertPointToScreen(point, this.lastOwner);
        this.convertPointToPalette(point);
        Dimension dimension = this.panel.getOffset();
        if (dimension != null) {
            point.x -= dimension.width;
            point.y -= dimension.height;
        }
        if (point.x >= 0 && point.y >= 0 && point.x <= this.pal.getSize().width && point.y < this.pal.getSize().height) {
            this.lastOwner.setTransientColor(this.pal.getColorAt(point.x, point.y));
            this.panel.setDisplayTitle(this.pal.getNameAt(point.x, point.y));
        } else {
            this.lastOwner.setTransientColor(null);
            this.panel.setDisplayTitle(null);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private void convertPointToPalette(Point point) {
        point.x -= this.lastCoords.x;
        point.y -= this.lastCoords.y;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object;
        if ("focusOwner".equals(propertyChangeEvent.getPropertyName()) && (object = propertyChangeEvent.getNewValue()) != this.panel && object != this.lastOwner) {
            this.hidePopup();
        }
    }

    private class PalettePanel
    extends JComponent {
        private Palette pal = null;
        private String title = null;

        private PalettePanel() {
        }

        public void setPalette(Palette palette) {
            Dimension dimension = null;
            if (palette != null && this.isShowing()) {
                dimension = palette.getSize();
            }
            this.pal = palette;
            if (dimension != null && palette != null && !palette.getSize().equals(dimension)) {
                this.firePropertyChange("preferredSize", dimension, palette.getSize());
            }
        }

        public Dimension getOffset() {
            if (this.pal == null || this.pal.getDisplayName() == null) {
                return null;
            }
            return new Dimension(0, (this.getPreferredSize().height - this.pal.getSize().height) / 2);
        }

        public void paintComponent(Graphics graphics) {
            int n;
            Dimension dimension = this.pal.getSize();
            int n2 = this.getHeight() - dimension.height;
            if (this.pal.getDisplayName() != null) {
                GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, UIManager.getColor("controlHighlight"), 0.0f, n2 / 2, UIManager.getColor("controlShadow"));
                ((Graphics2D)graphics).setPaint(gradientPaint);
                graphics.fillRect(0, 0, this.getWidth(), n2 / 2);
                String string = this.pal.getDisplayName();
                graphics.setFont(this.getFont().deriveFont(1, this.getFont().getSize() - 2));
                int n3 = graphics.getFontMetrics(graphics.getFont()).getHeight();
                n = graphics.getFontMetrics(graphics.getFont()).stringWidth(string);
                int n4 = this.getWidth() / 2 - n / 2;
                graphics.setColor(UIManager.getColor("controlShadow"));
                graphics.drawLine(0, 0, this.getWidth() - 1, 0);
                graphics.drawLine(0, 0, 0, n2 / 2 - 1);
                graphics.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, n2 / 2 - 1);
                graphics.setColor(UIManager.getColor("textText"));
                graphics.drawString(string, n4, n3 - 3);
                graphics.translate(0, n2 / 2);
            }
            this.pal.paintTo(graphics);
            int n5 = this.pal.getDisplayName() == null ? n2 : n2 / 2;
            int n6 = this.pal.getDisplayName() == null ? this.getHeight() : this.getHeight() - n5;
            GradientPaint gradientPaint = new GradientPaint(0.0f, this.getHeight() - n2, UIManager.getColor("controlHighlight"), 0.0f, n6, UIManager.getColor("controlShadow"));
            ((Graphics2D)graphics).setPaint(gradientPaint);
            graphics.fillRect(0, this.getHeight() - n2, this.getWidth(), n5);
            if (this.title != null) {
                graphics.setColor(UIManager.getColor("textText"));
                graphics.setFont(this.getFont().deriveFont(0, this.getFont().getSize() - 2));
                n = this.getWidth() - graphics.getFontMetrics(graphics.getFont()).stringWidth(this.title) - 3;
                graphics.drawString(this.title, n, this.getHeight() - (this.pal.getDisplayName() == null ? 4 : n2 / 2 + 4));
            }
            graphics.setColor(UIManager.getColor("controlShadow"));
            graphics.drawLine(0, this.getHeight() - n2, 0, this.getHeight());
            graphics.drawLine(0, this.getHeight() - (n5 + 1), this.getWidth() - 1, this.getHeight() - (n5 + 1));
            graphics.drawLine(this.getWidth() - 1, this.getHeight() - (n5 + 1), this.getWidth() - 1, this.getHeight() - n2);
        }

        public void setDisplayTitle(String string) {
            if (string != this.title && (string != null != (this.title != null) || string != null && !string.equals(this.title))) {
                this.title = string;
                this.repaint();
            }
            if (string == null && this.title != null) {
                this.title = null;
                this.repaint();
            }
        }

        public Dimension getPreferredSize() {
            if (this.pal != null) {
                Dimension dimension = new Dimension(this.pal.getSize());
                int n = 14;
                if (PalettePopup.this.lastOwner != null) {
                    Graphics graphics = PalettePopup.this.lastOwner.getGraphics();
                    if (graphics == null) {
                        graphics = new BufferedImage(1, 1, 2).getGraphics();
                    }
                    if (graphics != null) {
                        n = graphics.getFontMetrics(this.getFont().deriveFont(0, this.getFont().getSize() - 2)).getHeight();
                    }
                }
                if (this.pal.getDisplayName() != null) {
                    n *= 2;
                }
                dimension.height += n;
                return dimension;
            }
            return new Dimension(10, 10);
        }
    }
}

