/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4corba.webservice.runtime;

import it.imolinfo.jbi4corba.Logger;
import it.imolinfo.jbi4corba.LoggerFactory;
import it.imolinfo.jbi4corba.jbi.Messages;
import it.imolinfo.jbi4corba.webservice.descriptor.ProviderServiceDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.service.invoker.Invoker;
import org.omg.CORBA.Object;

public final class ProviderServiceInvoker
implements Invoker {
    private static final Logger LOG = LoggerFactory.getLogger(ProviderServiceInvoker.class);
    private static final Messages MESSAGES = Messages.getMessages(ProviderServiceInvoker.class);
    private ProviderServiceDescriptor serviceDescriptor;

    public ProviderServiceInvoker() {
    }

    public ProviderServiceInvoker(ProviderServiceDescriptor serviceDescriptor) {
        this.serviceDescriptor = serviceDescriptor;
    }

    public java.lang.Object invoke(Method method, java.lang.Object[] args, MessageContext messageContext) throws XFireFault {
        LOG.debug(">>>>> invoke - begin");
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.serviceDescriptor.getUrlClassLoader());
        Object object = this.serviceDescriptor.getCorbaObjectReference();
        try {
            LOG.debug("invoking corba object: " + object + "; with method: " + method + "; args=" + Arrays.toString(args));
            if (object._non_existent()) {
                LOG.error("CRB000734_Object_non_existent", object);
                throw new XFireFault(MESSAGES.getString("CRB000734_Object_non_existent", object), XFireFault.SOAP11_SERVER);
            }
            LOG.debug("object._non_existent() = false");
            LOG.debug("<<<<< invoke - end");
            java.lang.Object object2 = method.invoke((java.lang.Object)object, args);
            return object2;
        }
        catch (IllegalAccessException e) {
            LOG.error("CRB000735_Error_invoking_corba_object", new java.lang.Object[]{object, method}, e);
            throw new XFireFault(MESSAGES.getString("CRB000735_Error_invoking_corba_object", object, method), (Throwable)e, XFireFault.SOAP11_SERVER);
        }
        catch (InvocationTargetException e) {
            LOG.error("CRB000735_Error_invoking_corba_object", new java.lang.Object[]{object, method}, e.getTargetException());
            throw new XFireFault(MESSAGES.getString("CRB000735_Error_invoking_corba_object", object, method), e.getTargetException(), XFireFault.SOAP11_SERVER);
        }
        catch (RuntimeException e) {
            LOG.error("CRB000735_Error_invoking_corba_object", new java.lang.Object[]{object, method}, e.getCause());
            throw new XFireFault(MESSAGES.getString("CRB000735_Error_invoking_corba_object", object, method), e.getCause(), XFireFault.SOAP11_SERVER);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }
}

