/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4corba.webservice.generator.bcm;

import it.imolinfo.jbi4corba.Logger;
import it.imolinfo.jbi4corba.LoggerFactory;
import it.imolinfo.jbi4corba.webservice.generator.bcm.SerializableInspectorAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Type;

public class SerializableDecorationAdapter
extends SerializableInspectorAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(SerializableDecorationAdapter.class);
    protected Long newSerialVersionUid = 0L;

    public SerializableDecorationAdapter(ClassVisitor cv, Long aNewSerialVersionUid) {
        super(cv);
        this.newSerialVersionUid = aNewSerialVersionUid != null ? aNewSerialVersionUid : new Long(0L);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        String[] implementsArray = interfaces;
        if (!this.implementsSerializable(interfaces)) {
            LOG.debug("The class " + name + " does not implement Serializable.");
            int implementsSize = interfaces == null ? 0 : interfaces.length;
            implementsArray = new String[implementsSize + 1];
            if (implementsSize == 0) {
                implementsArray[0] = "java/io/Serializable";
            } else {
                System.arraycopy(interfaces, 0, implementsArray, 0, implementsSize);
                implementsArray[implementsSize] = "java/io/Serializable";
            }
        }
        super.visit(version, access, name, signature, superName, implementsArray);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        LOG.debug("visitField. access=" + access + "; name=" + name + "; desc=" + desc + "; signature=" + signature + "; value=" + value);
        if (this.hasSerialVersionUIDField(name, desc)) {
            LOG.debug("The class " + name + " has a serial version UID:" + value);
            value = this.newSerialVersionUid;
        }
        return super.visitField(access, name, desc, signature, value);
    }

    public void visitEnd() {
        if (this.getClassMetaInfo().getClassSerialVersionUid() == null) {
            super.visitField(26, "serialVersionUID", Type.LONG_TYPE.getDescriptor(), null, this.newSerialVersionUid);
            this.getClassMetaInfo().setClassSerialVersionUid(this.newSerialVersionUid);
        }
    }
}

