/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4corba.webservice.generator.bcm;

import it.imolinfo.jbi4corba.Logger;
import it.imolinfo.jbi4corba.LoggerFactory;
import it.imolinfo.jbi4corba.exception.Jbi4CorbaRuntimeException;
import it.imolinfo.jbi4corba.webservice.generator.bcm.ByteCodeManipulationUtil;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.util.TraceMethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppenderMethodVisitor
extends TraceMethodVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(AppenderMethodVisitor.class);
    private Map<String, String> mapOfFields = new HashMap<String, String>();
    private String className = null;
    private ByteCodeManipulationUtil bcmUtil = new ByteCodeManipulationUtil();

    public AppenderMethodVisitor(MethodVisitor mv, Map<String, String> mapOfFields, String className) {
        super(mv);
        this.mapOfFields = mapOfFields;
        this.className = className;
    }

    public void visitInsn(int opcode) {
        LOG.debug(">>>>> AppenderMethodVisitor.visitInsn - begin");
        if (177 == opcode) {
            for (String k : this.mapOfFields.keySet()) {
                String v = this.mapOfFields.get(k);
                LOG.debug("mapOfFields[" + k + "]=" + v);
                this.initField(k, v, (MethodVisitor)this);
            }
        }
        LOG.debug("<<<<< AppenderMethodVisitor.visitInsn - end");
        super.visitInsn(opcode);
    }

    private void initField(String fieldName, String fieldType, MethodVisitor mv) {
        LOG.debug(">>>>> initField - begin");
        LOG.debug("fieldName=" + fieldName + "; fieldType=" + fieldType + "; Type.getType(fieldType)=" + Type.getType((String)fieldType));
        String jtype = Type.getType((String)fieldType).getClassName();
        if (!jtype.endsWith("[]")) {
            LOG.debug(jtype + " is NOT an array ... " + "the variable will not be initialized.");
            return;
        }
        LOG.debug(jtype + " is an ARRAY.");
        Label label = new Label();
        mv.visitLabel(label);
        mv.visitLineNumber(5, label);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(3);
        String obj = jtype.substring(0, jtype.length() - 2);
        if (this.isAnObject(jtype)) {
            mv.visitTypeInsn(189, this.replaceDotWithSlash(obj));
        } else {
            mv.visitIntInsn(188, this.getOpcode(obj));
        }
        mv.visitFieldInsn(181, this.bcmUtil.bytecodeClassName(this.className), fieldName, fieldType);
        LOG.debug("<<<<< initField - end");
    }

    private int getOpcode(String jtype) {
        if (Boolean.TYPE.getCanonicalName().equals(jtype)) {
            return 4;
        }
        if (Byte.TYPE.getCanonicalName().equals(jtype)) {
            return 8;
        }
        if (Character.TYPE.getCanonicalName().equals(jtype)) {
            return 5;
        }
        if (Double.TYPE.getCanonicalName().equals(jtype)) {
            return 7;
        }
        if (Float.TYPE.getCanonicalName().equals(jtype)) {
            return 6;
        }
        if (Integer.TYPE.getCanonicalName().equals(jtype)) {
            return 10;
        }
        if (Long.TYPE.getCanonicalName().equals(jtype)) {
            return 11;
        }
        if (Short.TYPE.getCanonicalName().equals(jtype)) {
            return 9;
        }
        LOG.error("CRB000600_Dont_match_any_primitive_java_types", jtype);
        throw new Jbi4CorbaRuntimeException("CRB000600_Dont_match_any_primitive_java_types", new Object[]{jtype}, null);
    }

    private String replaceDotWithSlash(String s) {
        LOG.debug("replaceDotWithSlash. the input is " + s);
        if (s == null) {
            LOG.debug("replaceDotWithSlash. the input is null. returning empty String");
            return "";
        }
        if ("".equals(s)) {
            LOG.debug("replaceDotWithSlash. the input is an empty String. returning empty String");
            return "";
        }
        String res = s.replaceAll("\\.", "/");
        LOG.debug("replaceDotWithSlash.The input is " + s + " returning " + res);
        return res;
    }

    private boolean isAnObject(String jtype) {
        if (jtype.indexOf(46) == -1) {
            LOG.debug(jtype + " is a PRIMITIVE");
            return false;
        }
        LOG.debug(jtype + " is an OBJECT.");
        return true;
    }
}

