/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4corba.webservice.generator.bcm;

import it.imolinfo.jbi4corba.Logger;
import it.imolinfo.jbi4corba.LoggerFactory;
import it.imolinfo.jbi4corba.webservice.generator.bcm.AnnotationValue;
import it.imolinfo.jbi4corba.webservice.generator.bcm.AnnotationVisibleAndValue;
import it.imolinfo.jbi4corba.webservice.generator.bcm.AnnotationsMaps;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationWriterAdapter
extends ClassAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotationWriterAdapter.class);
    public AnnotationsMaps tracer;
    protected ClassWriter classWriter = null;
    protected String className = null;

    public AnnotationWriterAdapter(ClassVisitor cv, AnnotationsMaps tracer) {
        super(cv);
        this.tracer = tracer;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        Map<String, AnnotationVisibleAndValue> ann = this.tracer.annotationOnClass;
        if (ann == null) {
            LOG.debug("visit. NO ANNOTATIONS FOR " + name);
            return;
        }
        for (String annDesc : ann.keySet()) {
            AnnotationVisibleAndValue annotationVisibleAndValue = ann.get(annDesc);
            if (annotationVisibleAndValue == null) {
                LOG.debug("skip ... " + annDesc);
                continue;
            }
            LOG.debug("Annotation. desc=" + annDesc + "; visible=" + annotationVisibleAndValue.visible);
            AnnotationVisitor annVisitor = super.visitAnnotation(annDesc, annotationVisibleAndValue.visible.booleanValue());
            this.writeAnnotationValue(annVisitor, annotationVisibleAndValue.value);
            annVisitor.visitEnd();
        }
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
        Map<String, AnnotationVisibleAndValue> ann = this.tracer.annotationOnMethod.get(name);
        if (ann == null) {
            LOG.debug("visitMethod. NO ANNOTATIONS FOR " + name);
            return methodVisitor;
        }
        for (String annName : ann.keySet()) {
            AnnotationVisibleAndValue annotationVisibleAndValue = ann.get(annName);
            if (annotationVisibleAndValue == null) continue;
            AnnotationVisitor annVisitor = methodVisitor.visitAnnotation(annName, annotationVisibleAndValue.visible.booleanValue());
            this.writeAnnotationValue(annVisitor, annotationVisibleAndValue.value);
            annVisitor.visitEnd();
        }
        return methodVisitor;
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        FieldVisitor fieldVisitor = super.visitField(access, name, desc, signature, value);
        Map<String, AnnotationVisibleAndValue> ann = this.tracer.annotationOnField.get(name);
        if (ann == null) {
            LOG.debug("visitField. NO ANNOTATIONS FOR " + name);
            return fieldVisitor;
        }
        for (String annName : ann.keySet()) {
            AnnotationVisibleAndValue annotationVisibleAndValue = ann.get(annName);
            if (annotationVisibleAndValue == null) {
                LOG.debug("skip ... " + annName);
                continue;
            }
            AnnotationVisitor annVisitor = fieldVisitor.visitAnnotation(annName, annotationVisibleAndValue.visible.booleanValue());
            this.writeAnnotationValue(annVisitor, annotationVisibleAndValue.value);
            annVisitor.visitEnd();
        }
        return fieldVisitor;
    }

    private void writeAnnotationValue(AnnotationVisitor visitor, List<AnnotationValue> valueList) {
        if (valueList == null) {
            LOG.debug("No annotation value.");
            return;
        }
        for (AnnotationValue annValue : valueList) {
            LOG.debug("AnnotationValue[" + annValue.type + "]. name=" + annValue.name + "; desc=" + annValue.desc + "; value=" + annValue.value);
            switch (annValue.type) {
                case 0: {
                    visitor.visit(annValue.name, annValue.value);
                    break;
                }
                case 1: {
                    AnnotationVisitor visitorNested = visitor.visitAnnotation(annValue.name, annValue.desc);
                    this.writeAnnotationValue(visitorNested, annValue.nestedAnnotationValue);
                    break;
                }
                case 2: {
                    AnnotationVisitor visitorArray = visitor.visitArray(annValue.name);
                    this.writeAnnotationValue(visitorArray, annValue.nestedAnnotationValue);
                    visitorArray.visitEnd();
                    break;
                }
                case 3: {
                    visitor.visitEnum(annValue.name, annValue.desc, (String)annValue.value);
                }
            }
        }
    }
}

