/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4corba.webservice.generator;

import com.sun.tools.corba.se.idl.toJavaPortable.Compile;
import it.imolinfo.jbi4corba.Logger;
import it.imolinfo.jbi4corba.LoggerFactory;
import it.imolinfo.jbi4corba.exception.ClassGenerationException;
import it.imolinfo.jbi4corba.exception.Jbi4CorbaException;
import it.imolinfo.jbi4corba.jbi.JbiServiceDescriptor;
import it.imolinfo.jbi4corba.webservice.generator.ClientCorbaClassesHolder;
import it.imolinfo.jbi4corba.webservice.generator.CodeGenerationProperties;
import it.imolinfo.jbi4corba.webservice.generator.MethodSignature;
import it.imolinfo.jbi4corba.webservice.generator.Util;
import it.imolinfo.jbi4corba.webservice.generator.bcm.IdlToWsdlAdapter;
import it.imolinfo.jbi4corba.webservice.generator.bcm.WebServiceAnnotationAdapter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.util.CheckClassAdapter;
import org.objectweb.asm.util.TraceClassVisitor;
import org.omg.CORBA.Object;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProviderServiceClassesGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(ProviderServiceClassesGenerator.class);
    protected CodeGenerationProperties codeGenerationProperties = new CodeGenerationProperties();
    private URLClassLoader urlClassLoader;

    public ProviderServiceClassesGenerator() {
    }

    public ProviderServiceClassesGenerator(CodeGenerationProperties prop) {
        this.codeGenerationProperties = prop;
    }

    public List<ClientCorbaClassesHolder> generateProviderServiceClasses(JbiServiceDescriptor serviceDescriptor, String workdir, String libDirName) throws ClassGenerationException {
        LOG.debug(">>>>> generateProviderServiceClasses - begin");
        List<String> jars = null;
        if (this.codeGenerationProperties.isValueTypeImplementationWithToStringAndEquals()) {
            jars = Util.prepareClassPath(libDirName);
        }
        List<ClientCorbaClassesHolder> list = this.generateProviderServiceClasses(serviceDescriptor, workdir, jars);
        LOG.debug(">>>>> generateProviderServiceClasses - end");
        return list;
    }

    public List<ClientCorbaClassesHolder> generateProviderServiceClasses(JbiServiceDescriptor serviceDescriptor, String workdir, List<String> jars) throws ClassGenerationException {
        LOG.debug(">>>>> generateProviderServiceClasses - begin");
        String workdirsrc = workdir + "/src";
        String workdirclasses = workdir + "/classes";
        String idlFilename = serviceDescriptor.getIdlFileNameDirectory() + "/" + serviceDescriptor.getIdlFileName();
        LOG.debug("JbiServiceDescriptor=" + serviceDescriptor + "; workdir=" + workdir + "; workdirsrc=" + workdirsrc + "; workdirclasses=" + workdirclasses + "; idlFilename=" + idlFilename);
        this.idlj(workdirsrc, serviceDescriptor.getIdlFileNameDirectory(), idlFilename);
        Map<String, List<MethodSignature>> mapOperationsMethod = Util.extractMethodSignatureOfTheCorbaOperations(workdirsrc);
        List<String> vtList = Util.valueTypesImpl(workdirsrc, this.codeGenerationProperties.isValueTypeImplementationWithToStringAndEquals());
        LOG.debug("end creating java sources implementation for value types.");
        List<String> javaSources = null;
        try {
            javaSources = Util.findJavaSources(workdir);
            LOG.debug("find java sources ... done");
        }
        catch (Jbi4CorbaException e) {
            java.lang.Object[] args = new java.lang.Object[]{workdir};
            LOG.error("CRB000522_Error_finding_java_classes", args, e);
            throw new ClassGenerationException("CRB000522_Error_finding_java_classes", args, e);
        }
        Util.compileJavaClasses(workdirsrc, workdirclasses, javaSources, jars, null);
        LOG.debug("compileJavaClasses 1 of 2 ... done");
        Map<String, List<String>> corbaEnumMap = Util.replaceCorbaEnumaration(workdirsrc, workdirclasses);
        javaSources = null;
        try {
            javaSources = Util.findJavaSources(workdir);
            LOG.debug("find java sources ... done");
        }
        catch (Jbi4CorbaException e) {
            java.lang.Object[] args = new java.lang.Object[]{workdir};
            LOG.error("CRB000522_Error_finding_java_classes", args, e);
            throw new ClassGenerationException("CRB000522_Error_finding_java_classes", args, e);
        }
        Util.compileJavaClasses(workdirsrc, workdirclasses, javaSources, jars, null);
        LOG.debug("compileJavaClasses 2 of 2 ... done");
        Map<String, List<String>> onewayMap = Util.findOnewayOperations(workdirclasses);
        this.updateOnewayMethodSignature(onewayMap, mapOperationsMethod);
        for (String corbaOperation : mapOperationsMethod.keySet()) {
            this.tweakCorbaOperation(corbaOperation, workdirclasses, mapOperationsMethod.get(corbaOperation));
        }
        Set<Class> cs = Util.findClassUsedInTheOperations(workdirclasses);
        if (cs == null || cs.size() == 0) {
            LOG.debug("No class to tweak.");
        } else {
            Iterator<Class> i = cs.iterator();
            while (i.hasNext()) {
                String fullname = i.next().getName();
                if (corbaEnumMap.containsKey(fullname)) {
                    LOG.debug("(SKIPPED) tweaking for " + fullname);
                    continue;
                }
                LOG.debug("tweaking for " + fullname);
                String f = this.replaceDotWithSlash(fullname) + ".class";
                this.tweakIdlToWsdlClasses(f, workdirclasses);
            }
        }
        List<ClientCorbaClassesHolder> generatedServices = this.findGeneratedServices(workdirclasses);
        LOG.debug("generatedServices=" + generatedServices);
        Map<String, java.lang.Object> map = Util.valueTypeMapHandler(vtList, workdirclasses, this.getUrlClassLoader());
        for (ClientCorbaClassesHolder holder : generatedServices) {
            holder.setValueTypeIdAndInstance(map);
        }
        LOG.debug("<<<<<<<<<< generateProviderServiceClasses - end");
        return generatedServices;
    }

    protected void updateOnewayMethodSignature(Map<String, List<String>> onewayMap, Map<String, List<MethodSignature>> mapOperationsMethod) {
        Set<String> onewayClasses = onewayMap.keySet();
        for (String onewayClass : onewayClasses) {
            List<MethodSignature> methodSignatureList = mapOperationsMethod.get(onewayClass);
            LOG.debug("onewayClass=" + onewayClass + " => methodSignatureList=" + methodSignatureList);
            List<String> onewayMethodList = onewayMap.get(onewayClass);
            for (String onewayMethod : onewayMethodList) {
                boolean ok = this.setOnewayPropertyOnTheMethodSignature(onewayMethod, methodSignatureList);
                if (ok) continue;
                java.lang.Object[] args = new java.lang.Object[]{onewayMethod};
                LOG.warn("CRB000547_OnewayMethodNotFound", args);
            }
        }
    }

    protected boolean setOnewayPropertyOnTheMethodSignature(String onewayMethod, List<MethodSignature> methodSignatureList) {
        if (onewayMethod == null || methodSignatureList == null) {
            LOG.warn("CRB000548_NullParameter");
            return false;
        }
        boolean found = false;
        for (MethodSignature methodSignature : methodSignatureList) {
            if (!methodSignature.getMethodName().equals(onewayMethod)) continue;
            found = true;
            methodSignature.setOneway(true);
        }
        LOG.debug("oneway method found:" + found);
        return found;
    }

    private void tweakCorbaOperation(String qualifiedJavaName, String dir, List<MethodSignature> methodSignatureList) throws ClassGenerationException {
        ClassWriter cw = new ClassWriter(true);
        CheckClassAdapter cc = new CheckClassAdapter((ClassVisitor)cw);
        StringWriter sw = new StringWriter();
        TraceClassVisitor tv = new TraceClassVisitor((ClassVisitor)cc, new PrintWriter(sw));
        WebServiceAnnotationAdapter cv = new WebServiceAnnotationAdapter((ClassVisitor)tv, cw, methodSignatureList);
        String absPath = dir + File.separator + qualifiedJavaName.replace('.', File.separatorChar) + ".class";
        ClassReader cr = Util.getAsmCLassReader(absPath);
        cr.accept((ClassVisitor)cv, true);
        LOG.debug("ClassReader.accept ... done");
        LOG.debug("output of tracer during creation of class: " + absPath + "\n" + sw.toString());
        byte[] newBytecode = cw.toByteArray();
        Util.saveAsJavaClass(absPath, newBytecode);
    }

    private String tweakIdlToWsdlClasses(String className, String classesDirName) throws ClassGenerationException {
        LOG.debug(">>>>>>>>>> tweakIdlToWsdlClasses - begin");
        LOG.debug("tweakIdlToWsdlClasses; class: " + className + " in dir: " + classesDirName);
        ClassWriter cw = new ClassWriter(true);
        CheckClassAdapter cc = new CheckClassAdapter((ClassVisitor)cw);
        StringWriter sw = new StringWriter();
        TraceClassVisitor tv = new TraceClassVisitor((ClassVisitor)cc, new PrintWriter(sw));
        IdlToWsdlAdapter cv = new IdlToWsdlAdapter((ClassVisitor)tv, cw, className);
        ClassReader cr = Util.getAsmCLassReader(classesDirName, className);
        LOG.debug("getAsmCLassReader ... done");
        cr.accept((ClassVisitor)cv, true);
        LOG.debug("ClassReader.accept ... done");
        LOG.debug("output of tracer during creation of class: " + className + "\n" + sw.toString());
        byte[] newBytecode = cw.toByteArray();
        String relativeFileName = className.replace('/', File.separatorChar);
        Util.saveAsJavaClass(classesDirName, relativeFileName, newBytecode);
        LOG.debug("<<<<<<<<<< tweakIdlToWsdlClasses - end");
        return className.replace('/', '.');
    }

    private String replaceDotWithSlash(String s) {
        LOG.debug("replaceDotWithSlash. the input is " + s);
        if (s == null) {
            LOG.debug("replaceDotWithSlash. the input is null. returning empty String");
            return "";
        }
        if ("".equals(s)) {
            LOG.debug("replaceDotWithSlash. the input is an empty String. returning empty String");
            return "";
        }
        String res = s.replaceAll("\\.", "/");
        LOG.debug("replaceDotWithSlash. the input is " + s + " returning " + res);
        return res;
    }

    private List<ClientCorbaClassesHolder> findGeneratedServices(String classesDir) throws ClassGenerationException {
        LOG.debug(">>>>>>>>>> findGeneratedServices - begin");
        this.urlClassLoader = null;
        String protocol = null;
        try {
            protocol = System.getProperty("os.name").indexOf("Win") >= 0 ? "file:///" : "file://";
            File fcd = new File(classesDir);
            LOG.debug("ClassesDir.getAbsolutePath=" + fcd.getAbsolutePath());
            this.urlClassLoader = new URLClassLoader(new URL[]{new URL(protocol + fcd.getAbsolutePath() + "/")}, this.getClass().getClassLoader());
            LOG.debug("url classloader: " + Arrays.asList(this.urlClassLoader.getURLs()));
        }
        catch (MalformedURLException e) {
            java.lang.Object[] args = new java.lang.Object[]{protocol + new File(classesDir).getAbsolutePath() + "/"};
            LOG.error("CRB000526_Could_not_instantiate_the_url_class_loader", args, e);
            throw new ClassGenerationException("CRB000526_Could_not_instantiate_the_url_class_loader", args, e);
        }
        LOG.debug("classes dir: " + classesDir);
        List<Class> generatedClasses = Util.findGeneratedClasses(classesDir, this.urlClassLoader);
        LOG.debug("generated classes: " + generatedClasses);
        LOG.debug("<<<<<<<<<< findGeneratedServices - end");
        return this.filterInterfaceClasses(generatedClasses, this.urlClassLoader);
    }

    private List<ClientCorbaClassesHolder> filterInterfaceClasses(List<Class> classes, ClassLoader classLoader) {
        LOG.debug(">>>>>>>>>> filterInterfaceClasses - begin");
        ArrayList<ClientCorbaClassesHolder> result = new ArrayList<ClientCorbaClassesHolder>();
        for (Class clazz : classes) {
            if (clazz.isInterface() && Object.class.isAssignableFrom(clazz) && !clazz.getName().startsWith("org.omg")) {
                try {
                    LOG.debug("trying if [" + clazz.getName() + "Helper] exists");
                    Class<?> helperClass = classLoader.loadClass(clazz.getName() + "Helper");
                    LOG.debug("trying if [" + clazz.getName() + "Operations] exists");
                    Class<?> operationsClass = classLoader.loadClass(clazz.getName() + "Operations");
                    LOG.debug("adding " + clazz.getName() + " to service interfaces");
                    ClientCorbaClassesHolder corbaClasses = new ClientCorbaClassesHolder();
                    corbaClasses.setCorbaObjectClass(clazz);
                    corbaClasses.setOperationsClass(operationsClass);
                    corbaClasses.setHelperClass(helperClass);
                    LOG.debug("result.add - corbaClasses=" + corbaClasses);
                    result.add(corbaClasses);
                }
                catch (ClassNotFoundException e) {
                    String className = clazz.getName();
                    LOG.error("CRB000527_Class_Helper_or_Operations_not_found", new java.lang.Object[]{className, className}, e);
                }
                continue;
            }
            LOG.warn("Class not referred to a corba client:" + clazz.getName());
        }
        LOG.debug("<<<<<<<<<< filterInterfaceClasses - end. result:" + result);
        return result;
    }

    private void idlj(String targetdir, String includedir, String idlFilename) {
        LOG.debug(">>>>> idlj - begin");
        Compile.main((String[])new String[]{"-emitAll", "-fall", "-td", targetdir, "-i", includedir, idlFilename});
        LOG.debug("<<<<< idlj - end");
    }

    public URLClassLoader getUrlClassLoader() {
        return this.urlClassLoader;
    }

    protected void addEnumClass(String workdirsrc) throws ClassGenerationException {
        String enumFileName = "/it/imolinfo/jbi4corba/test/webservice/generator/EchoComplexEnum.java";
        String filename = workdirsrc + enumFileName;
        String enumSource = "package it.imolinfo.jbi4corba.test.webservice.generator; \n\npublic enum EchoComplexEnum implements org.omg.CORBA.portable.IDLEntity { \n\nE1, E2, E3;\n\npublic int value() {return ordinal();} \n\npublic static EchoComplexEnum from_int (int value) { return EchoComplexEnum.values()[value]; } \n\n}";
        try {
            PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(filename)));
            pw.println(enumSource);
            pw.flush();
            pw.close();
        }
        catch (IOException e) {
            LOG.info("IOException:" + e.getMessage(), e);
            e.printStackTrace();
            throw new ClassGenerationException("IOException:" + e.getMessage(), e);
        }
    }
}

