/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4corba.jbi.processor.wsdl11wrapper;

import it.imolinfo.jbi4corba.jbi.Messages;
import java.util.MissingResourceException;

public class WrapperProcessingException
extends Exception {
    private static final long serialVersionUID = -5817811262850840861L;
    private String localizedMessage;

    WrapperProcessingException(String message) {
        super(message);
        this.setupLocalizedMessage();
    }

    WrapperProcessingException(Throwable cause) {
        super(cause);
        this.localizedMessage = this.getMessage();
    }

    private void setupLocalizedMessage() {
        StackTraceElement[] stackTrace = this.getStackTrace();
        if (stackTrace.length == 0) {
            this.localizedMessage = this.getMessage();
        } else {
            try {
                Class<?> clazz = Class.forName(stackTrace[0].getClassName());
                Messages messages = Messages.getMessages(clazz);
                this.localizedMessage = messages.getString(this.getMessage(), new Object[0]);
            }
            catch (ClassNotFoundException e) {
                this.localizedMessage = this.getMessage();
            }
            catch (MissingResourceException e) {
                this.localizedMessage = this.getMessage();
            }
        }
    }

    public String getLocalizedMessage() {
        return this.localizedMessage;
    }
}

