/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.net.URISyntaxException;
import java.text.ParseException;
import net.fortuna.ical4j.data.CalendarParser;
import net.fortuna.ical4j.data.ContentHandler;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.data.UnfoldingReader;
import net.fortuna.ical4j.util.Strings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CalendarParserImpl
implements CalendarParser {
    private static final int WORD_CHAR_START = 32;
    private static final int WORD_CHAR_END = 255;
    private static final int WHITESPACE_CHAR_START = 0;
    private static final int WHITESPACE_CHAR_END = 20;
    private Log log = LogFactory.getLog((Class)CalendarParserImpl.class);

    public final void parse(InputStream in, ContentHandler handler) throws IOException, ParserException {
        this.parse(new InputStreamReader(in), handler);
    }

    public final void parse(Reader in, ContentHandler handler) throws IOException, ParserException {
        StreamTokenizer tokeniser = new StreamTokenizer(in);
        try {
            tokeniser.resetSyntax();
            tokeniser.wordChars(32, 255);
            tokeniser.whitespaceChars(0, 20);
            tokeniser.ordinaryChar(58);
            tokeniser.ordinaryChar(59);
            tokeniser.ordinaryChar(61);
            tokeniser.eolIsSignificant(true);
            tokeniser.whitespaceChars(0, 0);
            tokeniser.quoteChar(34);
            this.assertToken(tokeniser, "BEGIN");
            this.assertToken(tokeniser, 58);
            this.assertToken(tokeniser, "VCALENDAR", true);
            this.assertToken(tokeniser, 10);
            handler.startCalendar();
            this.parsePropertyList(tokeniser, handler);
            this.parseComponentList(tokeniser, handler);
            this.assertToken(tokeniser, 58);
            this.assertToken(tokeniser, "VCALENDAR", true);
            handler.endCalendar();
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof ParserException) {
                throw (ParserException)e;
            }
            int line = tokeniser.lineno();
            if (tokeniser.ttype == 10) {
                --line;
            }
            if (in instanceof UnfoldingReader) {
                int unfolded = ((UnfoldingReader)in).getLinesUnfolded();
                line += unfolded;
            }
            throw new ParserException(e.getMessage(), line, e);
        }
    }

    private void parsePropertyList(StreamTokenizer tokeniser, ContentHandler handler) throws IOException, ParseException, URISyntaxException, ParserException {
        this.assertToken(tokeniser, -3);
        while (!"END".equals(tokeniser.sval)) {
            if ("BEGIN".equals(tokeniser.sval)) {
                this.parseComponent(tokeniser, handler);
            } else {
                this.parseProperty(tokeniser, handler);
            }
            this.absorbWhitespace(tokeniser);
        }
    }

    private void parseProperty(StreamTokenizer tokeniser, ContentHandler handler) throws IOException, ParserException, URISyntaxException, ParseException {
        String name = tokeniser.sval;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Property [" + name + "]"));
        }
        handler.startProperty(name);
        this.parseParameterList(tokeniser, handler);
        StringBuffer value = new StringBuffer();
        int nextToken = tokeniser.nextToken();
        while (nextToken != 10 && nextToken != -1) {
            if (tokeniser.ttype == -3) {
                value.append(tokeniser.sval);
            } else if (tokeniser.ttype == 34) {
                value.append((char)tokeniser.ttype);
                value.append(tokeniser.sval);
                value.append((char)tokeniser.ttype);
            } else {
                value.append((char)tokeniser.ttype);
            }
            nextToken = tokeniser.nextToken();
        }
        if (nextToken == -1) {
            throw new ParserException("Unexpected end of file", tokeniser.lineno());
        }
        handler.propertyValue(Strings.unescape(value.toString()));
        handler.endProperty(name);
    }

    private void parseParameterList(StreamTokenizer tokeniser, ContentHandler handler) throws IOException, ParserException, URISyntaxException {
        while (tokeniser.nextToken() == 59) {
            this.parseParameter(tokeniser, handler);
        }
    }

    private void parseParameter(StreamTokenizer tokeniser, ContentHandler handler) throws IOException, ParserException, URISyntaxException {
        this.assertToken(tokeniser, -3);
        String paramName = tokeniser.sval;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Parameter [" + paramName + "]"));
        }
        this.assertToken(tokeniser, 61);
        StringBuffer paramValue = new StringBuffer();
        if (tokeniser.nextToken() == 34) {
            paramValue.append('\"');
            paramValue.append(tokeniser.sval);
            paramValue.append('\"');
        } else {
            paramValue.append(tokeniser.sval);
        }
        handler.parameter(paramName, Strings.unescape(paramValue.toString()));
    }

    private void parseComponentList(StreamTokenizer tokeniser, ContentHandler handler) throws IOException, ParseException, URISyntaxException, ParserException {
        while ("BEGIN".equals(tokeniser.sval)) {
            this.parseComponent(tokeniser, handler);
            this.absorbWhitespace(tokeniser);
        }
    }

    private void parseComponent(StreamTokenizer tokeniser, ContentHandler handler) throws IOException, ParseException, URISyntaxException, ParserException {
        this.assertToken(tokeniser, 58);
        this.assertToken(tokeniser, -3);
        String name = tokeniser.sval;
        handler.startComponent(name);
        this.assertToken(tokeniser, 10);
        this.parsePropertyList(tokeniser, handler);
        this.assertToken(tokeniser, 58);
        this.assertToken(tokeniser, name);
        this.assertToken(tokeniser, 10);
        handler.endComponent(name);
    }

    private void assertToken(StreamTokenizer tokeniser, int token) throws IOException, ParserException {
        if (tokeniser.nextToken() != token) {
            throw new ParserException("Expected [" + token + "], read [" + tokeniser.ttype + "]", tokeniser.lineno());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[" + token + "]"));
        }
    }

    private void assertToken(StreamTokenizer tokeniser, String token) throws IOException, ParserException {
        this.assertToken(tokeniser, token, false);
    }

    private void assertToken(StreamTokenizer tokeniser, String token, boolean ignoreCase) throws IOException, ParserException {
        this.assertToken(tokeniser, -3);
        if (ignoreCase ? !token.equalsIgnoreCase(tokeniser.sval) : !token.equals(tokeniser.sval)) {
            throw new ParserException("Expected [" + token + "], read [" + tokeniser.sval + "]", tokeniser.lineno());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[" + token + "]"));
        }
    }

    private void absorbWhitespace(StreamTokenizer tokeniser) throws IOException {
        try {
            while (true) {
                this.assertToken(tokeniser, 10);
            }
        }
        catch (ParserException pe) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Aborting absorbing extra whitespace [" + pe.getMessage() + "]"));
            }
            return;
        }
    }
}

