/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation.value;

import proguard.classfile.ClassFile;
import proguard.optimize.evaluation.value.ReferenceValue;
import proguard.optimize.evaluation.value.ReferenceValueFactory;
import proguard.optimize.evaluation.value.SpecificReferenceValue;

class SpecificArrayReferenceValue
extends SpecificReferenceValue {
    protected int dimension;

    public SpecificArrayReferenceValue(ClassFile classFile, int n, boolean bl) {
        super(classFile, bl);
        this.dimension = n;
    }

    public int dimension() {
        return this.dimension;
    }

    public ReferenceValue generalize(ReferenceValue referenceValue) {
        return referenceValue.generalize(this);
    }

    public int equal(ReferenceValue referenceValue) {
        return referenceValue.equal(this);
    }

    public int instanceOf(ClassFile classFile, int n) {
        if (this.value == null) {
            return -1;
        }
        if (classFile == null || n > this.dimension) {
            return 0;
        }
        if (n < this.dimension) {
            String string = classFile.getName();
            return string.equals("java/lang/Object") || string.equals("java/lang/Cloneable") || string.equals("java/io/Serializable") ? 1 : -1;
        }
        return this.value.extends_(classFile) || this.value.implements_(classFile) ? 1 : 0;
    }

    public ReferenceValue generalize(SpecificArrayReferenceValue specificArrayReferenceValue) {
        return this.value == specificArrayReferenceValue.value && this.dimension == specificArrayReferenceValue.dimension ? (this.mayBeNull ? this : specificArrayReferenceValue) : ReferenceValueFactory.create(this.mayBeNull || specificArrayReferenceValue.mayBeNull);
    }

    public int equal(SpecificArrayReferenceValue specificArrayReferenceValue) {
        return this.value == null && specificArrayReferenceValue.value == null ? 1 : 0;
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SpecificArrayReferenceValue specificArrayReferenceValue = (SpecificArrayReferenceValue)object;
        return this.mayBeNull == specificArrayReferenceValue.mayBeNull && (this.value == null ? specificArrayReferenceValue.value == null : this.value.equals(specificArrayReferenceValue.value)) && this.dimension == specificArrayReferenceValue.dimension;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ (this.value == null ? 0 : this.value.hashCode()) ^ this.dimension;
    }

    public String toString() {
        return "a:" + (this.value == null ? "null" : this.value.getName() + "[" + this.dimension + "]");
    }
}

