/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.tests.jfluid.memory;

import java.util.ArrayList;
import java.util.Collections;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.AppStatusHandler;
import org.netbeans.lib.profiler.client.ProfilingPointsProcessor;
import org.netbeans.lib.profiler.results.CCTProvider;
import org.netbeans.lib.profiler.results.EventBufferResultsProvider;
import org.netbeans.lib.profiler.results.ProfilingResultsDispatcher;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.memory.MemoryCCTProvider;
import org.netbeans.lib.profiler.results.memory.MemoryCallGraphBuilder;
import org.netbeans.lib.profiler.results.memory.MemoryProfilingResultsListener;
import org.netbeans.lib.profiler.tests.jfluid.CommonProfilerTestCase;
import org.netbeans.lib.profiler.tests.jfluid.utils.TestProfilerAppHandler;
import org.netbeans.lib.profiler.tests.jfluid.utils.TestProfilingPointsProcessor;
import org.netbeans.lib.profiler.tests.jfluid.utils.Utils;
import org.netbeans.lib.profiler.utils.StringUtils;

public abstract class MemoryTestCase
extends CommonProfilerTestCase {
    MemoryCallGraphBuilder builder = new MemoryCallGraphBuilder();
    MemoryResultListener resultListener = null;

    public MemoryTestCase(String name) {
        super(name);
    }

    protected void checkMemoryResults(TargetAppRunner targetAppRunner, String[] matchingPrefixes, MemoryResultListener resultListener) throws Exception {
        boolean gotResults = false;
        int retryCounter = 4;
        do {
            targetAppRunner.getProfilerClient().forceObtainedResultsDump();
        } while (!(gotResults = resultListener.wait4results(2500L)) && --retryCounter > 0);
        MemoryTestCase.assertTrue((String)"CallGraphBuilder: Results do not exist.", (boolean)gotResults);
        this.log("results obtained: " + System.currentTimeMillis());
        int[] totalAllocObjects = targetAppRunner.getProfilerClient().getAllocatedObjectsCountResults();
        String[] classnames = targetAppRunner.getProfilerClient().getStatus().getClassNames();
        long[] totalAllocObjectsSize = null;
        ArrayList<String> list = new ArrayList<String>(128);
        totalAllocObjectsSize = this.builder.getAllocObjectNumbers();
        for (int i = 0; i < totalAllocObjectsSize.length; ++i) {
            boolean match = false;
            for (int j = 0; j < matchingPrefixes.length; ++j) {
                if (!classnames[i].startsWith(matchingPrefixes[j])) continue;
                match = true;
                break;
            }
            if (!match) continue;
            StringBuffer out = new StringBuffer();
            out.append(this.complete(StringUtils.userFormClassName((String)classnames[i]), 32));
            out.append(this.complete(String.valueOf(totalAllocObjects[i]), 8));
            list.add(out.toString());
        }
        this.ref(this.complete("Name", 32) + this.complete("DCount", 8));
        try {
            MemoryCCTProvider.ObjectNumbersContainer liveness = this.builder.getLivenessObjectNumbers();
            totalAllocObjectsSize = liveness.trackedLiveObjectsSize;
            float[] avgage = liveness.avgObjectAge;
            int[] maxSurvGen = liveness.maxSurvGen;
            long[] ntrackedallocobjects = liveness.nTrackedAllocObjects;
            int[] ntrackedliveobjects = liveness.nTrackedLiveObjects;
            for (int i = 0; i < totalAllocObjectsSize.length; ++i) {
                boolean match = false;
                for (int j = 0; j < matchingPrefixes.length; ++j) {
                    if (!classnames[i].startsWith(matchingPrefixes[j])) continue;
                    match = true;
                    break;
                }
                if (!match) continue;
                StringBuffer out = new StringBuffer();
                out.append(this.complete(StringUtils.userFormClassName((String)classnames[i]), 32));
                out.append(this.complete(String.valueOf(ntrackedliveobjects[i]), 10));
                out.append(this.complete(String.valueOf(ntrackedallocobjects[i]), 8));
                list.add(out.toString());
            }
            this.ref(this.complete("Name", 32) + this.complete("LiveObjs", 10) + this.complete("Allocs", 8));
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        Collections.sort(list);
        for (int i = 0; i < list.size(); ++i) {
            this.ref(list.get(i));
        }
        this.ref("");
    }

    protected ProfilerEngineSettings initMemoryTest(String projectName, String className) {
        ProfilerEngineSettings settings = this.initTest(projectName, className, null);
        settings.setThreadCPUTimerOn(false);
        settings.setAllocTrackEvery(1);
        settings.setRunGCOnGetResultsInMemoryProfiling(true);
        return settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startMemoryTest(ProfilerEngineSettings settings, int instrMode, String[] classPrefixes) {
        MemoryTestCase.assertTrue((this.builder != null ? 1 : 0) != 0);
        TestProfilerAppHandler handler = new TestProfilerAppHandler(this);
        TargetAppRunner runner = new TargetAppRunner(settings, (AppStatusHandler)handler, (ProfilingPointsProcessor)new TestProfilingPointsProcessor());
        runner.addProfilingEventListener(Utils.createProfilingListener(this));
        this.builder.removeAllListeners();
        ProfilingResultsDispatcher.getDefault().removeAllListeners();
        this.resultListener = new MemoryResultListener();
        this.builder.addListener((CCTProvider.Listener)this.resultListener);
        ProfilingResultsDispatcher.getDefault().addListener((MemoryProfilingResultsListener)this.builder);
        this.builder.startup(runner.getProfilerClient());
        EventBufferResultsProvider.getDefault().startup(runner.getProfilerClient());
        try {
            MemoryTestCase.assertTrue((String)"not read calibration data", (boolean)runner.readSavedCalibrationData());
            Process p = this.startTargetVM(runner);
            MemoryTestCase.assertNotNull((String)"Target JVM is not started", (Object)p);
            this.bindStreams(p);
            runner.connectToStartedVMAndStartTA();
            runner.getProfilerClient().initiateMemoryProfInstrumentation(instrMode);
            this.waitForStatus(1);
            MemoryTestCase.assertTrue((String)"runner is not running", (boolean)runner.targetAppIsRunning());
            this.waitForStatus(6);
            if (!this.isStatus(4)) {
                this.waitForStatus(4);
            }
            this.checkMemoryResults(runner, classPrefixes, this.resultListener);
            this.setStatus(8);
        }
        catch (Exception ex) {
            this.log(ex);
            MemoryTestCase.assertTrue((String)("Exception thrown: " + ex.getMessage()), (boolean)false);
        }
        finally {
            ProfilingResultsDispatcher.getDefault().pause(true);
            this.builder.shutdown();
            this.builder.removeListener((CCTProvider.Listener)this.resultListener);
            ProfilingResultsDispatcher.getDefault().removeListener((MemoryProfilingResultsListener)this.builder);
            this.finalizeTest(runner);
        }
    }

    private static class MemoryResultListener
    implements MemoryCCTProvider.Listener {
        private final Object resultsLock = new Object();
        private boolean hasResults = false;

        private MemoryResultListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cctEstablished(RuntimeCCTNode appRootNode) {
            System.out.println("Memory CCT Established");
            Object object = this.resultsLock;
            synchronized (object) {
                this.hasResults = true;
                this.resultsLock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cctReset() {
            Object object = this.resultsLock;
            synchronized (object) {
                this.hasResults = false;
                this.resultsLock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean wait4results(long timeout) {
            Object object = this.resultsLock;
            synchronized (object) {
                if (!this.hasResults) {
                    try {
                        this.resultsLock.wait(timeout);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                return this.hasResults;
            }
        }
    }
}

