/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.tests.jfluid.cpu;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.tests.jfluid.cpu.CPUSnapshotTestCase;

public class CPUSnapshotTest
extends CPUSnapshotTestCase {
    public CPUSnapshotTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(CPUSnapshotTest.class);
        return suite;
    }

    public void testMethods() {
        ProfilerEngineSettings settings = this.initSnapshotTest("j2se-simple", "simple.cpu.Methods", null);
        this.startSnapshotTest(settings, new String[]{"simple.cpu.Methods", "method27", "()V"}, 0L, 1.0, new String[]{"sun", "java"});
    }

    public void testMethodsServer() {
        ProfilerEngineSettings settings = this.initSnapshotTest("j2se-simple", "simple.cpu.Methods", null);
        this.addJVMArgs(settings, "-server");
        this.startSnapshotTest(settings, new String[]{"simple.cpu.Methods", "method27", "()V"}, 0L, 1.0, new String[]{"sun", "java"});
    }

    public void testNoThreads() {
        ProfilerEngineSettings settings = this.initSnapshotTest("j2se-simple", "simple.cpu.Region", null);
        settings.setInstrumentSpawnedThreads(false);
        this.startSnapshotTest(settings, new String[]{"simple.cpu.Region", "run100", "()V"}, 0L, 1.0, new String[]{"sun", "java"});
    }

    public void testSimple() {
        ProfilerEngineSettings settings = this.initSnapshotTest("j2se-simple", "simple.CPU", null);
        this.startSnapshotTest(settings, new String[]{"simple.CPU", "test20", "()V"}, 0L, 1.0, new String[]{"sun", "java"});
    }

    public void testSimpleServer() {
        ProfilerEngineSettings settings = this.initSnapshotTest("j2se-simple", "simple.CPU", null);
        this.addJVMArgs(settings, "-server");
        this.startSnapshotTest(settings, new String[]{"simple.CPU", "test20", "()V"}, 0L, 1.0, new String[]{"sun", "java"});
    }

    public void testThreads() {
        ProfilerEngineSettings settings = this.initSnapshotTest("j2se-simple", "simple.cpu.Region", null);
        settings.setInstrumentSpawnedThreads(true);
        this.startSnapshotTest(settings, new String[]{"simple.cpu.Region", "run100", "()V"}, 0L, 1.0, new String[]{"sun", "java"});
    }

    public void testThreadsServer() {
        ProfilerEngineSettings settings = this.initSnapshotTest("j2se-simple", "simple.cpu.Region", null);
        this.addJVMArgs(settings, "-server");
        settings.setInstrumentSpawnedThreads(true);
        this.startSnapshotTest(settings, new String[]{"simple.cpu.Region", "run100", "()V"}, 0L, 1.0, new String[]{"sun", "java"});
    }

    public void testWaits() {
        ProfilerEngineSettings settings = this.initSnapshotTest("j2se-simple", "simple.cpu.WaitingTest", null);
        this.startSnapshotTest(settings, new String[]{"simple.cpu.WaitingTest", "method1000", "()V"}, 0L, 1.0, new String[]{"sun", "java"});
    }

    public void testWaitsServer() {
        ProfilerEngineSettings settings = this.initSnapshotTest("j2se-simple", "simple.cpu.WaitingTest", null);
        this.addJVMArgs(settings, "-server");
        this.startSnapshotTest(settings, new String[]{"simple.cpu.WaitingTest", "method1000", "()V"}, 0L, 1.0, new String[]{"sun", "java"});
    }
}

