/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri;

import java.util.List;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class InfoSetUtil {
    private static final Double ZERO = new Double(0.0);
    private static final Double ONE = new Double(1.0);
    private static final Double NOT_A_NUMBER = new Double(Double.NaN);

    public static String stringValue(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Number) {
            long l;
            double d = ((Number)object).doubleValue();
            if (d == (double)(l = ((Number)object).longValue())) {
                return String.valueOf(l);
            }
            return String.valueOf(d);
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? "true" : "false";
        }
        if (object == null) {
            return "";
        }
        if (object instanceof NodePointer) {
            return InfoSetUtil.stringValue(((NodePointer)object).getValue());
        }
        if (object instanceof EvalContext) {
            EvalContext ctx = (EvalContext)object;
            Pointer ptr = ctx.getSingleNodePointer();
            if (ptr != null) {
                return InfoSetUtil.stringValue(ptr);
            }
            return "";
        }
        if (object instanceof Node) {
            return (String)JXPathContext.newContext(object).getValue("string(.)");
        }
        return String.valueOf(object);
    }

    public static Number number(Object object) {
        if (object instanceof Number) {
            return (Number)object;
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? ONE : ZERO;
        }
        if (object instanceof String) {
            Double value;
            try {
                value = new Double((String)object);
            }
            catch (NumberFormatException ex) {
                value = NOT_A_NUMBER;
            }
            return value;
        }
        if (object instanceof EvalContext) {
            return InfoSetUtil.number(InfoSetUtil.stringValue(object));
        }
        if (object instanceof NodePointer) {
            return InfoSetUtil.number(((NodePointer)object).getValue());
        }
        return InfoSetUtil.number(InfoSetUtil.stringValue(object));
    }

    public static double doubleValue(Object object) {
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 0.0 : 1.0;
        }
        if (object instanceof String) {
            double value;
            if (object.equals("")) {
                return 0.0;
            }
            try {
                value = Double.parseDouble((String)object);
            }
            catch (NumberFormatException ex) {
                value = Double.NaN;
            }
            return value;
        }
        if (object instanceof NodePointer) {
            return InfoSetUtil.doubleValue(((NodePointer)object).getValue());
        }
        if (object instanceof EvalContext) {
            return InfoSetUtil.doubleValue(InfoSetUtil.stringValue(object));
        }
        return InfoSetUtil.doubleValue(InfoSetUtil.stringValue(object));
    }

    public static boolean booleanValue(Object object) {
        if (object instanceof Number) {
            double value = ((Number)object).doubleValue();
            return value != 0.0 && value != 0.0 && !Double.isNaN(value);
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof EvalContext) {
            EvalContext ctx = (EvalContext)object;
            List evalList = ctx.getContextNodeList();
            int size = evalList.size();
            switch (size) {
                case 0: {
                    return false;
                }
                case 1: {
                    return InfoSetUtil.booleanValue((NodePointer)evalList.get(0));
                }
            }
            return true;
        }
        if (object instanceof String) {
            String tempStr = (String)object;
            if (tempStr.equalsIgnoreCase("false")) {
                return false;
            }
            return tempStr.length() != 0;
        }
        if (object instanceof NodePointer) {
            if (!((NodePointer)object).isActual()) {
                return false;
            }
            return InfoSetUtil.booleanValue(((NodePointer)object).getNode());
        }
        if (object instanceof Element) {
            Element domElement = (Element)object;
            if (domElement.hasChildNodes() && domElement.getFirstChild().getNodeType() == 3) {
                return InfoSetUtil.booleanValue(domElement.getFirstChild().getNodeValue());
            }
        } else if (object == null) {
            return false;
        }
        return true;
    }
}

