/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.util;

import java.net.InetAddress;
import java.util.Random;

public class StringIdentifierGenerator {
    public static StringIdentifierGenerator INSTANCE = new StringIdentifierGenerator();
    private Random _randomForSpace = null;
    private Random _randomForTime = null;

    public synchronized String nextIdentifier() {
        long uniqueInSpace = this._randomForSpace.nextLong();
        long uniqueInTime = this._randomForTime.nextLong();
        return Long.toHexString(uniqueInSpace).toUpperCase() + "_" + Long.toHexString(uniqueInTime).toUpperCase();
    }

    public String nextIdentifier(String prefix) {
        return prefix + "_" + this.nextIdentifier();
    }

    private StringIdentifierGenerator() {
        long uniqueSpaceSeed = this.createUniqueSpaceSeed();
        long uniqueTimeSeed = System.currentTimeMillis();
        this._randomForSpace = new Random(uniqueSpaceSeed);
        this._randomForTime = new Random(uniqueTimeSeed);
    }

    private long createUniqueSpaceSeed() {
        StringBuffer hBuf = new StringBuffer(20);
        hBuf.append(Runtime.getRuntime().freeMemory());
        hBuf.append(Runtime.getRuntime().maxMemory());
        hBuf.append(Runtime.getRuntime().totalMemory());
        try {
            hBuf.append(InetAddress.getLocalHost());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hBuf.hashCode();
    }

    public synchronized String next16DigitIdentifier() {
        String hexSpaceValue = this.getNextUniqueInSpace();
        String hexTimeValue = this.getUniqueInTime();
        return "00000000".substring(0, 8 - hexSpaceValue.length()) + hexSpaceValue + "00000000".substring(0, 8 - hexTimeValue.length()) + hexTimeValue;
    }

    private String getUniqueInTime() {
        long uniqueInTime = this._randomForTime.nextLong();
        int maskedValue = (int)(uniqueInTime & 0xFFFFFFFFL);
        String hexTimeValue = Integer.toHexString(maskedValue).toUpperCase();
        return hexTimeValue;
    }

    private String getNextUniqueInSpace() {
        long uniqueInSpace = this._randomForSpace.nextLong();
        int maskedValue = (int)(uniqueInSpace & 0xFFFFFFFFL);
        String hexSpaceValue = Integer.toHexString(maskedValue).toUpperCase();
        return hexSpaceValue;
    }

    public synchronized String next32DigitIdentifier() {
        String hexSpaceValue = this.getNextUniqueInSpace();
        String hexTimeValue = this.getUniqueInTime();
        return "0000000000000000".substring(0, 16 - hexSpaceValue.length()) + hexSpaceValue + "0000000000000000".substring(0, 16 - hexTimeValue.length()) + hexTimeValue;
    }

    public String next32DigitIdentifier(String prefix) {
        return prefix + "_" + this.next32DigitIdentifier();
    }

    public String next16DigitIdentifier(String prefix) {
        return prefix + "_" + this.next16DigitIdentifier();
    }
}

