/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Comparator;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.DataTypeFactory;
import org.axiondb.types.ByteArrayBlob;
import org.axiondb.types.StringClob;
import org.axiondb.util.ComparableComparator;

public abstract class BaseDataType
implements DataType,
DataTypeFactory {
    private static final long serialVersionUID = -6298442558736380407L;

    public abstract DataType makeNewInstance();

    public abstract boolean accepts(Object var1);

    public abstract Object convert(Object var1) throws AxionException;

    public abstract Object read(DataInput var1) throws IOException;

    public abstract void write(Object var1, DataOutput var2) throws IOException;

    public abstract int getJdbcType();

    public String getPreferredValueClassName() {
        return "java.lang.Object";
    }

    public int compare(Object a, Object b) {
        return this.getComparator().compare(a, b);
    }

    protected Comparator getComparator() {
        return ComparableComparator.getInstance();
    }

    public int getColumnDisplaySize() {
        return 0;
    }

    public int getPrecision() {
        return 0;
    }

    public int getScale() {
        return 0;
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public boolean isCurrency() {
        return false;
    }

    public String getLiteralPrefix() {
        return null;
    }

    public String getLiteralSuffix() {
        return null;
    }

    public int getNullableCode() {
        return 1;
    }

    public short getSearchableCode() {
        return 2;
    }

    public boolean isUnsigned() {
        return false;
    }

    public boolean supportsSuccessor() {
        return false;
    }

    public Object successor(Object value) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public int getPrecisionRadix() {
        return 10;
    }

    protected Number toNumber(Object value) throws AxionException {
        if (null == value) {
            return null;
        }
        if (value instanceof Number) {
            return (Number)value;
        }
        throw new AxionException("Can't convert " + this.toString() + " to Number.");
    }

    public BigDecimal toBigDecimal(Object value) throws AxionException {
        Number num = this.toNumber(value);
        if (num instanceof BigDecimal) {
            return (BigDecimal)num;
        }
        if (null == num) {
            return null;
        }
        return new BigDecimal(String.valueOf(num));
    }

    public BigInteger toBigInteger(Object value) throws AxionException {
        Number num = this.toNumber(value);
        if (num instanceof BigInteger) {
            return (BigInteger)num;
        }
        if (null == num) {
            return null;
        }
        return new BigInteger(String.valueOf(num.longValue()));
    }

    public boolean toBoolean(Object value) throws AxionException {
        throw new AxionException("Can't convert " + this.toString() + " to boolean.");
    }

    public byte toByte(Object value) throws AxionException {
        return this.toNumber(value).byteValue();
    }

    public byte[] toByteArray(Object value) throws AxionException {
        throw new AxionException("Can't convert " + this.toString() + " to byte[].");
    }

    public Date toDate(Object value) throws AxionException {
        throw new AxionException("Can't convert " + this.toString() + " to Date.");
    }

    public double toDouble(Object value) throws AxionException {
        return this.toNumber(value).doubleValue();
    }

    public float toFloat(Object value) throws AxionException {
        return this.toNumber(value).floatValue();
    }

    public int toInt(Object value) throws AxionException {
        return this.toNumber(value).intValue();
    }

    public long toLong(Object value) throws AxionException {
        return this.toNumber(value).longValue();
    }

    public short toShort(Object value) throws AxionException {
        return this.toNumber(value).shortValue();
    }

    public String toString(Object value) throws AxionException {
        Object val = this.convert(value);
        if (val == null) {
            return null;
        }
        return val.toString();
    }

    public URL toURL(Object value) throws AxionException {
        String str = this.toString(value);
        if (null == str) {
            return null;
        }
        try {
            return new URL(str);
        }
        catch (MalformedURLException e) {
            throw new AxionException("Can't convert " + value + " to URL.");
        }
    }

    public Time toTime(Object value) throws AxionException {
        throw new AxionException("Can't convert " + this.toString() + " to Time.");
    }

    public Timestamp toTimestamp(Object value) throws AxionException {
        throw new AxionException("Can't convert " + this.toString() + " to Timestamp.");
    }

    public Clob toClob(Object value) throws AxionException {
        return new StringClob(this.toString(value));
    }

    public Blob toBlob(Object value) throws AxionException {
        if (null == value) {
            return null;
        }
        if (value instanceof byte[]) {
            return new ByteArrayBlob((byte[])value);
        }
        throw new AxionException("Can't convert " + this.toString() + " to Blob.");
    }
}

