/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.tools;

import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class BaseReport {
    private PrintWriter _writer;

    public BaseReport(PrintWriter pw) {
        this._writer = pw;
    }

    public void reportException(Exception e) {
        this._writer.println(e.toString());
    }

    public void reportUpdateCount(int count) {
        switch (count) {
            case -1: {
                this._writer.println("Executed.");
                break;
            }
            case 0: {
                this._writer.println("No rows changed.");
                break;
            }
            case 1: {
                this._writer.println("1 row changed.");
                break;
            }
            default: {
                this._writer.println(count + " rows changed.");
            }
        }
    }

    public void reportResultSet(ResultSet rset) throws SQLException {
        if (rset != null) {
            String label;
            int i;
            ResultSetMetaData meta = rset.getMetaData();
            int count = meta.getColumnCount();
            int[] colWidths = new int[count];
            List[] colValues = new List[count];
            for (i = 0; i < count; ++i) {
                label = meta.getColumnLabel(i + 1);
                if (label != null) {
                    colWidths[i] = label.length();
                }
                colValues[i] = new ArrayList();
            }
            while (rset.next()) {
                for (i = 0; i < count; ++i) {
                    String val = rset.getString(i + 1);
                    if (rset.wasNull()) {
                        val = "NULL";
                    }
                    if (val.length() > colWidths[i]) {
                        colWidths[i] = val.length();
                    }
                    colValues[i].add(val);
                }
            }
            this.printBoundary('=', colWidths);
            for (i = 0; i < count; ++i) {
                label = meta.getColumnLabel(i + 1);
                this._writer.print("|");
                this.printCentered(label, colWidths[i]);
            }
            this._writer.println("|");
            this.printBoundary('=', colWidths);
            int I = colValues[0].size();
            for (i = 0; i < I; ++i) {
                for (int j = 0; j < count; ++j) {
                    String value = (String)colValues[j].get(i);
                    this._writer.print("|");
                    this.printRight(value, colWidths[j]);
                }
                this._writer.println("|");
                this.printBoundary('-', colWidths);
            }
        }
    }

    public void printBoundary(char boundaryChar, int[] colWidths) {
        for (int i = 0; i < colWidths.length; ++i) {
            this._writer.print("+");
            for (int j = 0; j < colWidths[i] + 2; ++j) {
                this._writer.print(boundaryChar);
            }
        }
        this._writer.println("+");
    }

    public void printCentered(String value, int length) {
        int j;
        this._writer.print(" ");
        int diff = length - value.length();
        int left = diff / 2;
        int right = left++;
        if (diff % 2 == 1) {
            // empty if block
        }
        for (j = 0; j < left; ++j) {
            this._writer.print(" ");
        }
        this._writer.print(value);
        for (j = 0; j < right; ++j) {
            this._writer.print(" ");
        }
        this._writer.print(" ");
    }

    public void printRight(String value, int length) {
        this._writer.print(" ");
        int diff = length - value.length();
        for (int j = 0; j < diff; ++j) {
            this._writer.print(" ");
        }
        this._writer.print(value);
        this._writer.print(" ");
    }
}

