/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import java.math.BigDecimal;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.FunctionFactory;
import org.axiondb.RowDecorator;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.BigDecimalType;

public class ModFunction
extends BaseFunction
implements ScalarFunction,
FunctionFactory {
    private DataType _datatype = null;

    public ModFunction() {
        super("MOD");
    }

    public ConcreteFunction makeNewInstance() {
        return new ModFunction();
    }

    public DataType getDataType() {
        return this._datatype == null ? new BigDecimalType() : this._datatype;
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        Object rawDividend = this.getArgument(0).evaluate(row);
        Object rawDivisor = this.getArgument(1).evaluate(row);
        if (null == rawDividend || null == rawDivisor) {
            return null;
        }
        BigDecimal dividend = this.getArgument(0).getDataType().toBigDecimal(rawDividend).setScale(0, 1);
        BigDecimal divisor = this.getArgument(1).getDataType().toBigDecimal(rawDivisor).setScale(0, 1);
        BigDecimal result = null;
        try {
            BigDecimal divideResult = dividend.divide(divisor, 0, 1);
            result = dividend.subtract(divisor.multiply(divideResult));
        }
        catch (ArithmeticException e) {
            throw new AxionException(22012);
        }
        DataType divisorDatatype = this.getArgument(1).getDataType();
        this._datatype = divisor instanceof DataType.ExactNumeric ? divisorDatatype : this.getEquivalentExactNumericType(divisorDatatype);
        return this._datatype.convert(result);
    }

    private DataType getEquivalentExactNumericType(DataType datatype) {
        return new BigDecimalType(datatype.getPrecision(), 0);
    }

    public boolean isValid() {
        return this.getArgumentCount() == 2;
    }
}

