/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.FunctionFactory;
import org.axiondb.RowDecorator;
import org.axiondb.functions.BaseRegExpFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.StringType;

public class LikeToRegexpFunction
extends BaseRegExpFunction
implements ScalarFunction,
FunctionFactory {
    private static final DataType STRING_TYPE = new StringType();
    private static char ESCAPE_PERCENTAGE = (char)37;
    private static char ESCAPE_UNDERSCORE = (char)95;

    public LikeToRegexpFunction() {
        super("LIKE_TO_REGEXP");
    }

    public ConcreteFunction makeNewInstance() {
        return new LikeToRegexpFunction();
    }

    public DataType getDataType() {
        return STRING_TYPE;
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        String processedLikePattern;
        Object arg = this.getArgument(0).evaluate(row);
        String likePattern = (String)STRING_TYPE.convert(arg);
        if (likePattern == null) {
            return null;
        }
        char escChar = '\u0000';
        if (this.getArgumentCount() == 2) {
            Object arg1 = this.getArgument(1).evaluate(row);
            String origEscChar = (String)STRING_TYPE.convert(arg1);
            if (origEscChar != null) {
                if (origEscChar.length() != 1) {
                    throw new AxionException(22019);
                }
                escChar = origEscChar.charAt(0);
            } else {
                return null;
            }
        }
        if ((processedLikePattern = (String)this.getFromCache(likePattern + escChar)) == null) {
            processedLikePattern = this.convertLike(likePattern, escChar);
            this.putInCache(likePattern + escChar, processedLikePattern);
        }
        return processedLikePattern;
    }

    protected String convertLike(String orig) throws AxionException {
        char ch = '\u0000';
        return this.convertLike(orig, ch);
    }

    protected String convertLike(String orig, char skipChar) throws AxionException {
        StringBuffer _buf = new StringBuffer(2 * orig.length());
        if (orig.length() == 0 || orig.charAt(0) != ESCAPE_PERCENTAGE) {
            _buf.append("^");
        }
        int I = orig.length();
        for (int i = 0; i < I; ++i) {
            char next = orig.charAt(i);
            if (next == skipChar) {
                int j = i + 1;
                if (j < orig.length()) {
                    char nextNext = orig.charAt(j);
                    if (this.isValidSQLEscapedCharacter(nextNext)) {
                        _buf.append(nextNext);
                        ++i;
                        continue;
                    }
                    if (nextNext == skipChar) {
                        ++i;
                        _buf.append(this.escapeCharForRegex(nextNext));
                        continue;
                    }
                    throw new AxionException("character following the escape character '" + skipChar + "' should be either a valid SQL escape character or the escape character itself; problem at " + orig.substring(i), 22025);
                }
                throw new AxionException(22025);
            }
            String processed = this.escapeCharForRegex(next);
            _buf.append(processed);
        }
        if (orig.length() < 2 || orig.charAt(orig.length() - 1) != ESCAPE_PERCENTAGE && orig.charAt(orig.length() - 2) != '\\') {
            _buf.append("$");
        }
        return _buf.toString();
    }

    private String escapeCharForRegex(char ch) {
        String repl = null;
        switch (ch) {
            case '%': {
                repl = ".*";
                break;
            }
            case '_': {
                repl = ".";
                break;
            }
            case '?': {
                repl = "\\?";
                break;
            }
            case '*': {
                repl = "\\*";
                break;
            }
            case '.': {
                repl = "\\.";
                break;
            }
            case '$': {
                repl = "\\$";
                break;
            }
            case '\\': {
                repl = "\\\\";
                break;
            }
            case '+': {
                repl = "\\+";
                break;
            }
            case '^': {
                repl = "\\^";
                break;
            }
            case '{': {
                repl = "\\{";
                break;
            }
            case '}': {
                repl = "\\}";
                break;
            }
            case '[': {
                repl = "\\[";
                break;
            }
            case ']': {
                repl = "\\]";
                break;
            }
            case '(': {
                repl = "\\(";
                break;
            }
            case ')': {
                repl = "\\)";
                break;
            }
            case '|': {
                repl = "\\|";
                break;
            }
            default: {
                repl = String.valueOf(ch);
            }
        }
        return repl;
    }

    private boolean isValidSQLEscapedCharacter(char ch) {
        boolean result = false;
        if (ch == ESCAPE_PERCENTAGE || ch == ESCAPE_UNDERSCORE) {
            result = true;
        }
        return result;
    }

    public boolean isValid() {
        return this.getArgumentCount() == 1 || this.getArgumentCount() == 2;
    }
}

