/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.FunctionFactory;
import org.axiondb.RowDecorator;
import org.axiondb.Selectable;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.StringType;

public class ConcatFunction
extends BaseFunction
implements ScalarFunction,
FunctionFactory {
    private static final DataType STRING_TYPE = new StringType();

    public ConcatFunction() {
        super("CONCAT");
    }

    public ConcreteFunction makeNewInstance() {
        return new ConcatFunction();
    }

    public DataType getDataType() {
        return STRING_TYPE;
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        StringBuffer buf = new StringBuffer();
        int I = this.getArgumentCount();
        for (int i = 0; i < I; ++i) {
            Selectable sel = this.getArgument(i);
            Object rawVal = sel.evaluate(row);
            DataType type = sel.getDataType();
            String val = type.toString(type.convert(rawVal));
            if (null == val) {
                return null;
            }
            buf.append(val);
        }
        return buf.toString();
    }

    public boolean isValid() {
        return this.getArgumentCount() > 0;
    }
}

