/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.tables;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.primitives.IntCollection;
import org.axiondb.AxionException;
import org.axiondb.Column;
import org.axiondb.ColumnIdentifier;
import org.axiondb.Constraint;
import org.axiondb.Database;
import org.axiondb.Index;
import org.axiondb.Literal;
import org.axiondb.Row;
import org.axiondb.RowCollection;
import org.axiondb.RowDecorator;
import org.axiondb.RowIterator;
import org.axiondb.RowSource;
import org.axiondb.Selectable;
import org.axiondb.Sequence;
import org.axiondb.Table;
import org.axiondb.TableIdentifier;
import org.axiondb.TransactableTable;
import org.axiondb.engine.DiskDatabase;
import org.axiondb.engine.SnapshotIsolationTransaction;
import org.axiondb.engine.TransactableTableImpl;
import org.axiondb.engine.commands.AxionQueryContext;
import org.axiondb.engine.commands.SelectCommand;
import org.axiondb.engine.commands.SubSelectCommand;
import org.axiondb.engine.rowiterators.FilteringRowIterator;
import org.axiondb.engine.rowiterators.RowViewRowIterator;
import org.axiondb.engine.rowiterators.UnmodifiableRowIterator;
import org.axiondb.engine.tables.TableViewFactory;
import org.axiondb.event.BaseTableModificationPublisher;
import org.axiondb.event.ColumnEvent;
import org.axiondb.functions.AndFunction;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.EqualFunction;
import org.axiondb.io.AxionFileSystem;
import org.axiondb.parser.AxionSqlParser;
import org.axiondb.util.StringIdentifierGenerator;
import org.axiondb.util.ValuePool;

public class TableView
extends BaseTableModificationPublisher
implements Table {
    private String _name;
    private String _type;
    private String _subQuery;
    private List _select;
    private List _trueColumns;
    private Map _colIndexToColIdMap;
    private Map _srcColIdToFieldMap;
    private boolean _isDiskDb = false;
    private SubSelectCommand _subSelectCmd;
    private Database _db;
    private File _dir;
    private File _metaFile;
    public static String VIEW = "VIEW";
    public static String SUBQUERY = "SUB QUERY";

    public TableView(Database db, String name, String type, SubSelectCommand subSelectCmd) throws AxionException {
        this.setType(type);
        this._name = name == null ? TableView.generateName() : name.toUpperCase();
        this._subSelectCmd = subSelectCmd;
        this._db = db;
        this._isDiskDb = false;
        if (name != null && db instanceof SnapshotIsolationTransaction && ((SnapshotIsolationTransaction)db).getOpenOnTransaction() instanceof DiskDatabase) {
            this._isDiskDb = true;
        }
        if (name != null && db instanceof DiskDatabase) {
            this._isDiskDb = true;
        }
        if (this._isDiskDb) {
            this.createOrLoadMetaFile(this._name, db);
            File typefile = new File(this._dir, this._name + ".TYPE");
            this.writeNameToFile(typefile, new TableViewFactory());
        }
        this.init();
    }

    public TableView(Database db, String name, SubSelectCommand subSelectCmd) throws AxionException {
        this(db, name, SUBQUERY, subSelectCmd);
    }

    public TableView(Database db, String name) throws AxionException {
        this.setType(VIEW);
        this._isDiskDb = true;
        this._name = name.toUpperCase();
        this._db = db;
        this.createOrLoadMetaFile(name, db);
        AxionSqlParser parser = new AxionSqlParser();
        SelectCommand selectCmd = (SelectCommand)parser.parse(this._subQuery);
        this._subSelectCmd = new SubSelectCommand(selectCmd.getQueryContext());
        this.init();
    }

    private void init() throws AxionException {
        int i;
        this._trueColumns = new ArrayList();
        AxionQueryContext ctx = this._subSelectCmd.getQueryContext();
        int I = ctx.getSelectCount();
        for (i = 0; i < I; ++i) {
            if (!(ctx.getSelect(i) instanceof ColumnIdentifier)) continue;
            ColumnIdentifier col = (ColumnIdentifier)ctx.getSelect(i);
            this._trueColumns.add(new ColumnIdentifier(col.getTableIdentifier(), col.getName(), col.getAlias(), col.getDataType()));
        }
        this._subSelectCmd.makeRowIterator(this._db, true);
        this._select = this._subSelectCmd.getQueryContext().getResolvedSelect();
        this._srcColIdToFieldMap = this._subSelectCmd.getColumnIdToFieldMap();
        this.checkAmbiguity(this._srcColIdToFieldMap);
        I = this.getColumnCount();
        for (i = 0; i < I; ++i) {
            this.publishEvent(new ColumnEvent(this, this.getColumn(i)));
        }
    }

    public void setSubQuery(String query) throws AxionException {
        this._subQuery = query;
        if (this._isDiskDb) {
            this.writeMetaFile(this.getMetaFile());
        }
    }

    public void populateIndex(Index index) throws AxionException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int getNextRowId() {
        return -1;
    }

    public void freeRowId(int id) {
    }

    public int getRowCount() {
        int count = 0;
        try {
            RowIterator itr = this.getRowIterator();
            while (itr.hasNext()) {
                ++count;
                itr.next();
            }
        }
        catch (AxionException aex) {
            count = 0;
        }
        return count;
    }

    public Row getRow(int id) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void applyInserts(RowCollection rows) throws AxionException {
        throw new UnsupportedOperationException("Can't add row to a view");
    }

    public void applyDeletes(IntCollection rowids) throws AxionException {
        throw new UnsupportedOperationException("Can't delete row from a view");
    }

    public void applyUpdates(RowCollection rows) throws AxionException {
        throw new UnsupportedOperationException("Can't update row of a view");
    }

    protected RowIterator getRowIterator() throws AxionException {
        RowViewRowIterator rowIterator = new RowViewRowIterator(this._subSelectCmd.makeRowIterator(this._db, true), this._srcColIdToFieldMap, this.getCanonicalIdentifiers(this._select));
        return rowIterator;
    }

    public RowIterator getRowIterator(boolean readOnly) throws AxionException {
        if (readOnly) {
            return UnmodifiableRowIterator.wrap(this.getRowIterator());
        }
        return this.getRowIterator();
    }

    public void addRow(Row row) throws AxionException {
        throw new UnsupportedOperationException("Can't add row to a view");
    }

    public void updateRow(Row oldrow, Row newrow) throws AxionException {
        throw new UnsupportedOperationException("Can't update row of a view");
    }

    public void deleteRow(Row oldrow) throws AxionException {
        throw new UnsupportedOperationException("Can't delete row of a view");
    }

    public RowDecorator buildRowDecorator() {
        RowDecorator dec = null;
        int I = this.getColumnCount();
        HashMap<Column, Integer> map = new HashMap<Column, Integer>(I);
        for (int i = 0; i < I; ++i) {
            map.put(this.getColumn(i), ValuePool.getInt(i));
        }
        dec = new RowDecorator(map);
        return dec;
    }

    public String toString() {
        return this.getName();
    }

    public final String getName() {
        return this._name;
    }

    public final String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }

    public void addConstraint(Constraint constraint) throws AxionException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Constraint removeConstraint(String name) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Constraint getConstraint(String name) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Iterator getConstraints() {
        return Collections.EMPTY_LIST.iterator();
    }

    public boolean isUniqueConstraintExists(String columnName) {
        return false;
    }

    public final boolean isPrimaryKeyConstraintExists(String columnName) {
        return false;
    }

    public void addIndex(Index index) throws AxionException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void removeIndex(Index index) throws AxionException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Index getIndexForColumn(Column column) {
        return null;
    }

    public final boolean isColumnIndexed(Column column) {
        return false;
    }

    public RowIterator getMatchingRows(List selectables, List values, boolean readOnly) throws AxionException {
        if (null == selectables || selectables.isEmpty()) {
            return this.getRowIterator(readOnly);
        }
        BaseFunction root = null;
        int I = selectables.size();
        for (int i = 0; i < I; ++i) {
            Selectable sel = (Selectable)selectables.get(i);
            Object val = values.get(i);
            EqualFunction function = new EqualFunction();
            function.addArgument(sel);
            function.addArgument(new Literal(val));
            if (null == root) {
                root = function;
                continue;
            }
            AndFunction fn = new AndFunction();
            fn.addArgument(root);
            fn.addArgument(function);
            root = fn;
        }
        return new FilteringRowIterator(this.getRowIterator(readOnly), this.makeRowDecorator(), root);
    }

    public RowIterator getIndexedRows(Selectable node, boolean readOnly) throws AxionException {
        return this.getIndexedRows(this, node, readOnly);
    }

    public RowIterator getIndexedRows(RowSource source, Selectable node, boolean readOnly) throws AxionException {
        return null;
    }

    public void addColumn(Column col) throws AxionException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean hasColumn(ColumnIdentifier id) {
        boolean result = false;
        int I = this._select.size();
        for (int i = 0; i < I; ++i) {
            Object sel = this._select.get(i);
            if (sel instanceof ColumnIdentifier) {
                ColumnIdentifier col = (ColumnIdentifier)sel;
                if (!id.getName().equals(this.getResolvedColumnName(col))) continue;
                result = true;
                break;
            }
            if (!this.getResolvedColumnName(id).equals(this.getResolvedColumnName(sel))) continue;
            result = true;
            break;
        }
        return result;
    }

    public final Column getColumn(int index) {
        Selectable sel = (Selectable)this._select.get(index);
        return new Column(this.getResolvedColumnName(sel), sel.getDataType());
    }

    public final Column getColumn(String name) {
        return this.getColumn(this.getColumnIndex(name));
    }

    public int getColumnIndex(String name) {
        int I = this._select.size();
        for (int i = 0; i < I; ++i) {
            Object sel = this._select.get(i);
            if (!this.getResolvedColumnName(sel).equals(name)) continue;
            return i;
        }
        throw new IllegalArgumentException("Column " + name + " not found.");
    }

    public final List getColumnIdentifiers() {
        return this.getColumnIdentifierList(new TableIdentifier(this._name));
    }

    public List getColumnIdentifierList(TableIdentifier table) {
        if (table != null && !this.getName().equals(table.getTableName())) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ColumnIdentifier> result = new ArrayList<ColumnIdentifier>();
        int I = this._select.size();
        for (int i = 0; i < I; ++i) {
            Selectable sel = (Selectable)this._select.get(i);
            result.add(new ColumnIdentifier(table, this.getResolvedColumnName(sel), sel.getAlias(), sel.getDataType()));
        }
        return result;
    }

    public final int getColumnCount() {
        return this._select.size();
    }

    public void drop() throws AxionException {
        if (this._isDiskDb && !this.deleteFile(this.getRootDir())) {
            throw new AxionException("Unable to delete \"" + this.getRootDir() + "\" during drop table " + this.getName());
        }
    }

    protected boolean deleteFile(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    this.deleteFile(files[i]);
                }
            }
            return file.delete();
        }
        return true;
    }

    public void remount(File dir, boolean datafilesonly) throws AxionException {
    }

    public void rename(String oldName, String newName) throws AxionException {
        this._name = newName.toUpperCase();
    }

    public void shutdown() throws AxionException {
        this._select = null;
        this._srcColIdToFieldMap = null;
        this._subSelectCmd = null;
        this._db = null;
    }

    public void checkpoint() throws AxionException {
    }

    public void setSequence(Sequence seq) throws AxionException {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public Sequence getSequence() {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public void truncate() throws AxionException {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public RowDecorator makeRowDecorator() {
        if (null == this._colIndexToColIdMap) {
            HashMap map = new HashMap();
            List colids = this.getColumnIdentifiers();
            int I = colids.size();
            for (int i = 0; i < I; ++i) {
                map.put(colids.get(i), ValuePool.getInt(i));
            }
            this._colIndexToColIdMap = map;
        }
        return new RowDecorator(this._colIndexToColIdMap);
    }

    public TransactableTable makeTransactableTable() {
        return new TransactableTableImpl(this);
    }

    public void migrate() throws AxionException {
    }

    public final Iterator getIndices() {
        return Collections.EMPTY_LIST.iterator();
    }

    public Iterator getTables() {
        return Arrays.asList(this._subSelectCmd.getQueryContext().getTables()).iterator();
    }

    public final boolean hasIndex(String name) {
        return false;
    }

    private void checkAmbiguity(Map colIdToFieldMap) throws AxionException {
        int i;
        HashSet<String> colidset = new HashSet<String>();
        int I = this._select.size();
        for (i = 0; i < I; ++i) {
            Object col = this._select.get(i);
            String colname = this.getResolvedColumnName(col);
            if (colidset.contains(colname) && !(col instanceof Literal)) {
                throw new AxionException(42706);
            }
            colidset.add(colname);
        }
        I = this._trueColumns.size();
        for (i = 0; i < I; ++i) {
            ColumnIdentifier truecol = (ColumnIdentifier)this._trueColumns.get(i);
            if (truecol.getTableName() != null) continue;
            this.checkUnqualifiedColumnAmbiguity(colIdToFieldMap, truecol.getName());
        }
    }

    private void checkUnqualifiedColumnAmbiguity(Map colIdToFieldMap, String truecolname) throws AxionException {
        HashSet<String> truecolset = new HashSet<String>();
        for (Object obj : colIdToFieldMap.keySet()) {
            ColumnIdentifier col;
            String colname;
            if (!(obj instanceof ColumnIdentifier) || !truecolname.equals(colname = (col = (ColumnIdentifier)obj).getName())) continue;
            if (!truecolset.contains(colname)) {
                truecolset.add(colname);
                continue;
            }
            throw new AxionException(42705);
        }
    }

    private List getCanonicalIdentifiers(List selectedCol) {
        ArrayList<ColumnIdentifier> colids = new ArrayList<ColumnIdentifier>();
        int I = selectedCol.size();
        for (int i = 0; i < I; ++i) {
            Object sel = selectedCol.get(i);
            if (sel instanceof ColumnIdentifier) {
                ColumnIdentifier colid = (ColumnIdentifier)sel;
                colids.add(colid.getCanonicalIdentifier());
                continue;
            }
            colids.add((ColumnIdentifier)sel);
        }
        return colids;
    }

    private String getResolvedColumnName(Object obj) {
        String colName = null;
        if (obj instanceof ColumnIdentifier) {
            ColumnIdentifier col = (ColumnIdentifier)obj;
            colName = col.getAlias();
            if (colName == null) {
                colName = col.getName();
            }
        } else if (obj instanceof ConcreteFunction) {
            ConcreteFunction fn = (ConcreteFunction)obj;
            colName = fn.getLabel();
        } else if (obj instanceof SubSelectCommand) {
            SubSelectCommand sq = (SubSelectCommand)obj;
            colName = sq.getName();
        } else if (obj instanceof Literal) {
            Literal lit = (Literal)obj;
            colName = lit.getName();
        }
        return colName;
    }

    private static String generateName() {
        return StringIdentifierGenerator.INSTANCE.next16DigitIdentifier("VIEW");
    }

    private void createOrLoadMetaFile(String name, Database db) throws AxionException {
        this._dir = new File(db.getDBDirectory(), name);
        if (!this._dir.exists() && !this._dir.mkdirs()) {
            throw new AxionException("Unable to create directory \"" + this._dir.toString() + "\" for view \"" + name + "\".");
        }
        if (this.getMetaFile().exists()) {
            this.parseMetaFile(this.getMetaFile());
        }
    }

    private void parseMetaFile(File file) throws AxionException {
        ObjectInputStream in = null;
        AxionFileSystem fs = new AxionFileSystem();
        try {
            in = fs.openObjectInputSteam(file);
            this._name = in.readUTF();
            this._subQuery = in.readUTF();
        }
        catch (IOException e) {
            throw new AxionException("Unable to parse meta file " + file + " for table " + this.getName(), e);
        }
        finally {
            fs.closeInputStream(in);
        }
    }

    private void writeMetaFile(File file) throws AxionException {
        ObjectOutputStream out = null;
        AxionFileSystem fs = new AxionFileSystem();
        try {
            out = fs.createObjectOutputSteam(file);
            out.writeUTF(this._name);
            out.writeUTF(this._subQuery);
            out.flush();
        }
        catch (IOException e) {
            throw new AxionException("Unable to write meta file " + file + " for table " + this.getName(), e);
        }
        finally {
            fs.closeOutputStream(out);
        }
    }

    private File getMetaFile() {
        if (null == this._metaFile) {
            this._metaFile = new File(this.getRootDir(), this.getName() + ".META");
        }
        return this._metaFile;
    }

    private final File getRootDir() {
        return this._dir;
    }

    private void writeNameToFile(File file, Object obj) throws AxionException {
        ObjectOutputStream out = null;
        AxionFileSystem fs = new AxionFileSystem();
        try {
            String name = obj.getClass().getName();
            out = fs.createObjectOutputSteam(file);
            out.writeUTF(name);
            out.flush();
            fs.closeOutputStream(out);
        }
        catch (IOException e) {
            try {
                throw new AxionException(e);
            }
            catch (Throwable throwable) {
                fs.closeOutputStream(out);
                throw throwable;
            }
        }
    }
}

