/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.tables;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.axiondb.AxionException;
import org.axiondb.TableOrganizationContext;

public abstract class BaseTableOrganizationContext
implements TableOrganizationContext {
    private Set PROPERTY_KEYS = new HashSet(2);
    protected Properties _props = new Properties();

    public BaseTableOrganizationContext() {
        this.PROPERTY_KEYS.add("LOADTYPE");
        this.PROPERTY_KEYS.add("COLUMNS_ARE_CASE_SENSITIVE");
    }

    public Properties getTableProperties() {
        return this._props;
    }

    public abstract Set getPropertyKeys();

    public abstract Set getRequiredPropertyKeys();

    public abstract void readOrSetDefaultProperties(Properties var1) throws AxionException;

    public void updateProperties() {
        this._props.clear();
    }

    public void setProperty(String key, String value) {
        if (value == null) {
            value = "";
        }
        this._props.setProperty(key, value);
    }

    public Set getBasePropertyKeys() {
        return Collections.unmodifiableSet(this.PROPERTY_KEYS);
    }

    public Set getBaseRequiredPropertyKeys() {
        return Collections.EMPTY_SET;
    }

    public void assertValidPropertyKeys(Properties props) throws AxionException {
        Enumeration<Object> keys = props.keys();
        Set validKeys = this.getPropertyKeys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (validKeys.contains(key)) continue;
            throw new AxionException("Property '" + key + "' not recognized for this table type.");
        }
        HashSet requiredKeys = new HashSet(this.getRequiredPropertyKeys());
        if (!props.keySet().containsAll(requiredKeys)) {
            requiredKeys.removeAll(props.keySet());
            StringBuffer errMsgBuf = new StringBuffer("Missing required properties in organization clause:  ");
            Iterator iter = requiredKeys.iterator();
            int k = 0;
            while (iter.hasNext()) {
                if (k++ != 0) {
                    errMsgBuf.append(", ");
                }
                errMsgBuf.append(iter.next());
            }
            throw new AxionException(errMsgBuf.toString());
        }
    }
}

