/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.rowiterators;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.primitives.IntListIterator;
import org.axiondb.AxionException;
import org.axiondb.Row;
import org.axiondb.RowSource;
import org.axiondb.Table;
import org.axiondb.engine.rowiterators.BaseRowIterator;
import org.axiondb.engine.rows.LazyRow;

public class LazyRowRowIterator
extends BaseRowIterator {
    private int _currentIndex = -1;
    private Row _currentRow = null;
    private int _knownColumnIndex = -1;
    private IntListIterator _rowIdIter = null;
    private int _size = -1;
    private RowSource _source = null;
    private ListIterator _valueIter = null;

    public LazyRowRowIterator(RowSource source, IntListIterator rowIdIter, int size) {
        this(source, rowIdIter, -1, null, size);
    }

    public LazyRowRowIterator(RowSource source, IntListIterator rowIdIter, int knownColumn, ListIterator valueIter, int size) {
        this._source = source;
        this._rowIdIter = rowIdIter;
        this._knownColumnIndex = knownColumn;
        this._valueIter = valueIter;
        this._size = size;
    }

    public void add(Row row) {
        throw new UnsupportedOperationException("Not supported");
    }

    public Row current() {
        if (this.hasCurrent()) {
            return this._currentRow;
        }
        throw new NoSuchElementException("No current row has been set.");
    }

    public int currentIndex() {
        return this._currentIndex;
    }

    public boolean hasCurrent() {
        return null != this._currentRow;
    }

    public boolean hasNext() {
        return this._rowIdIter.hasNext();
    }

    public boolean hasPrevious() {
        return this._rowIdIter.hasPrevious();
    }

    public Row last() throws AxionException {
        this.reset();
        this.next(this.size());
        return this.peekPrevious();
    }

    public Row next() {
        this._currentIndex = this._rowIdIter.nextIndex();
        this.setCurrentRow(this._rowIdIter.next(), null == this._valueIter ? null : this._valueIter.next());
        return this._currentRow;
    }

    public int next(int count) throws AxionException {
        int lastId = -1;
        for (int i = 0; i < count; ++i) {
            this._currentIndex = this._rowIdIter.nextIndex();
            lastId = this._rowIdIter.next();
            if (this._valueIter == null) continue;
            this._valueIter.next();
        }
        return lastId;
    }

    public int nextIndex() {
        return this._rowIdIter.nextIndex();
    }

    public Row previous() {
        this.setCurrentRow(this._rowIdIter.previous(), null == this._valueIter ? null : this._valueIter.previous());
        this._currentIndex = this._rowIdIter.nextIndex();
        return this._currentRow;
    }

    public int previous(int count) throws AxionException {
        int lastId = -1;
        for (int i = 0; i < count; ++i) {
            this._currentIndex = this._rowIdIter.previousIndex();
            lastId = this._rowIdIter.previous();
            if (this._valueIter == null) continue;
            this._valueIter.previous();
        }
        return lastId;
    }

    public int previousIndex() {
        return this._rowIdIter.previousIndex();
    }

    public void remove() throws AxionException {
        if (!this.hasCurrent()) {
            throw new IllegalStateException("No current row.");
        }
        if (this._source instanceof Table) {
            ((Table)this._source).deleteRow(this.current());
            this._rowIdIter.remove();
            if (this._valueIter != null) {
                this._valueIter.remove();
            }
            this._currentRow = null;
            this._currentIndex = -1;
            --this._size;
        } else {
            throw new UnsupportedOperationException("Not supported");
        }
    }

    public void reset() {
        while (this._rowIdIter.hasPrevious()) {
            this._rowIdIter.previous();
            if (null == this._valueIter) continue;
            this._valueIter.previous();
        }
        this._currentRow = null;
        this._currentIndex = -1;
    }

    public void set(Row row) throws AxionException {
        if (!this.hasCurrent()) {
            throw new IllegalStateException("No current row.");
        }
        if (!(this._source instanceof Table)) {
            throw new UnsupportedOperationException("Not supported");
        }
        row.setIdentifier(this.current().getIdentifier());
        ((Table)this._source).updateRow(this.current(), row);
        this._currentRow = new LazyRow(this._source, this.current().getIdentifier());
    }

    public int size() throws AxionException {
        return this._size;
    }

    public String toString() {
        return "LazyRow(source=" + this._source + ")";
    }

    private final void setCurrentRow(int rowid, Object value) {
        this._currentRow = new LazyRow(this._source, rowid, this._knownColumnIndex, value);
    }
}

