/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.metaupdaters;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.axiondb.AxionException;
import org.axiondb.Column;
import org.axiondb.ColumnIdentifier;
import org.axiondb.Constraint;
import org.axiondb.Database;
import org.axiondb.Literal;
import org.axiondb.Row;
import org.axiondb.Selectable;
import org.axiondb.SelectableBasedConstraint;
import org.axiondb.Table;
import org.axiondb.TableIdentifier;
import org.axiondb.constraints.NotNullConstraint;
import org.axiondb.constraints.PrimaryKeyConstraint;
import org.axiondb.engine.commands.DeleteCommand;
import org.axiondb.engine.commands.UpdateCommand;
import org.axiondb.engine.rows.SimpleRow;
import org.axiondb.event.BaseDatabaseModificationListener;
import org.axiondb.event.ColumnEvent;
import org.axiondb.event.ConstraintEvent;
import org.axiondb.event.DatabaseModificationListener;
import org.axiondb.event.DatabaseModifiedEvent;
import org.axiondb.event.RowEvent;
import org.axiondb.event.TableModificationListener;
import org.axiondb.functions.FunctionIdentifier;
import org.axiondb.util.ValuePool;

public class AxionColumnsMetaTableUpdater
extends BaseDatabaseModificationListener
implements DatabaseModificationListener,
TableModificationListener {
    private static Logger _log = Logger.getLogger(AxionColumnsMetaTableUpdater.class.getName());
    private Database _db = null;

    public AxionColumnsMetaTableUpdater(Database db) {
        this._db = db;
    }

    public void tableAdded(DatabaseModifiedEvent e) {
        try {
            int I = e.getTable().getColumnCount();
            for (int i = 0; i < I; ++i) {
                Column col = e.getTable().getColumn(i);
                Row row = this.createRowForColumnAdded(e.getTable(), col);
                this._db.getTable("AXION_COLUMNS").addRow(row);
            }
        }
        catch (AxionException ex) {
            _log.log(Level.SEVERE, "Unable to mention table in system tables", ex);
        }
    }

    public void tableDropped(DatabaseModifiedEvent e) {
        FunctionIdentifier where = this.makeEqualFunction(new ColumnIdentifier("TABLE_NAME"), new Literal(e.getTable().getName()));
        DeleteCommand cmd = new DeleteCommand("AXION_COLUMNS", (Selectable)where);
        try {
            cmd.execute(this._db);
        }
        catch (AxionException ex) {
            _log.log(Level.SEVERE, "Unable to remove mention of table in system tables", ex);
        }
    }

    public void columnAdded(ColumnEvent e) throws AxionException {
        Row row = this.createRowForColumnAdded(e.getTable(), e.getColumn());
        this._db.getTable("AXION_COLUMNS").addRow(row);
    }

    public void rowInserted(RowEvent event) throws AxionException {
    }

    public void rowDeleted(RowEvent event) throws AxionException {
    }

    public void rowUpdated(RowEvent event) throws AxionException {
    }

    public void constraintAdded(ConstraintEvent event) throws AxionException {
    }

    public void constraintRemoved(ConstraintEvent event) throws AxionException {
    }

    public void updateNullableStatus(ConstraintEvent event, boolean changeNullableTo) {
        Constraint c = event.getConstraint();
        if (c instanceof NotNullConstraint || c instanceof PrimaryKeyConstraint) {
            SelectableBasedConstraint nn = (SelectableBasedConstraint)c;
            for (int i = 0; i < nn.getSelectableCount(); ++i) {
                try {
                    UpdateCommand cmd = this.createUpdateNullableCmd(event.getTable(), nn.getSelectable(i).getLabel(), changeNullableTo);
                    cmd.execute(this._db);
                    continue;
                }
                catch (AxionException ex) {
                    _log.log(Level.SEVERE, "Unable to mark nullable status in system tables", ex);
                }
            }
        }
    }

    protected Row createRowForColumnAdded(Table t, Column col) throws AxionException {
        boolean isnullable = this.isNullable(t, col.getName());
        Integer nullableInt = ValuePool.getInt(isnullable ? 1 : 0);
        String nullableString = isnullable ? "YES" : "NO";
        Short typeVal = new Short((short)col.getDataType().getJdbcType());
        Integer size = ValuePool.getInt(col.getDataType().getPrecision());
        Integer scale = ValuePool.getInt(col.getDataType().getScale());
        Integer radix = ValuePool.getInt(col.getDataType().getPrecisionRadix());
        String typeName = col.getDataType().getClass().getName();
        String sqlType = col.getSqlType();
        sqlType = sqlType == null ? typeName : sqlType.toUpperCase();
        int ord = t.getColumnIndex(col.getName());
        SimpleRow row = new SimpleRow(22);
        row.set(0, "");
        row.set(1, "");
        row.set(2, t.getName());
        row.set(3, col.getName().toUpperCase());
        row.set(4, typeVal);
        row.set(5, sqlType);
        row.set(6, size);
        row.set(7, null);
        row.set(8, scale);
        row.set(9, radix);
        row.set(10, nullableInt);
        row.set(11, null);
        row.set(12, null);
        row.set(13, null);
        row.set(14, null);
        row.set(15, null);
        row.set(16, ValuePool.getInt(ord + 1));
        row.set(17, nullableString);
        row.set(18, null);
        row.set(19, null);
        row.set(20, null);
        row.set(21, null);
        return row;
    }

    private UpdateCommand createUpdateNullableCmd(Table t, String colName, boolean isnullable) {
        Integer nullableInt = ValuePool.getInt(isnullable ? 1 : 0);
        String nullableString = isnullable ? "YES" : "NO";
        FunctionIdentifier tableMatch = this.makeEqualFunction(new ColumnIdentifier("TABLE_NAME"), new Literal(t.getName()));
        FunctionIdentifier colMatch = this.makeEqualFunction(new ColumnIdentifier("COLUMN_NAME"), new Literal(colName.toUpperCase()));
        FunctionIdentifier where = new FunctionIdentifier("and");
        where.addArgument(tableMatch);
        where.addArgument(colMatch);
        UpdateCommand cmd = new UpdateCommand();
        cmd.setTable(new TableIdentifier("AXION_COLUMNS"));
        cmd.addColumn(new ColumnIdentifier("NULLABLE"));
        cmd.addValue(new Literal(nullableInt));
        cmd.addColumn(new ColumnIdentifier("IS_NULLABLE"));
        cmd.addValue(new Literal(nullableString));
        cmd.setWhere(where);
        return cmd;
    }

    private boolean isNullable(Table table, String column) {
        Iterator iter = table.getConstraints();
        while (iter.hasNext()) {
            Constraint c = (Constraint)iter.next();
            if (!(c instanceof NotNullConstraint) && !(c instanceof PrimaryKeyConstraint)) continue;
            SelectableBasedConstraint nn = (SelectableBasedConstraint)c;
            for (int i = 0; i < nn.getSelectableCount(); ++i) {
                if (!column.equals(nn.getSelectable(i).getLabel())) continue;
                return false;
            }
        }
        return true;
    }

    private FunctionIdentifier makeEqualFunction(Selectable left, Selectable right) {
        FunctionIdentifier function = new FunctionIdentifier("=");
        function.addArgument(left);
        function.addArgument(right);
        return function;
    }
}

