/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.axiondb.AxionException;
import org.axiondb.ColumnIdentifier;
import org.axiondb.DataType;
import org.axiondb.Database;
import org.axiondb.Row;
import org.axiondb.RowDecorator;
import org.axiondb.Selectable;
import org.axiondb.Table;
import org.axiondb.TableIdentifier;
import org.axiondb.engine.SnapshotIsolationTransaction;
import org.axiondb.engine.commands.BaseAxionCommand;
import org.axiondb.engine.commands.DMLWhenClause;
import org.axiondb.engine.rows.SimpleRow;
import org.axiondb.engine.tables.ExternalDatabaseTable;
import org.axiondb.engine.visitors.FindBindVariableVisitor;
import org.axiondb.jdbc.AxionResultSet;

public abstract class InsertIntoClause
extends BaseAxionCommand {
    private List _cols;
    private transient int[] _colIndex;
    private Table _table;
    private RowDecorator _dec;
    private List _vals;
    private boolean _useDefaultValues = false;
    private boolean _populateSequence = true;
    private boolean _isExternalDBTable = false;
    private int _count = 0;
    private TableIdentifier _tableId;
    private TableIdentifier[] _tables;
    private DMLWhenClause _whenClause;

    public InsertIntoClause(DMLWhenClause when, TableIdentifier tid, List cols, List vals) {
        this._whenClause = when;
        this._tableId = tid;
        this._tables = new TableIdentifier[]{this._tableId};
        this._cols = null == cols ? new ArrayList() : cols;
        this._vals = null == vals ? new ArrayList() : vals;
    }

    public InsertIntoClause(DMLWhenClause when, TableIdentifier tid, List cols, boolean useDefaultValues) {
        this(when, tid, cols, null);
        this._useDefaultValues = useDefaultValues;
    }

    public boolean execute(Database db) throws AxionException {
        throw new UnsupportedOperationException("Not Implemented...");
    }

    public AxionResultSet executeQuery(Database db) throws AxionException {
        throw new UnsupportedOperationException("Not Implemented...");
    }

    public int executeUpdate(Database db) throws AxionException {
        throw new UnsupportedOperationException("Not Implemented...");
    }

    public final Iterator getColumnIterator() {
        return this._cols.iterator();
    }

    public final int getProcessedRowCount() {
        return this._count;
    }

    public TableIdentifier getTargetTableId() {
        return this._tableId;
    }

    public final Iterator getValueIterator() {
        return this._vals.iterator();
    }

    public boolean insertMatchingRow(Database db, RowDecorator dec, Row srcRow) throws AxionException {
        if (this._whenClause != null && !this._whenClause.evaluate(dec)) {
            return false;
        }
        if (this._vals != null && !this._vals.isEmpty()) {
            this.addRowToTable(db, null, dec);
        } else {
            this.addRowToTable(db, srcRow, dec);
        }
        ++this._count;
        this.commitIfRequired(db);
        return true;
    }

    public void preProcess(Database db) throws AxionException {
        this._count = 0;
        this._table = db.getTable(this._tableId);
        if (null == this._table) {
            throw new AxionException("Table " + this._tableId + " not found.");
        }
        this.setDeferAllConstraintIfRequired(this._table);
    }

    protected void addRowToTable(Database db, Row srcRow, RowDecorator dec) throws AxionException {
        SimpleRow row = new SimpleRow(this._table.getColumnCount());
        if (dec.getRow() == null) {
            dec.setRow(row);
        }
        int size = srcRow != null ? srcRow.size() : this._vals.size();
        for (int i = 0; i < size; ++i) {
            this.setValue(srcRow != null ? srcRow.get(i) : this._vals.get(i), dec, row, i);
        }
        RowDecorator trgtDec = this.makeRowDecorator();
        trgtDec.setRow(row);
        this.populateDefaultValues(db, this._table, this._tableId, trgtDec);
        if (this._populateSequence) {
            this._populateSequence = this.populateSequenceColumns(db, this._table, row);
        }
        if (this._isExternalDBTable) {
            ((ExternalDatabaseTable)this._table).addRow(row, this._cols);
        } else {
            this._table.addRow(row);
        }
    }

    private void setValue(Object val, RowDecorator dec, Row row, int i) throws AxionException {
        ColumnIdentifier colid = (ColumnIdentifier)this._cols.get(i);
        DataType type = colid.getDataType();
        if (val instanceof Selectable) {
            val = ((Selectable)val).evaluate(dec);
        }
        val = this.attemptToConvertValue(val, type, colid);
        row.set(this._colIndex[i], val);
    }

    protected void assertRules(Table source) throws AxionException {
        String errMsg = "Number of columns and values must match.";
        if (this._vals.isEmpty() ? this.getColumnCount() != source.getColumnCount() : this.getColumnCount() != this.getValueCount()) {
            throw new IllegalArgumentException(errMsg);
        }
    }

    protected void buildBindVariables() {
        this.setBindVariableVisitor(new FindBindVariableVisitor());
        this.getBindVariableVisitor().visit(this);
    }

    protected final int getColumnCount() {
        return this._cols.size();
    }

    protected final Table getTargetTable() {
        return this._table;
    }

    protected final int getValueCount() {
        return this._vals.size();
    }

    protected final List getValues() {
        return this._vals;
    }

    public final DMLWhenClause getWhenClause() {
        return this._whenClause;
    }

    protected boolean isTargetTablePartOfSubQuery() throws AxionException {
        return false;
    }

    protected void resolve(Database db) throws AxionException {
        this.resolveSelectableList(this._cols, db, this._tables);
        this.resolveGeneratedColumns(this._table, this._tableId, this._cols, this._useDefaultValues);
        if (this._colIndex == null) {
            this._colIndex = new int[this._cols.size()];
            int I = this._cols.size();
            for (int i = 0; i < I; ++i) {
                this._colIndex[i] = this._table.getColumnIndex(((ColumnIdentifier)this._cols.get(i)).getName());
            }
        }
        this._isExternalDBTable = this._table instanceof ExternalDatabaseTable;
    }

    private void commitIfRequired(Database db) throws AxionException {
        if (this.getCommitSize(db) == 0 || this.isTargetTablePartOfSubQuery()) {
            return;
        }
        if (db instanceof SnapshotIsolationTransaction && this._count % this.getCommitSize(db) == 0) {
            this._table = ((SnapshotIsolationTransaction)db).commit(this._tableId);
        }
    }

    protected final RowDecorator makeRowDecorator() {
        if (this._dec == null) {
            this._dec = this._table.makeRowDecorator();
        }
        return this._dec;
    }
}

