/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.commands;

import java.util.Iterator;
import java.util.List;
import org.axiondb.AxionException;
import org.axiondb.ColumnIdentifier;
import org.axiondb.Database;
import org.axiondb.Literal;
import org.axiondb.Row;
import org.axiondb.RowDecorator;
import org.axiondb.RowIterator;
import org.axiondb.Selectable;
import org.axiondb.Table;
import org.axiondb.TableIdentifier;
import org.axiondb.constraints.ForeignKeyConstraint;
import org.axiondb.engine.commands.BaseAxionCommand;
import org.axiondb.engine.rows.SimpleRow;
import org.axiondb.functions.AndFunction;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.EqualFunction;

public abstract class ChildTableUpdater
extends BaseAxionCommand {
    protected void deleteOrSetNullChildRows(Database db, Table parentTable, RowDecorator dec) throws AxionException {
        Iterator iter = parentTable.getConstraints();
        while (iter.hasNext()) {
            Object constraint = iter.next();
            if (!(constraint instanceof ForeignKeyConstraint)) continue;
            ForeignKeyConstraint fk = (ForeignKeyConstraint)constraint;
            this.deleteOrSetNullChildRows(db, parentTable, dec, fk);
        }
    }

    protected void deleteOrSetNullChildRows(Database db, Table parentTable, RowDecorator dec, ForeignKeyConstraint fk) throws AxionException {
        Selectable filter = null;
        if (parentTable.getName().equals(fk.getParentTableName())) {
            List parentCols = fk.getParentTableColumns();
            List childCols = fk.getChildTableColumns();
            Table childTable = db.getTable(fk.getChildTableName());
            filter = this.buildFilter(dec, parentCols);
            RowIterator matching = this.getRowIterator(db, new TableIdentifier(fk.getChildTableName()), childTable, filter, false, dec);
            if (matching.hasNext()) {
                if (fk.getOnDeleteActionType() == 10) {
                    this.deleteMatchingChildRows(matching);
                } else if (fk.getOnDeleteActionType() == 20) {
                    this.setNullForMatchingChildRows(childCols, childTable, matching);
                } else if (fk.getOnDeleteActionType() == 30) {
                    this.setDefaultForMatchingChildRows(childCols, childTable, matching);
                }
            }
        }
    }

    protected void updateOrSetNullChildRows(Database db, Table parentTable, Row parentOldRow, Row parentNewRow) throws AxionException {
        Iterator iter = parentTable.getConstraints();
        while (iter.hasNext()) {
            Object constraint = iter.next();
            if (!(constraint instanceof ForeignKeyConstraint)) continue;
            ForeignKeyConstraint fk = (ForeignKeyConstraint)constraint;
            this.updateOrSetNullChildRows(db, parentTable, parentOldRow, parentNewRow, fk);
        }
    }

    protected void updateOrSetNullChildRows(Database db, Table parentTable, Row parentOldRow, Row parentNewRow, ForeignKeyConstraint fk) throws AxionException {
        Selectable filter = null;
        if (parentTable.getName().equals(fk.getParentTableName())) {
            RowDecorator dec = this.makeRowDecorator(parentTable);
            dec.setRow(parentOldRow);
            List parentCols = fk.getParentTableColumns();
            List childCols = fk.getChildTableColumns();
            Table childTable = db.getTable(fk.getChildTableName());
            filter = this.buildFilter(dec, parentCols);
            RowIterator matching = this.getRowIterator(db, new TableIdentifier(fk.getChildTableName()), childTable, filter, false, dec);
            if (matching.hasNext()) {
                if (fk.getOnDeleteActionType() == 10) {
                    this.updateMatchingChildRows(parentTable, parentNewRow, parentCols, childCols, childTable, matching);
                } else if (fk.getOnDeleteActionType() == 20) {
                    this.setNullForMatchingChildRows(childCols, childTable, matching);
                } else if (fk.getOnDeleteActionType() == 30) {
                    this.setDefaultForMatchingChildRows(childCols, childTable, matching);
                }
            }
        }
    }

    private Selectable buildFilter(RowDecorator dec, List columns) throws AxionException {
        BaseFunction filter = null;
        int I = columns.size();
        for (int i = 0; i < I; ++i) {
            Selectable sel = (Selectable)columns.get(i);
            Object val = sel.evaluate(dec);
            EqualFunction function = new EqualFunction();
            function.addArgument(sel);
            function.addArgument(new Literal(val));
            if (null == filter) {
                filter = function;
                continue;
            }
            AndFunction fn = new AndFunction();
            fn.addArgument(filter);
            fn.addArgument(function);
            filter = fn;
        }
        return filter;
    }

    private void deleteMatchingChildRows(RowIterator matching) throws AxionException {
        do {
            matching.next();
            matching.remove();
        } while (matching.hasNext());
    }

    private void setDefaultForMatchingChildRows(List childCols, Table childTable, RowIterator matching) throws AxionException {
        do {
            Row childOldrow = matching.next();
            SimpleRow newrow = new SimpleRow(childOldrow);
            int I = childCols.size();
            for (int i = 0; i < I; ++i) {
                ColumnIdentifier colid = (ColumnIdentifier)childCols.get(i);
                int colndx = childTable.getColumnIndex(colid.getName());
                newrow.set(colndx, childTable.getColumn(colid.getName()).getDefault());
            }
            childTable.updateRow(childOldrow, newrow);
        } while (matching.hasNext());
    }

    private void setNullForMatchingChildRows(List childCols, Table childTable, RowIterator matching) throws AxionException {
        do {
            Row childOldrow = matching.next();
            SimpleRow newrow = new SimpleRow(childOldrow);
            int I = childCols.size();
            for (int i = 0; i < I; ++i) {
                ColumnIdentifier colid = (ColumnIdentifier)childCols.get(i);
                int colndx = childTable.getColumnIndex(colid.getName());
                newrow.set(colndx, null);
            }
            childTable.updateRow(childOldrow, newrow);
        } while (matching.hasNext());
    }

    private void updateMatchingChildRows(Table parentTable, Row parentNewRow, List parentCols, List childCols, Table childTable, RowIterator matching) throws AxionException {
        do {
            Row childOldrow = matching.next();
            SimpleRow newrow = new SimpleRow(childOldrow);
            int I = childCols.size();
            for (int i = 0; i < I; ++i) {
                ColumnIdentifier colid = (ColumnIdentifier)childCols.get(i);
                ColumnIdentifier pcolid = (ColumnIdentifier)parentCols.get(i);
                int colndx = childTable.getColumnIndex(colid.getName());
                int parentColndx = parentTable.getColumnIndex(pcolid.getName());
                newrow.set(colndx, parentNewRow.get(parentColndx));
            }
            childTable.updateRow(childOldrow, newrow);
        } while (matching.hasNext());
    }
}

