/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.commands;

import java.math.BigInteger;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.Database;
import org.axiondb.Sequence;
import org.axiondb.engine.commands.CreateCommand;
import org.axiondb.util.ValuePool;

public class AlterSequenceCommand
extends CreateCommand {
    private String _startVal;
    private String _incrementBy;
    private String _maxValue;
    private String _minValue;
    private Boolean _isCycle;

    public void setStartValue(String value) {
        this._startVal = value;
    }

    public void setIncrementBy(String incrementBy) {
        this._incrementBy = incrementBy;
    }

    public void setMaxValue(String maxValue) {
        this._maxValue = maxValue;
    }

    public void setMinValue(String minValue) {
        this._minValue = minValue;
    }

    public void setCycle(boolean cycle) {
        this._isCycle = ValuePool.getBoolean(cycle);
    }

    public boolean execute(Database db) throws AxionException {
        this.assertNotReadOnly(db);
        if (!db.hasSequence(this.getObjectName())) {
            throw new AxionException("Sequence named \"" + this.getObjectName() + "\" does not exists.");
        }
        Sequence old = db.getSequence(this.getObjectName());
        db.createSequence(this.copyAndUpdateSequenceOptions(db, old));
        return false;
    }

    private BigInteger parseBigInt(String value) {
        return new BigInteger(value, Sequence.RADIX);
    }

    private Sequence copyAndUpdateSequenceOptions(Database db, Sequence old) throws AxionException {
        BigInteger startVal = this._startVal == null ? (BigInteger)old.getValue() : this.parseBigInt(this._startVal);
        BigInteger incrementBy = this._incrementBy == null ? old.getIncrementBy() : this.parseBigInt(this._incrementBy);
        BigInteger maxValue = this._maxValue == null ? old.getMaxValue() : this.parseBigInt(this._maxValue);
        BigInteger minValue = this._minValue == null ? old.getMinValue() : this.parseBigInt(this._minValue);
        boolean isCycle = this._isCycle == null ? old.isCycle() : this._isCycle.booleanValue();
        DataType type = old.getDataType();
        return new Sequence(this.getObjectName(), type, startVal, incrementBy, maxValue, minValue, isCycle);
    }
}

