/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.axiondb.DataType;
import org.axiondb.Selectable;

public class Column
implements Serializable {
    public static final String COLUMN_SQL_TYPE_CONFIG_KEY = "sqlType";
    public static final String DATA_TYPE_CONFIG_KEY = "type";
    public static final String DEFAULT_VALUE_CONFIG_KEY = "defaultValue";
    public static final String NAME_CONFIG_KEY = "name";
    public static final String IDENTITY_GENERATION_TYPE = "identityType";
    public static final String GENERATED_ALWAYS = "always";
    public static final String GENERATED_BY_DEFAULT = "default";
    public static final String GENERATED_COLUMN_TYPE = "generatedCol";
    private Map _config;
    private static final long serialVersionUID = -9163914166152422736L;

    public Column(String name, DataType type) throws NullPointerException {
        this(name, type, null);
    }

    public Column(String name, DataType type, Selectable defaultValue) throws NullPointerException {
        if (null == name) {
            throw new NullPointerException("name parameter must not be null");
        }
        if (null == type) {
            throw new NullPointerException("type parameter must not be null");
        }
        this._config = new HashMap();
        this.getConfiguration().put(NAME_CONFIG_KEY, name);
        this.getConfiguration().put(DATA_TYPE_CONFIG_KEY, type);
        this.getConfiguration().put(DEFAULT_VALUE_CONFIG_KEY, defaultValue);
    }

    public boolean equals(Object that) {
        if (that instanceof Column) {
            Column col = (Column)that;
            return this.getName().equals(col.getName());
        }
        return false;
    }

    public final Map getConfiguration() {
        return this._config;
    }

    public final DataType getDataType() {
        return (DataType)this.getConfiguration().get(DATA_TYPE_CONFIG_KEY);
    }

    public final Selectable getDefault() {
        return (Selectable)this.getConfiguration().get(DEFAULT_VALUE_CONFIG_KEY);
    }

    public final String getName() {
        return (String)this.getConfiguration().get(NAME_CONFIG_KEY);
    }

    public int getScale() {
        return this.getDataType().getScale();
    }

    public int getSize() {
        return this.getDataType().getPrecision();
    }

    public String getSqlType() {
        return (String)this.getConfiguration().get(COLUMN_SQL_TYPE_CONFIG_KEY);
    }

    public boolean hasDefault() {
        return null != this.getDefault();
    }

    public boolean isIdentityColumn() {
        return null != this.getIdentityType();
    }

    public boolean isGeneratedAlways() {
        return GENERATED_ALWAYS.equals(this.getIdentityType());
    }

    public boolean isGeneratedByDefault() {
        return GENERATED_BY_DEFAULT.equals(this.getIdentityType());
    }

    public boolean isDerivedColumn() {
        return GENERATED_ALWAYS.equals(this.getConfiguration().get(GENERATED_COLUMN_TYPE));
    }

    public void setGeneratedColType(String type) {
        this.getConfiguration().put(GENERATED_COLUMN_TYPE, type);
    }

    public String getGeneratedColType() {
        return (String)this.getConfiguration().get(GENERATED_COLUMN_TYPE);
    }

    public final String getIdentityType() {
        return (String)this.getConfiguration().get(IDENTITY_GENERATION_TYPE);
    }

    public void setIdentityType(String type) {
        this.getConfiguration().put(IDENTITY_GENERATION_TYPE, type);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public void setSqlType(String type) {
        this.getConfiguration().put(COLUMN_SQL_TYPE_CONFIG_KEY, type);
    }

    public String toString() {
        return this.getName();
    }
}

