/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;

public class UnicodeFile {
    private static final int CHUNK = 1024;

    public static InputStreamReader makeInputReader(File file) throws FileNotFoundException {
        try {
            return new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(file)), "UTF-8");
        }
        catch (UnsupportedEncodingException ue) {
            throw new RuntimeException("broken JRE, no UTF-8");
        }
    }

    public static InputStreamReader makeInputReader(InputStream in) {
        try {
            return new InputStreamReader((InputStream)new BufferedInputStream(in), "UTF-8");
        }
        catch (UnsupportedEncodingException ue) {
            throw new RuntimeException("broken JRE, no UTF-8");
        }
    }

    public static OutputStreamWriter makeOutputWriter(File file) throws FileNotFoundException, IOException {
        try {
            return new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), "UTF-8");
        }
        catch (UnsupportedEncodingException ue) {
            throw new RuntimeException("broken JRE, no UTF-8");
        }
    }

    public static String getText(File file) throws FileNotFoundException, IOException {
        int count;
        if (file == null) {
            throw new NullPointerException("no file");
        }
        StringBuffer sb = new StringBuffer((int)file.length());
        InputStreamReader in = UnicodeFile.makeInputReader(file);
        char[] buf = new char[1024];
        while ((count = in.read(buf)) > 0) {
            sb.append(buf, 0, count);
        }
        ((Reader)in).close();
        return sb.toString();
    }

    public static String[] getTexts(String pathPattern) throws FileNotFoundException, IOException {
        if (pathPattern == null) {
            throw new NullPointerException("no path pattern");
        }
        if (pathPattern.indexOf("%i%") == -1) {
            return new String[]{UnicodeFile.getText(new File(pathPattern))};
        }
        ArrayList<String> contentList = new ArrayList<String>();
        int i = 0;
        String replacement = "";
        while (true) {
            File file;
            if (i > 0) {
                replacement = String.valueOf(i);
            }
            if (!(file = new File(pathPattern.replaceAll("\\%i\\%", replacement))).exists()) break;
            contentList.add(UnicodeFile.getText(file));
            ++i;
        }
        return contentList.toArray(new String[0]);
    }

    public static void setText(File file, String text) throws FileNotFoundException, IOException {
        if (file == null) {
            throw new NullPointerException("no file");
        }
        if (text == null) {
            throw new NullPointerException("no text");
        }
        OutputStreamWriter out = UnicodeFile.makeOutputWriter(file);
        out.write(text);
        ((Writer)out).close();
    }
}

