/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.runtime.provider;

import com.sun.encoder.runtime.OtdInputStream;
import com.sun.encoder.runtime.provider.SimpleOtdInputStreamImpl;
import com.sun.encoder.runtime.provider.StringOtdInputStreamImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class WrapOtdInputStream {
    private static final int CHUNK = 65536;

    public static byte[] getBytes(OtdInputStream in, boolean isDirect) throws IOException {
        if (in == null) {
            throw new NullPointerException("no input");
        }
        if (in instanceof StringOtdInputStreamImpl) {
            return ((StringOtdInputStreamImpl)in).getData();
        }
        byte[] data = new byte[65536];
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        if (isDirect && in instanceof SimpleOtdInputStreamImpl) {
            int last;
            InputStream ins = ((SimpleOtdInputStreamImpl)in).getInputStream();
            do {
                if ((last = ins.read(data)) <= 0) continue;
                outBytes.write(data, 0, last);
            } while (last != -1);
            ins.close();
        } else {
            int last;
            in.begin();
            do {
                if ((last = in.read(data)) <= 0) continue;
                outBytes.write(data, 0, last);
            } while (last != -1);
            in.end();
        }
        return outBytes.toByteArray();
    }

    public static byte[] getBytes(OtdInputStream in) throws IOException {
        return WrapOtdInputStream.getBytes(in, false);
    }

    public static InputStream getInputStream(OtdInputStream in) throws IOException {
        if (in == null) {
            throw new NullPointerException("no input");
        }
        if (in instanceof SimpleOtdInputStreamImpl) {
            return ((SimpleOtdInputStreamImpl)in).getInputStream();
        }
        return new InStream(in);
    }

    private static class InStream
    extends InputStream {
        private final OtdInputStream mIn;
        private static final int ASK = 10000;

        public InStream(OtdInputStream in) throws IOException {
            this.mIn = in;
            in.begin();
        }

        public int available() throws IOException {
            long at = this.mIn.mark().offset();
            for (int ask = 10000; ask > 0; ask /= 2) {
                try {
                    this.mIn.skip(ask);
                    this.mIn.rewind();
                    this.mIn.skip(at);
                    return ask;
                }
                catch (IOException ioe) {
                    continue;
                }
            }
            return 0;
        }

        public int read() throws IOException {
            return this.mIn.read();
        }

        public int read(byte[] b) throws IOException {
            return this.mIn.read(b);
        }

        public void close() throws IOException {
            this.mIn.end();
        }
    }
}

