/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.runtime;

import com.sun.encoder.runtime.provider.Base64Coder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class ReaderInputStream
extends InputStream {
    private static int defaultBufferSize = 2048;
    protected byte[] buf;
    protected int writepos;
    protected int readpos;
    protected int markpos = -1;
    protected int marklimit;
    protected OutputStream outputStream = new InternalOutputStream();
    private Reader reader;
    private Writer writer;
    private char[] cbuf;
    private boolean isBase64;
    private int cbufStart;

    public ReaderInputStream(Reader reader, String encoding) throws UnsupportedEncodingException {
        this(reader, encoding, defaultBufferSize);
    }

    public ReaderInputStream(Reader reader, String encoding, int bufferSize) throws UnsupportedEncodingException {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.reader = reader;
        if ("base64".equals(encoding)) {
            this.isBase64 = true;
        } else {
            this.writer = new OutputStreamWriter(this.getOutputStream(), encoding);
        }
        this.cbuf = new char[bufferSize];
        this.buf = new byte[bufferSize];
        this.cbufStart = 0;
    }

    private void fill(int requestedBytes) throws IOException {
        do {
            int chars;
            if (!this.isBase64) {
                chars = this.reader.read(this.cbuf);
                if (chars < 0) {
                    return;
                }
                this.writer.write(this.cbuf, 0, chars);
                this.writer.flush();
                continue;
            }
            int count = 0;
            for (chars = this.reader.read(this.cbuf, this.cbufStart, this.cbuf.length - this.cbufStart); this.cbufStart + chars < 4 && chars >= 0 && (count = this.reader.read(this.cbuf, this.cbufStart + chars, this.cbuf.length - this.cbufStart - chars)) >= 0; chars += count) {
            }
            count = chars >= 0 && count >= 0 ? (this.cbufStart + chars) / 4 * 4 : (chars >= 0 ? this.cbufStart + chars : this.cbufStart);
            this.getOutputStream().write(Base64Coder.decodeToBytes(new String(this.cbuf, 0, count)));
            if (chars >= 0) {
                for (int i = count; i < chars + this.cbufStart; ++i) {
                    this.cbuf[i - count] = this.cbuf[i];
                }
                this.cbufStart = chars + this.cbufStart - count;
                continue;
            }
            this.cbufStart = 0;
            break;
        } while (this.available() <= requestedBytes);
    }

    private OutputStream getOutputStream() {
        return this.outputStream;
    }

    private void shift(int cb) {
        int savepos = this.readpos;
        if (this.markpos > 0) {
            if (this.readpos - this.markpos > this.marklimit) {
                this.markpos = -1;
            } else {
                savepos = this.markpos;
            }
        }
        int size = this.writepos - savepos;
        if (savepos > 0 && this.buf.length - size >= cb && size <= cb) {
            System.arraycopy(this.buf, savepos, this.buf, 0, size);
        } else {
            int newcount = size + cb;
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, savepos, newbuf, 0, size);
            this.buf = newbuf;
        }
        if (savepos > 0) {
            this.readpos -= savepos;
            if (this.markpos > 0) {
                this.markpos -= savepos;
            }
            this.writepos -= savepos;
        }
    }

    public int read() throws IOException {
        if (this.readpos >= this.writepos) {
            this.fill(1);
            if (this.readpos >= this.writepos) {
                return -1;
            }
        }
        return this.buf[this.readpos++] & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int avail = this.writepos - this.readpos;
        if (avail < len) {
            this.fill(len - avail);
            avail = this.writepos - this.readpos;
            if (avail <= 0) {
                return -1;
            }
        }
        int cnt = avail < len ? avail : len;
        System.arraycopy(this.buf, this.readpos, b, off, cnt);
        this.readpos += cnt;
        return cnt;
    }

    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        long avail = this.writepos - this.readpos;
        if (avail < n) {
            long req = n - avail;
            if (req > Integer.MAX_VALUE) {
                req = Integer.MAX_VALUE;
            }
            this.fill((int)req);
            avail = this.writepos - this.readpos;
            if (avail <= 0L) {
                return 0L;
            }
        }
        long skipped = avail < n ? avail : n;
        this.readpos = (int)((long)this.readpos + skipped);
        return skipped;
    }

    public int available() {
        return this.writepos - this.readpos;
    }

    public void mark(int readlimit) {
        this.marklimit = readlimit;
        this.markpos = this.readpos;
    }

    public void reset() throws IOException {
        if (this.markpos < 0) {
            throw new IOException("Resetting to invalid mark");
        }
        this.readpos = this.markpos;
    }

    public boolean markSupported() {
        return true;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    private class InternalOutputStream
    extends OutputStream {
        private InternalOutputStream() {
        }

        public void write(int b) throws IOException {
            if (ReaderInputStream.this.writepos + 1 > ReaderInputStream.this.buf.length) {
                ReaderInputStream.this.shift(1);
            }
            ReaderInputStream.this.buf[ReaderInputStream.this.writepos] = (byte)b;
            ++ReaderInputStream.this.writepos;
        }

        public void write(byte[] b, int off, int len) {
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            if (ReaderInputStream.this.writepos + len > ReaderInputStream.this.buf.length) {
                ReaderInputStream.this.shift(len);
            }
            System.arraycopy(b, off, ReaderInputStream.this.buf, ReaderInputStream.this.writepos, len);
            ReaderInputStream.this.writepos += len;
        }
    }
}

