/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncoderProperties
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PREDECODE_CHAR_CODING = "predecoding_char_coding";
    public static final String POSTENCODE_CHAR_CODING = "postencoding_char_coding";
    public static final Map<Object, Object> mKeyAliases = new HashMap<Object, Object>();
    private final boolean mImmutable;
    private Map<Object, Object> mProperties = new HashMap<Object, Object>();

    private EncoderProperties(boolean immutable) {
        this.mImmutable = immutable;
    }

    public EncoderProperties() {
        this(false);
    }

    public void setPreDecodeCharCoding(String coding) {
        this.mProperties.put(PREDECODE_CHAR_CODING, coding);
    }

    public String getPreDecodeCharCoding() {
        return (String)this.mProperties.get(PREDECODE_CHAR_CODING);
    }

    public void setPostEncodeCharCoding(String coding) {
        this.mProperties.put(POSTENCODE_CHAR_CODING, coding);
    }

    public String getPostEncodeCharCoding() {
        return (String)this.mProperties.get(POSTENCODE_CHAR_CODING);
    }

    public void addAll(EncoderProperties props) {
        this.assertAccess("addAll");
        this.mProperties.putAll(props.mProperties);
    }

    public void setProperty(Object propertyKey) throws UnsupportedOperationException {
        this.setProperty(propertyKey, null);
    }

    public boolean hasProperty(Object propertyKey) {
        return this.mProperties.containsKey(propertyKey);
    }

    public void setProperty(Object propertyKey, Object value) throws UnsupportedOperationException {
        this.assertAccess("setProperty()");
        if (mKeyAliases.containsKey(propertyKey)) {
            this.mProperties.put(mKeyAliases.get(propertyKey), value);
        } else {
            this.mProperties.put(propertyKey, value);
        }
    }

    public Object getProperty(Object propertyKey) {
        if (mKeyAliases.containsKey(propertyKey)) {
            return this.mProperties.get(mKeyAliases.get(propertyKey));
        }
        return this.mProperties.get(propertyKey);
    }

    public <T> T getProperty(Object propertyKey, Class<T> clazz) {
        return (T)this.mProperties.get(propertyKey);
    }

    public void removeProperty(Object propertyKey) throws UnsupportedOperationException {
        this.assertAccess("removeProperty()");
        this.mProperties.remove(propertyKey);
    }

    public boolean isEmpty() {
        return this.mProperties.isEmpty();
    }

    public Set<Map.Entry<Object, Object>> getProperties() {
        if (this.mImmutable) {
            return Collections.unmodifiableSet(this.mProperties.entrySet());
        }
        return this.mProperties.entrySet();
    }

    public boolean immutable() {
        return this.mImmutable;
    }

    public EncoderProperties cloneMutable() {
        EncoderProperties props = new EncoderProperties(false);
        props.mProperties.putAll(this.mProperties);
        return props;
    }

    public EncoderProperties cloneImmutable() {
        EncoderProperties props = new EncoderProperties(true);
        props.mProperties.putAll(this.mProperties);
        return props;
    }

    private void assertAccess(String operation) {
        if (this.mImmutable) {
            throw new UnsupportedOperationException("The operation " + operation + " is not supported because " + "the property set is immutable.");
        }
    }

    static {
        mKeyAliases.put("pdcc", PREDECODE_CHAR_CODING);
        mKeyAliases.put("pecc", POSTENCODE_CHAR_CODING);
    }
}

