/*
 * Decompiled with CFR 0.152.
 */
package com.sun.sql.framework.utils;

import com.sun.sql.framework.utils.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    public static final String ALPHA_NUMERIC_REGEX = "([_a-zA-Z0-9-]+)";
    public static final String EMAIL_REGEX = "([_a-z0-9-]+(\\.[_a-z0-9-]+)*@[a-z0-9-]+(\\.[a-z0-9-]+)+)";
    public static final String FILE_NAME_REGEX = "([_.a-zA-Z0-9-]+)";
    public static final String[][] FILE_TO_TABLE_MAPPINGS = new String[][]{{".", "_"}, {":", "_"}, {";", "_"}, {",", "_"}, {" ", "_"}, {"'", "_"}, {"\"", "_"}, {"-", "_"}};
    public static HashMap formats = new HashMap();
    public static final String NAME_REGEX = "([ _a-zA-Z0-9-]+)";
    public static final String NUMERIC_REGEX = "([0-9]+(\\.[0-9]+)+)";
    public static final String SQL_IDENTIFIER_REGEX = "[a-zA-Z]+[_a-zA-Z0-9]*";
    public static final String URL_REGEX = "\\w+:\\/\\/([^:\\/]+)(:\\d+)?(\\/.*)?";
    private static final String[][] CONTROL_CHAR_MAPPINGS = new String[][]{{"\r", "\\r"}, {"\n", "\\n"}, {"\t", "\\t"}};
    private static final String[][] FIELD_TO_COLUMN_MAPPINGS = FILE_TO_TABLE_MAPPINGS;
    private static final String[][] ILLEGAL_RUNTIMEVALUE_MAPPINGS = new String[][]{{"\r\n", ""}, {"\r", ""}, {"\n", ""}};
    private static final String FOUR_ZEROS = "0000";
    private static final String LOG_CATEGORY = StringUtil.class.getName();
    private static String PATTERN_STRING_AND_OR = "[^'\"a-zA-Z0-9][\\s\\)]+AND[\\s\\(]+[^'\"a-zA-Z0-9]|[^'\"a-zA-Z0-9][\\s\\)]+OR[\\s\\(]+[^'\"a-zA-Z0-9]";
    private static Pattern PATTERN_AND_OR = Pattern.compile(PATTERN_STRING_AND_OR);

    public static String createColumnNameFromFieldName(String victim) {
        return StringUtil.substituteFromMapping(victim.toUpperCase().trim(), FIELD_TO_COLUMN_MAPPINGS);
    }

    public static final synchronized String createDelimitedStringFrom(List strings) {
        return StringUtil.createDelimitedStringFrom(strings, ',');
    }

    public static final synchronized String createDelimitedStringFrom(List strings, char delimiter) {
        if (strings == null || strings.size() == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer(strings.size() * 10);
        for (int i = 0; i < strings.size(); ++i) {
            if (i != 0) {
                buf.append(delimiter);
            }
            buf.append(((String)strings.get(i)).trim());
        }
        return buf.toString();
    }

    public static String createSQLIdentifier(String victim) {
        String workingName = victim.toUpperCase().trim();
        return workingName.replaceAll("^[^A-Za-z]+", "").replaceAll("[^A-Za-z0-9_]", "_");
    }

    public static final List createStringListFrom(String delimitedList) {
        return StringUtil.createStringListFrom(delimitedList, ',');
    }

    public static final List createStringListFrom(String delimitedList, char delimiter) {
        if (delimitedList == null || delimitedList.trim().length() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> strings = Collections.EMPTY_LIST;
        StringTokenizer tok = new StringTokenizer(delimitedList, String.valueOf(delimiter));
        if (tok.hasMoreTokens()) {
            strings = new ArrayList<String>();
            do {
                strings.add(tok.nextToken().trim());
            } while (tok.hasMoreTokens());
        }
        return strings;
    }

    public static String createTableNameFromFileName(String victim) {
        return StringUtil.substituteFromMapping(victim.toUpperCase().trim(), FILE_TO_TABLE_MAPPINGS);
    }

    public static String escapeNonAlphaNumericCharacters(String iStr) {
        StringBuffer sb = new StringBuffer();
        int len = iStr.length();
        String hexStr = null;
        for (int i = 0; i < len; ++i) {
            if (!Character.isLetterOrDigit(iStr.charAt(i)) && iStr.charAt(i) != '.') {
                sb.append("_u");
                hexStr = Integer.toHexString(iStr.charAt(i));
                if (hexStr.length() < 4) {
                    sb.append(FOUR_ZEROS.substring(0, 4 - hexStr.length()));
                }
                sb.append(hexStr);
                continue;
            }
            sb.append(iStr.charAt(i));
        }
        return sb.toString();
    }

    public static String escapeControlChars(String raw) {
        return StringUtil.substituteFromMapping(raw, CONTROL_CHAR_MAPPINGS, false);
    }

    public static String escapeJavaLiteral(String s) {
        int length;
        int newLength = length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case '\"': 
                case '\'': 
                case '\\': {
                    ++newLength;
                }
            }
        }
        if (length == newLength) {
            return s;
        }
        StringBuffer sb = new StringBuffer(newLength);
        block12: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    continue block12;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block12;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block12;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block12;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block12;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block12;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String escapeSQL(String s) {
        int length;
        int newLength = length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': 
                case '\'': 
                case '0': 
                case '\\': {
                    ++newLength;
                }
            }
        }
        if (length == newLength) {
            return s;
        }
        StringBuffer sb = new StringBuffer(newLength);
        block10: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block10;
                }
                case '0': {
                    sb.append("\\0");
                    continue block10;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static Map getFormats() {
        if (formats.isEmpty()) {
            formats.put("numeric", NUMERIC_REGEX);
            formats.put("alphanumeric", ALPHA_NUMERIC_REGEX);
            formats.put("email", EMAIL_REGEX);
            formats.put("name", NAME_REGEX);
            formats.put("url", URL_REGEX);
            formats.put("filename", FILE_NAME_REGEX);
            formats.put("sqlidentifier", SQL_IDENTIFIER_REGEX);
        }
        return formats;
    }

    public static int getInt(String type) {
        if (!StringUtil.isNullString(type)) {
            try {
                return Integer.parseInt(type.trim());
            }
            catch (NumberFormatException ignore) {
                Logger.print(10000, LOG_CATEGORY, ignore.toString());
            }
        }
        return Integer.MIN_VALUE;
    }

    public static boolean isIdentical(String one, String two) {
        if (one == two) {
            return true;
        }
        return one == null ? two == null : two != null && one.compareTo(two) == 0;
    }

    public static boolean isIdenticalIgnoreCase(String one, String two) {
        if (one == two) {
            return true;
        }
        return one == null ? two == null : two != null && one.compareToIgnoreCase(two) == 0;
    }

    public static boolean isIdentical(String one, String two, boolean emptStringEqualsNull) {
        String empty = "";
        if (emptStringEqualsNull) {
            if (one == null) {
                one = empty;
            }
            if (two == null) {
                two = empty;
            }
        }
        return StringUtil.isIdentical(one, two);
    }

    public static boolean isNullString(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isValid(String str, String regexp) {
        if (StringUtil.isNullString(str) || StringUtil.isNullString(regexp)) {
            return false;
        }
        try {
            return str.matches(regexp);
        }
        catch (Exception e) {
            Logger.print(10000, LOG_CATEGORY, e.toString());
            return false;
        }
    }

    public static String normalizeDirSeparatorsToUNIX(String rawDirectoryPath) {
        if ("\\".equals(File.separator)) {
            return rawDirectoryPath.replaceAll("\\\\", "/");
        }
        return rawDirectoryPath;
    }

    public static String removeIllegalRuntimeValueChars(String rawString) {
        return StringUtil.substituteFromMapping(rawString, ILLEGAL_RUNTIMEVALUE_MAPPINGS);
    }

    public static String replace(String str, Map pairs) {
        if (StringUtil.isNullString(str) || pairs == null || pairs.size() == 0) {
            return str;
        }
        try {
            String result = str;
            Object[] keys = pairs.keySet().toArray();
            for (int i = 0; i < keys.length; ++i) {
                String regexp = "(\\{" + (String)keys[i] + "\\})";
                result = StringUtil.replaceAll(result, (String)pairs.get(keys[i]), regexp);
            }
            return result;
        }
        catch (Exception e) {
            Logger.print(10000, LOG_CATEGORY, e.toString());
            return str;
        }
    }

    public static String replace(String str, Map pairs, String regExpPrefix) {
        if (StringUtil.isNullString(str) || pairs == null || pairs.size() == 0 || StringUtil.isNullString(regExpPrefix)) {
            return str;
        }
        try {
            String result = str;
            Object[] keys = pairs.keySet().toArray();
            for (int i = 0; i < keys.length; ++i) {
                String regexp = "(\\" + regExpPrefix + (String)keys[i] + ")";
                result = StringUtil.replaceAll(result, (String)pairs.get(keys[i]), regexp);
            }
            return result;
        }
        catch (Exception e) {
            Logger.print(10000, LOG_CATEGORY, e.toString());
            return str;
        }
    }

    public static String replaceAll(String strToReplace, String strReplaceWith, String regexp) {
        Pattern pattern = Pattern.compile(regexp, 10);
        Matcher matcher = pattern.matcher(strToReplace);
        return matcher.replaceAll(StringUtil.escapeJavaRegexpChars(strReplaceWith));
    }

    public static String replaceFirst(String strToReplace, String strReplaceWith, String regexp) {
        Pattern pattern = Pattern.compile(regexp, 10);
        Matcher matcher = pattern.matcher(strToReplace);
        return matcher.replaceFirst(StringUtil.escapeJavaRegexpChars(strReplaceWith));
    }

    public static String replaceInString(String originalString, String victim, String replacement) {
        return StringUtil.replaceInString(originalString, new String[]{victim}, new String[]{replacement});
    }

    public static String replaceInString(String originalString, String[] victims, String[] replacements) {
        StringBuffer resultBuffer = new StringBuffer();
        boolean bReplaced = false;
        for (int charPosition = 0; charPosition < originalString.length(); ++charPosition) {
            for (int nSelected = 0; !bReplaced && nSelected < victims.length; ++nSelected) {
                if (!originalString.startsWith(victims[nSelected], charPosition)) continue;
                resultBuffer.append(replacements[nSelected]);
                bReplaced = true;
                charPosition += victims[nSelected].length() - 1;
            }
            if (!bReplaced) {
                resultBuffer.append(originalString.charAt(charPosition));
                continue;
            }
            bReplaced = false;
        }
        return resultBuffer.toString();
    }

    public static String substituteFromMapping(String raw, String[][] mappings) {
        return StringUtil.substituteFromMapping(raw, mappings, false);
    }

    public static String unescapeControlChars(String cooked) {
        return StringUtil.substituteFromMapping(cooked, CONTROL_CHAR_MAPPINGS, true);
    }

    public static String escapeJavaRegexpChars(String rawString) {
        String cookedString = null;
        if (rawString != null) {
            cookedString = rawString.replaceAll("\\\\", "\\\\\\\\");
            cookedString = cookedString.replaceAll("\\$", "\\\\\\$");
            cookedString = cookedString.replaceAll("\\?", "\\\\\\?");
        }
        return cookedString;
    }

    private static String substituteFromMapping(String raw, String[][] mappings, boolean useReverseMap) {
        String cooked = raw;
        if (mappings != null) {
            int toggle = useReverseMap ? 0 : 1;
            for (int i = 0; i < mappings.length; ++i) {
                cooked = StringUtil.replaceInString(cooked, mappings[i][1 - toggle], mappings[i][toggle]);
            }
        }
        return cooked;
    }

    public static String insertStringBeforeLogicalOperators(String origStr, String markupString) {
        if (origStr == null || markupString == null) {
            return origStr;
        }
        StringBuffer sb = new StringBuffer(origStr);
        Matcher matcher = PATTERN_AND_OR.matcher(origStr);
        int toInsertIndex = -1;
        int prevInsertedStrLength = 0;
        String matchedOperator = null;
        while (matcher.find()) {
            matchedOperator = matcher.group();
            toInsertIndex = matchedOperator.indexOf("AND");
            if (toInsertIndex < 0) {
                toInsertIndex = matchedOperator.indexOf("OR");
            }
            if (toInsertIndex != -1) {
                sb.insert((toInsertIndex += matcher.start()) + prevInsertedStrLength, markupString);
                prevInsertedStrLength += markupString.length();
            }
            toInsertIndex = -1;
        }
        return sb.toString();
    }
}

