/*
 * Decompiled with CFR 0.152.
 */
package com.sun.sql.framework.jdbc;

import com.sun.sql.framework.exception.BaseException;
import com.sun.sql.framework.utils.Logger;
import com.sun.sql.framework.utils.RuntimeAttribute;
import com.sun.sql.framework.utils.StringUtil;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeMap;

public class SQLUtils {
    static final String LOG_CATEGORY = SQLUtils.class.getName();
    public static final int VARCHAR_UNQUOTED = 3345336;
    private static final int ANYTYPE_CONSTANT = 3345335;
    public static final String VARCHAR_UNQUOTED_STR = "varchar:unquoted";
    public static final int JDBCSQL_TYPE_UNDEFINED = -65535;
    private static HashMap dataTypePrecedenceMap = new HashMap();
    private static Map dbIdNameMap = new TreeMap();
    private static Map dbNameIdMap = new TreeMap();
    private static Map JDBC_SQL_MAP = new HashMap();
    private static Map SQL_JDBC_MAP = new HashMap();
    private static final List SUPPORTED_DATE_FORMATS = new ArrayList();
    private static final List SUPPORTED_DATE_PARTS = new ArrayList();
    private static final List SUPPORTED_INTERVAL_TYPES = new ArrayList();
    private static final List SUPPORTED_LITERAL_JDBC_TYPES = new ArrayList();
    private static final List SUPPORTED_CAST_JDBC_TYPES = new ArrayList();

    public static long convertFromIso8601(String isoDateTime) {
        return SQLUtils.getCalendar(isoDateTime).getTimeInMillis();
    }

    public static String createPreparedStatement(String rawSql, Map attrMap, List paramList) {
        Iterator iter = attrMap.values().iterator();
        if (!iter.hasNext()) {
            return rawSql;
        }
        if (paramList != null) {
            List orderedSymbolList = SQLUtils.getOrderedSymbolList(rawSql, attrMap);
            paramList.clear();
            paramList.addAll(orderedSymbolList);
        }
        String processedSql = rawSql;
        do {
            RuntimeAttribute attr = (RuntimeAttribute)iter.next();
            boolean flag = false;
            do {
                flag = !rawSql.equals(processedSql = StringUtil.replaceFirst(processedSql, "?", "\\$" + attr.getAttributeName()));
                rawSql = processedSql;
            } while (flag);
        } while (iter.hasNext());
        Logger.print(10000, LOG_CATEGORY, ">>> Generated PreparedStatement: \n" + processedSql);
        return processedSql;
    }

    public static String createPreparedStatement(String rawSql, List symbols, List orderedSymbols) {
        String symbol = null;
        boolean noMore = false;
        Iterator iter = symbols.iterator();
        if (!iter.hasNext()) {
            return rawSql;
        }
        if (orderedSymbols != null) {
            List orderedSymbolList = SQLUtils.getOrderedSymbolList(rawSql, symbols);
            orderedSymbols.clear();
            orderedSymbols.addAll(orderedSymbolList);
        }
        String processedSql = rawSql;
        do {
            if ((symbol = (String)iter.next()) != null && symbol.startsWith("$")) {
                symbol = "\\" + symbol;
            }
            noMore = false;
            do {
                noMore = !rawSql.equals(processedSql = StringUtil.replaceFirst(processedSql, "?", symbol));
                rawSql = processedSql;
            } while (noMore);
        } while (iter.hasNext());
        Logger.print(10000, LOG_CATEGORY, ">>> Generated PreparedStatement: \n" + processedSql);
        return processedSql;
    }

    public static String replaceTableNameFromRuntimeArguments(String sqlStr, Map attrMap) {
        Iterator iter = attrMap.values().iterator();
        if (!iter.hasNext()) {
            return sqlStr;
        }
        ArrayList paramList = new ArrayList();
        List orderedSymbolList = SQLUtils.getOrderedSymbolList(sqlStr, attrMap);
        paramList.clear();
        paramList.addAll(orderedSymbolList);
        String processedSql = sqlStr;
        do {
            RuntimeAttribute attr = (RuntimeAttribute)iter.next();
            boolean flag = false;
            do {
                String tmpStr;
                if ((tmpStr = StringUtil.replaceTagString("$" + attr.getAttributeName() + "$", processedSql, attr.getAttributeObject().toString())) != null) {
                    processedSql = tmpStr;
                }
                flag = !sqlStr.equals(processedSql);
                sqlStr = processedSql;
            } while (flag);
        } while (iter.hasNext());
        Logger.print(10000, LOG_CATEGORY, ">>> Generated Statement: \n" + processedSql);
        return processedSql;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GregorianCalendar getCalendar(String isodate) {
        StringTokenizer st = new StringTokenizer(isodate, "-T:.+Z", true);
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.clear();
        try {
            if (!st.hasMoreTokens()) {
                return calendar;
            }
            int year = Integer.parseInt(st.nextToken());
            calendar.set(1, year);
            if (!SQLUtils.check(st, "-") || !st.hasMoreTokens()) {
                return calendar;
            }
            int month = Integer.parseInt(st.nextToken()) - 1;
            calendar.set(2, month);
            if (!SQLUtils.check(st, "-") || !st.hasMoreTokens()) {
                return calendar;
            }
            int day = Integer.parseInt(st.nextToken());
            calendar.set(5, day);
            if (!SQLUtils.check(st, "T") || !st.hasMoreTokens()) {
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                return calendar;
            }
            int hour = Integer.parseInt(st.nextToken());
            calendar.set(11, hour);
            if (!SQLUtils.check(st, ":") || !st.hasMoreTokens()) {
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                return calendar;
            }
            int minutes = Integer.parseInt(st.nextToken());
            calendar.set(12, minutes);
            if (!st.hasMoreTokens()) {
                return calendar;
            }
            String tok = st.nextToken();
            if (tok.equals(":")) {
                if (!st.hasMoreTokens()) throw new RuntimeException("No secondes specified");
                int secondes = Integer.parseInt(st.nextToken());
                calendar.set(13, secondes);
                if (!st.hasMoreTokens()) {
                    return calendar;
                }
                tok = st.nextToken();
                if (tok.equals(".")) {
                    String nt = st.nextToken();
                    while (nt.length() < 3) {
                        nt = nt + "0";
                    }
                    nt = nt.substring(0, 3);
                    int millisec = Integer.parseInt(nt);
                    calendar.set(14, millisec);
                    if (!st.hasMoreTokens()) {
                        return calendar;
                    }
                    tok = st.nextToken();
                } else {
                    calendar.set(14, 0);
                }
            } else {
                calendar.set(13, 0);
                calendar.set(14, 0);
            }
            if (tok.equals("Z")) return calendar;
            if (!tok.equals("+") && !tok.equals("-")) {
                throw new RuntimeException("only Z, + or - allowed");
            }
            boolean plus = tok.equals("+");
            if (!st.hasMoreTokens()) {
                throw new RuntimeException("Missing hour field");
            }
            int tzhour = Integer.parseInt(st.nextToken());
            if (!SQLUtils.check(st, ":") || !st.hasMoreTokens()) {
                throw new RuntimeException("Missing minute field");
            }
            int tzmin = Integer.parseInt(st.nextToken());
            if (!plus) {
                calendar.add(10, tzhour);
                calendar.add(12, tzmin);
                return calendar;
            } else {
                calendar.add(10, -tzhour);
                calendar.add(12, -tzmin);
            }
            return calendar;
        }
        catch (NumberFormatException ex) {
            throw new RuntimeException("[" + ex.getMessage() + "] is not an integer");
        }
    }

    public static int getResultantDataType(int dataType1, int dataType2) {
        Integer dPrecedence1 = (Integer)dataTypePrecedenceMap.get(new Integer(dataType1));
        Integer dPrecedence2 = (Integer)dataTypePrecedenceMap.get(new Integer(dataType1));
        int retDataType = dPrecedence1 != null && dPrecedence2 != null ? (dPrecedence1 > dPrecedence2 ? dataType1 : dataType2) : (dPrecedence1 != null ? dataType1 : (dPrecedence2 != null ? dataType2 : dataType1));
        return retDataType;
    }

    public static int getStdJdbcType(String dataType) throws IllegalArgumentException {
        if (StringUtil.isNullString(dataType)) {
            throw new IllegalArgumentException("Must supply non-empty String value for dataType.");
        }
        Object intStr = SQL_JDBC_MAP.get(dataType.toLowerCase().trim());
        if (intStr instanceof String) {
            return Integer.parseInt((String)intStr);
        }
        return -65535;
    }

    public static String getStdSqlType(int dataType) throws IllegalArgumentException {
        Object o = JDBC_SQL_MAP.get(String.valueOf(dataType));
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    public static List getStdSqlTypes() {
        return new ArrayList(JDBC_SQL_MAP.keySet());
    }

    public static List getSupportedDateParts() {
        return SUPPORTED_DATE_PARTS;
    }

    public static int getSupportedDBType(String dbName) {
        Integer dbType;
        String normalizedName = dbName.toUpperCase().trim();
        if (normalizedName.startsWith("DB2")) {
            normalizedName = "DB2V7";
        }
        if ((dbType = (Integer)dbNameIdMap.get(normalizedName)) != null) {
            return dbType;
        }
        return 15;
    }

    public static String getSupportedDBType(int dbType) {
        String dbName = (String)dbIdNameMap.get(new Integer(dbType));
        if (dbName != null) {
            return dbName;
        }
        return "JDBCDB";
    }

    public static Set getSupportedDBTypes() {
        return dbNameIdMap.keySet();
    }

    public static List getSupportedFormatTypes() {
        return SUPPORTED_DATE_FORMATS;
    }

    public static List getSupportedIntervalTypes() {
        return SUPPORTED_INTERVAL_TYPES;
    }

    public static List getSupportedLiteralTypes() {
        return SUPPORTED_LITERAL_JDBC_TYPES;
    }

    public static List getSupportedCastTypes() {
        return SUPPORTED_CAST_JDBC_TYPES;
    }

    public static synchronized boolean isStdJdbcType(int jdbcType) {
        return SQL_JDBC_MAP.containsValue(String.valueOf(jdbcType));
    }

    public static String makeStringOracleSafe(String value) {
        if (value.indexOf("'") == -1) {
            return value;
        }
        StringBuffer newValue = new StringBuffer();
        for (int i = 0; i < value.length(); ++i) {
            char currChar = value.charAt(i);
            if (currChar == '\'') {
                newValue.append(currChar);
            }
            newValue.append(currChar);
        }
        return newValue.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void populatePreparedStatement(PreparedStatement ps, Map attrMap, List paramList) throws BaseException {
        ListIterator iter = paramList.listIterator();
        try {
            block10: while (iter.hasNext()) {
                String attrName = (String)iter.next();
                RuntimeAttribute attr = (RuntimeAttribute)attrMap.get(attrName);
                int index = iter.nextIndex();
                int jdbcType = attr.getJdbcType();
                Object valueObj = attr.getAttributeObject();
                Number numberObj = null;
                switch (jdbcType) {
                    case 8: {
                        numberObj = valueObj instanceof Number ? (Number)((Number)valueObj) : (Number)Double.valueOf(valueObj.toString());
                        ps.setDouble(index, numberObj.doubleValue());
                        continue block10;
                    }
                    case 6: {
                        numberObj = valueObj instanceof Number ? (Number)((Number)valueObj) : (Number)Float.valueOf(valueObj.toString());
                        ps.setFloat(index, numberObj.floatValue());
                        continue block10;
                    }
                    case 4: {
                        numberObj = valueObj instanceof Number ? (Number)((Number)valueObj) : (Number)Integer.valueOf(valueObj.toString());
                        ps.setInt(index, numberObj.intValue());
                        continue block10;
                    }
                    case 93: {
                        long ts = SQLUtils.convertFromIso8601(valueObj.toString());
                        Logger.print(10000, LOG_CATEGORY, "**** timestamp **** " + ts);
                        try {
                            ps.setTimestamp(index, new Timestamp(ts));
                        }
                        catch (SQLException e) {
                            ps.setDate(index, new Date(ts));
                        }
                        continue block10;
                    }
                }
                ps.setString(index, valueObj.toString());
            }
            return;
        }
        catch (Exception e) {
            String details = e.getMessage();
            if (StringUtil.isNullString(details)) {
                details = e.toString();
            }
            Logger.printThrowable(10000, LOG_CATEGORY, null, details, e);
            throw new BaseException(details, e);
        }
    }

    public static Map getRuntimeInputNameValueMap(Map attribMap) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        RuntimeAttribute ra = null;
        int jdbcType = 0;
        Object valueObj = null;
        Number numberObj = null;
        if (attribMap != null) {
            Set keys = attribMap.keySet();
            Iterator itr = keys.iterator();
            String name = null;
            block8: while (itr.hasNext()) {
                name = (String)itr.next();
                ra = (RuntimeAttribute)attribMap.get(name);
                jdbcType = ra.getJdbcType();
                valueObj = ra.getAttributeObject();
                numberObj = null;
                switch (jdbcType) {
                    case 8: {
                        numberObj = valueObj instanceof Number ? (Number)((Number)valueObj) : (Number)Double.valueOf(valueObj.toString());
                        values.put(name, numberObj);
                        continue block8;
                    }
                    case 6: {
                        numberObj = valueObj instanceof Number ? (Number)((Number)valueObj) : (Number)Float.valueOf(valueObj.toString());
                        values.put(name, numberObj);
                        continue block8;
                    }
                    case 4: {
                        numberObj = valueObj instanceof Number ? (Number)((Number)valueObj) : (Number)Integer.valueOf(valueObj.toString());
                        values.put(name, numberObj);
                        continue block8;
                    }
                    case 93: {
                        long ts = SQLUtils.convertFromIso8601(valueObj.toString());
                        Logger.print(10000, LOG_CATEGORY, "**** timestamp **** " + ts);
                        try {
                            values.put(name, new Timestamp(ts));
                        }
                        catch (Exception e) {
                            values.put(name, new Date(ts));
                        }
                        continue block8;
                    }
                }
                values.put(name, valueObj.toString());
            }
        }
        return values;
    }

    public static void setAttributeValue(PreparedStatement ps, int index, int jdbcType, Object valueObj) throws BaseException {
        Number numberObj = null;
        try {
            switch (jdbcType) {
                case 8: {
                    numberObj = valueObj instanceof Number ? (Number)((Number)valueObj) : (Number)Double.valueOf(valueObj.toString());
                    ps.setDouble(index, numberObj.doubleValue());
                    break;
                }
                case 6: {
                    numberObj = valueObj instanceof Number ? (Number)((Number)valueObj) : (Number)Float.valueOf(valueObj.toString());
                    ps.setFloat(index, numberObj.floatValue());
                    break;
                }
                case 4: {
                    numberObj = valueObj instanceof Number ? (Number)((Number)valueObj) : (Number)Integer.valueOf(valueObj.toString());
                    ps.setInt(index, numberObj.intValue());
                    break;
                }
                case 93: {
                    long ts = SQLUtils.convertFromIso8601(valueObj.toString());
                    Logger.print(10000, LOG_CATEGORY, "**** timestamp **** " + ts);
                    try {
                        ps.setTimestamp(index, new Timestamp(ts));
                    }
                    catch (SQLException e) {
                        ps.setDate(index, new Date(ts));
                    }
                    break;
                }
                default: {
                    ps.setString(index, valueObj.toString());
                    break;
                }
            }
        }
        catch (Exception e) {
            String details = e.getMessage();
            if (StringUtil.isNullString(details)) {
                details = e.toString();
            }
            Logger.printThrowable(10000, LOG_CATEGORY, null, details, e);
            throw new BaseException(details, e);
        }
    }

    public static boolean isPrecisionRequired(int jdbcType) {
        switch (jdbcType) {
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 70: 
            case 91: 
            case 92: 
            case 93: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: {
                return false;
            }
        }
        return true;
    }

    public static boolean isScaleRequired(int type) {
        switch (type) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public static boolean isBinary(int jdbcType) {
        switch (jdbcType) {
            case -4: 
            case -3: 
            case -2: {
                return true;
            }
        }
        return false;
    }

    private static boolean check(StringTokenizer st, String token) throws RuntimeException {
        try {
            if (st.nextToken().equals(token)) {
                return true;
            }
            throw new RuntimeException("Missing [" + token + "]");
        }
        catch (NoSuchElementException ex) {
            return false;
        }
    }

    private static List getOrderedSymbolList(String rawSql, List symbolList) {
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        String symbolName = null;
        if (rawSql != null && symbolList != null) {
            Iterator iter = symbolList.iterator();
            int pos = -1;
            int indexFrom = 0;
            while (iter.hasNext()) {
                symbolName = (String)iter.next();
                indexFrom = 0;
                boolean morePresent = true;
                while (morePresent) {
                    pos = rawSql.indexOf(symbolName, indexFrom);
                    if (pos >= 0) {
                        map.put(new Integer(pos), symbolName);
                        indexFrom = pos + symbolName.length();
                        continue;
                    }
                    morePresent = false;
                }
            }
        }
        return new ArrayList(map.values());
    }

    private static List getOrderedSymbolList(String rawSql, Map attrMap) {
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        if (rawSql != null && attrMap != null) {
            Iterator iter = attrMap.values().iterator();
            RuntimeAttribute attr = null;
            int pos = -1;
            int indexFrom = 0;
            while (iter.hasNext()) {
                attr = (RuntimeAttribute)iter.next();
                indexFrom = 0;
                boolean morePresent = true;
                while (morePresent) {
                    pos = rawSql.indexOf("$" + attr.getAttributeName(), indexFrom);
                    if (pos >= 0) {
                        map.put(new Integer(pos), attr.getAttributeName());
                        indexFrom = pos + attr.getAttributeName().length();
                        continue;
                    }
                    morePresent = false;
                }
            }
        }
        return new ArrayList(map.values());
    }

    private SQLUtils() {
    }

    static {
        dbNameIdMap.put("ANSI92", new Integer(10));
        dbNameIdMap.put("ORACLE8", new Integer(20));
        dbNameIdMap.put("ORACLE9", new Integer(30));
        dbNameIdMap.put("INTERNAL", new Integer(50));
        dbNameIdMap.put("DERBY", new Integer(80));
        dbNameIdMap.put("MSSQLSERVER", new Integer(60));
        dbNameIdMap.put("DB2V7", new Integer(40));
        dbNameIdMap.put("DB2V8", new Integer(45));
        dbNameIdMap.put("DB2V5", new Integer(42));
        dbNameIdMap.put("SYBASE", new Integer(70));
        dbIdNameMap.put(new Integer(10), "ANSI92");
        dbIdNameMap.put(new Integer(20), "ORACLE8");
        dbIdNameMap.put(new Integer(30), "ORACLE9");
        dbIdNameMap.put(new Integer(50), "INTERNAL");
        dbIdNameMap.put(new Integer(80), "DERBY");
        dbIdNameMap.put(new Integer(60), "MSSQLSERVER");
        dbIdNameMap.put(new Integer(40), "DB2V7");
        dbIdNameMap.put(new Integer(45), "DB2V8");
        dbIdNameMap.put(new Integer(42), "DB2V5");
        dbIdNameMap.put(new Integer(70), "SYBASE");
        dbIdNameMap.put(new Integer(15), "JDBCDB");
        SUPPORTED_LITERAL_JDBC_TYPES.add("char");
        SUPPORTED_LITERAL_JDBC_TYPES.add("integer");
        SUPPORTED_LITERAL_JDBC_TYPES.add("numeric");
        SUPPORTED_LITERAL_JDBC_TYPES.add("timestamp");
        SUPPORTED_LITERAL_JDBC_TYPES.add("varchar");
        Collections.sort(SUPPORTED_LITERAL_JDBC_TYPES);
        SUPPORTED_CAST_JDBC_TYPES.add("bigint");
        SUPPORTED_CAST_JDBC_TYPES.add("bit");
        SUPPORTED_CAST_JDBC_TYPES.add("char");
        SUPPORTED_CAST_JDBC_TYPES.add("date");
        SUPPORTED_CAST_JDBC_TYPES.add("double");
        SUPPORTED_CAST_JDBC_TYPES.add("decimal");
        SUPPORTED_CAST_JDBC_TYPES.add("float");
        SUPPORTED_CAST_JDBC_TYPES.add("integer");
        SUPPORTED_CAST_JDBC_TYPES.add("numeric");
        SUPPORTED_CAST_JDBC_TYPES.add("real");
        SUPPORTED_CAST_JDBC_TYPES.add("smallint");
        SUPPORTED_CAST_JDBC_TYPES.add("time");
        SUPPORTED_CAST_JDBC_TYPES.add("timestamp");
        SUPPORTED_CAST_JDBC_TYPES.add("tinyint");
        SUPPORTED_CAST_JDBC_TYPES.add("longvarchar");
        SUPPORTED_CAST_JDBC_TYPES.add("varchar");
        SUPPORTED_CAST_JDBC_TYPES.add("binary");
        SUPPORTED_CAST_JDBC_TYPES.add("varbinary");
        SUPPORTED_CAST_JDBC_TYPES.add("longvarbinary");
        Collections.sort(SUPPORTED_CAST_JDBC_TYPES);
        SUPPORTED_INTERVAL_TYPES.add("second");
        SUPPORTED_INTERVAL_TYPES.add("minute");
        SUPPORTED_INTERVAL_TYPES.add("hour");
        SUPPORTED_INTERVAL_TYPES.add("day");
        SUPPORTED_INTERVAL_TYPES.add("week");
        SUPPORTED_INTERVAL_TYPES.add("month");
        SUPPORTED_INTERVAL_TYPES.add("quarter");
        SUPPORTED_INTERVAL_TYPES.add("year");
        Collections.sort(SUPPORTED_INTERVAL_TYPES);
        SUPPORTED_DATE_FORMATS.add("MON DD YYYY HH:MIAM");
        SUPPORTED_DATE_FORMATS.add("MM/DD/YY");
        SUPPORTED_DATE_FORMATS.add("MM/DD/YYYY");
        SUPPORTED_DATE_FORMATS.add("YY.MM.DD");
        SUPPORTED_DATE_FORMATS.add("YYYY.MM.DD");
        SUPPORTED_DATE_FORMATS.add("DD/MM/YY");
        SUPPORTED_DATE_FORMATS.add("DD/MM/YYYY");
        SUPPORTED_DATE_FORMATS.add("DD.MM.YY");
        SUPPORTED_DATE_FORMATS.add("DD.MM.YYYY");
        SUPPORTED_DATE_FORMATS.add("DD-MM-YY");
        SUPPORTED_DATE_FORMATS.add("DD-MM-YYYY");
        SUPPORTED_DATE_FORMATS.add("DD MON YY");
        SUPPORTED_DATE_FORMATS.add("DD MON YYYY");
        SUPPORTED_DATE_FORMATS.add("MON DD, YY");
        SUPPORTED_DATE_FORMATS.add("MON DD, YYYY");
        SUPPORTED_DATE_FORMATS.add("HH:MI:SS");
        SUPPORTED_DATE_FORMATS.add("MM-DD-YY");
        SUPPORTED_DATE_FORMATS.add("MM-DD-YYYY");
        SUPPORTED_DATE_FORMATS.add("YY/MM/DD");
        SUPPORTED_DATE_FORMATS.add("YYYY/MM/DD");
        SUPPORTED_DATE_FORMATS.add("YYMMDD");
        SUPPORTED_DATE_FORMATS.add("YYYYMMDD");
        SUPPORTED_DATE_FORMATS.add("DD MON YYYY HH24:MI:SS.FF");
        SUPPORTED_DATE_FORMATS.add("HH24:MI:SS:FF");
        SUPPORTED_DATE_FORMATS.add("DD MON YYYY HH24:MI:SS");
        SUPPORTED_DATE_FORMATS.add("HH24:MI:SS");
        SUPPORTED_DATE_FORMATS.add("YYYY-MM-DD HH24:MI:SS.FF");
        SUPPORTED_DATE_FORMATS.add("YYYY-MM-DDTHH24:MI:SS");
        SUPPORTED_DATE_FORMATS.add("YYYYMMDDTHH24MISS");
        SUPPORTED_DATE_FORMATS.add("DD MON YYYY HH:MI:SS.FFFAM");
        SUPPORTED_DATE_FORMATS.add("DD/MM/YYYY HH:MI:SS.FFFAM");
        Collections.sort(SUPPORTED_DATE_FORMATS);
        SUPPORTED_DATE_PARTS.add("WEEKDAY");
        SUPPORTED_DATE_PARTS.add("WEEKDAY3");
        SUPPORTED_DATE_PARTS.add("WEEKDAYFULL");
        SUPPORTED_DATE_PARTS.add("DAY");
        SUPPORTED_DATE_PARTS.add("MONTH");
        SUPPORTED_DATE_PARTS.add("MONTH3");
        SUPPORTED_DATE_PARTS.add("MONTHFULL");
        SUPPORTED_DATE_PARTS.add("YEAR");
        SUPPORTED_DATE_PARTS.add("HOUR");
        SUPPORTED_DATE_PARTS.add("HOUR12");
        SUPPORTED_DATE_PARTS.add("HOUR24");
        SUPPORTED_DATE_PARTS.add("MINUTE");
        SUPPORTED_DATE_PARTS.add("SECOND");
        SUPPORTED_DATE_PARTS.add("WEEK");
        SUPPORTED_DATE_PARTS.add("QUARTER");
        SUPPORTED_DATE_PARTS.add("MILLISECOND");
        SUPPORTED_DATE_PARTS.add("AMPM");
        SQL_JDBC_MAP.put("array", String.valueOf(2003));
        SQL_JDBC_MAP.put("bigint", String.valueOf(-5));
        SQL_JDBC_MAP.put("binary", String.valueOf(-2));
        SQL_JDBC_MAP.put("boolean", String.valueOf(16));
        SQL_JDBC_MAP.put("bit", String.valueOf(-7));
        SQL_JDBC_MAP.put("blob", String.valueOf(2004));
        SQL_JDBC_MAP.put("char", String.valueOf(1));
        SQL_JDBC_MAP.put("clob", String.valueOf(2005));
        SQL_JDBC_MAP.put("date", String.valueOf(91));
        SQL_JDBC_MAP.put("decimal", String.valueOf(3));
        SQL_JDBC_MAP.put("distinct", String.valueOf(2001));
        SQL_JDBC_MAP.put("double", String.valueOf(8));
        SQL_JDBC_MAP.put("float", String.valueOf(6));
        SQL_JDBC_MAP.put("integer", String.valueOf(4));
        SQL_JDBC_MAP.put("longvarbinary", String.valueOf(-4));
        SQL_JDBC_MAP.put("longvarchar", String.valueOf(-1));
        SQL_JDBC_MAP.put("numeric", String.valueOf(2));
        SQL_JDBC_MAP.put("real", String.valueOf(7));
        SQL_JDBC_MAP.put("smallint", String.valueOf(5));
        SQL_JDBC_MAP.put("time", String.valueOf(92));
        SQL_JDBC_MAP.put("timestamp", String.valueOf(93));
        SQL_JDBC_MAP.put("tinyint", String.valueOf(-6));
        SQL_JDBC_MAP.put("varbinary", String.valueOf(-3));
        SQL_JDBC_MAP.put("varchar", String.valueOf(12));
        SQL_JDBC_MAP.put("null", String.valueOf(0));
        SQL_JDBC_MAP.put(VARCHAR_UNQUOTED_STR, String.valueOf(3345336));
        SQL_JDBC_MAP.put("anytype", String.valueOf(3345335));
        JDBC_SQL_MAP.put(String.valueOf(2003), "array");
        JDBC_SQL_MAP.put(String.valueOf(-5), "bigint");
        JDBC_SQL_MAP.put(String.valueOf(-2), "binary");
        JDBC_SQL_MAP.put(String.valueOf(-7), "bit");
        JDBC_SQL_MAP.put(String.valueOf(2004), "blob");
        JDBC_SQL_MAP.put(String.valueOf(16), "boolean");
        JDBC_SQL_MAP.put(String.valueOf(1), "char");
        JDBC_SQL_MAP.put(String.valueOf(2005), "clob");
        JDBC_SQL_MAP.put(String.valueOf(91), "date");
        JDBC_SQL_MAP.put(String.valueOf(3), "decimal");
        JDBC_SQL_MAP.put(String.valueOf(2001), "distinct");
        JDBC_SQL_MAP.put(String.valueOf(8), "double");
        JDBC_SQL_MAP.put(String.valueOf(6), "float");
        JDBC_SQL_MAP.put(String.valueOf(4), "integer");
        JDBC_SQL_MAP.put(String.valueOf(-4), "longvarbinary");
        JDBC_SQL_MAP.put(String.valueOf(-1), "longvarchar");
        JDBC_SQL_MAP.put(String.valueOf(2), "numeric");
        JDBC_SQL_MAP.put(String.valueOf(7), "real");
        JDBC_SQL_MAP.put(String.valueOf(5), "smallint");
        JDBC_SQL_MAP.put(String.valueOf(92), "time");
        JDBC_SQL_MAP.put(String.valueOf(93), "timestamp");
        JDBC_SQL_MAP.put(String.valueOf(-6), "tinyint");
        JDBC_SQL_MAP.put(String.valueOf(-3), "varbinary");
        JDBC_SQL_MAP.put(String.valueOf(12), "varchar");
        JDBC_SQL_MAP.put(String.valueOf(0), "null");
        JDBC_SQL_MAP.put(String.valueOf(3345336), VARCHAR_UNQUOTED_STR);
        JDBC_SQL_MAP.put(String.valueOf(3345335), "anytype");
        dataTypePrecedenceMap.put(new Integer(8), new Integer(1));
        dataTypePrecedenceMap.put(new Integer(6), new Integer(2));
        dataTypePrecedenceMap.put(new Integer(7), new Integer(3));
        dataTypePrecedenceMap.put(new Integer(2), new Integer(4));
        dataTypePrecedenceMap.put(new Integer(3), new Integer(5));
        dataTypePrecedenceMap.put(new Integer(-5), new Integer(6));
        dataTypePrecedenceMap.put(new Integer(4), new Integer(7));
        dataTypePrecedenceMap.put(new Integer(5), new Integer(8));
        dataTypePrecedenceMap.put(new Integer(-6), new Integer(9));
        dataTypePrecedenceMap.put(new Integer(-7), new Integer(10));
        dataTypePrecedenceMap.put(new Integer(93), new Integer(11));
        dataTypePrecedenceMap.put(new Integer(2005), new Integer(12));
        dataTypePrecedenceMap.put(new Integer(12), new Integer(13));
        dataTypePrecedenceMap.put(new Integer(1), new Integer(14));
        dataTypePrecedenceMap.put(new Integer(-3), new Integer(15));
        dataTypePrecedenceMap.put(new Integer(-2), new Integer(16));
    }
}

