/*
 * Decompiled with CFR 0.152.
 */
package com.sun.etl.engine.impl;

import com.sun.etl.engine.ETLEngineContext;
import com.sun.etl.engine.ETLTaskNode;
import com.sun.etl.engine.impl.SimpleTask;
import com.sun.etl.engine.utils.ETLException;
import com.sun.etl.engine.utils.MessageManager;
import com.sun.sql.framework.jdbc.DBConnectionFactory;
import com.sun.sql.framework.jdbc.SQLPart;
import com.sun.sql.framework.utils.Logger;
import com.sun.sql.framework.utils.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;

public class UpdateStatisticsTask
extends SimpleTask {
    private static final String LOG_CATEGORY = UpdateStatisticsTask.class.getName();
    private static final int MAX_EXCEPTION_MESSAGE_LENGTH = 2000;
    private static final MessageManager MSG_MGR = MessageManager.getManager("com.sun.etl.engine.impl");

    public void cleanUp() {
        super.cleanUp();
    }

    public void handleException(ETLException ex) {
        Logger.printThrowable(10000, LOG_CATEGORY, "UpdateStatisticsTask", "Handling exception for UpdateStatistics....", ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String process(ETLTaskNode node) throws ETLException {
        if (node == null) {
            throw new ETLException("UpdateStatistics task node is null....");
        }
        if (!StringUtil.isNullString(node.getDisplayName())) {
            this.DN = this.DN + " <" + node.getDisplayName().trim() + ">";
        }
        String msg = MSG_MGR.getString("MSG_updatestats_started");
        Logger.print(10000, LOG_CATEGORY, this.DN + msg);
        node.fireETLEngineLogEvent(msg);
        ETLEngineContext context = node.getContext();
        ETLEngineContext.CollabStatistics collabStats = context.getStatistics();
        List connList = node.getParent().getConnectionDefList();
        Connection conn = null;
        PreparedStatement stmt = null;
        Class<UpdateStatisticsTask> clazz = UpdateStatisticsTask.class;
        synchronized (UpdateStatisticsTask.class) {
            try {
                for (String tableName : node.getTableNamesWithSpecificStatements()) {
                    SQLPart updateEndDatePart = node.getTableSpecificStatement(tableName, "updateExecutionRecordStatement");
                    if (updateEndDatePart == null) continue;
                    String poolName = updateEndDatePart.getConnectionPoolName();
                    String updateStmt = updateEndDatePart.getSQL();
                    conn = this.getConnection(poolName, connList);
                    conn.setAutoCommit(true);
                    super.computeRowCountStatistics(node, tableName, conn);
                    stmt = conn.prepareStatement(updateStmt);
                    Timestamp startTs = collabStats.getTableStartTime(tableName);
                    Timestamp finishTs = collabStats.getTableFinishTime(tableName);
                    long extractedCt = collabStats.getRowsExtractedCount(tableName);
                    long insertedCt = collabStats.getRowsInsertedCount(tableName);
                    long rejectedCt = collabStats.getRowsRejectedCount(tableName);
                    String exceptionMessage = this.getExceptionMessage(context.getThrowableList());
                    stmt.setTimestamp(1, finishTs);
                    stmt.setLong(2, extractedCt);
                    stmt.setLong(3, insertedCt);
                    stmt.setLong(4, rejectedCt);
                    stmt.setString(5, exceptionMessage);
                    stmt.setTimestamp(6, startTs);
                    stmt.executeUpdate();
                    stmt.close();
                    DBConnectionFactory.getInstance().closeConnection(conn);
                    conn = null;
                    msg = MSG_MGR.getString("MSG_updatestats_wroteStats", tableName, new Long(extractedCt), new Long(insertedCt), new Long(rejectedCt));
                    Logger.print(20000, LOG_CATEGORY, this.DN + msg);
                }
                stmt = null;
                conn = null;
            }
            catch (Exception t) {
                t = (Exception)this.unwrapThrowable(t);
                msg = t.getMessage();
                if (StringUtil.isNullString(msg) && StringUtil.isNullString(msg = t.toString())) {
                    msg = MSG_MGR.getString("MSG_common_no_details_available");
                }
                String failureMsg = MSG_MGR.getString("MSG_updatestats_insert_failure", msg);
                Logger.print(10000, LOG_CATEGORY, (Object)failureMsg, t);
                node.fireETLEngineLogEvent(failureMsg);
                throw new ETLException(failureMsg, t);
            }
            finally {
                this.closeStatement(stmt);
                DBConnectionFactory.getInstance().closeConnection(conn);
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            String doneMsg = MSG_MGR.getString("MSG_updatestats_finished");
            Logger.print(10000, LOG_CATEGORY, doneMsg);
            node.fireETLEngineLogEvent(doneMsg);
            return "Success";
        }
    }

    private String getExceptionMessage(List throwableList) {
        StringBuffer sb = null;
        String exceptionMessage = null;
        if (throwableList != null && throwableList.size() > 0) {
            Iterator itr = throwableList.iterator();
            Throwable ex = null;
            sb = new StringBuffer();
            int i = 0;
            while (itr.hasNext()) {
                try {
                    if (i++ > 0) {
                        sb.append("\n");
                    }
                    ex = (Throwable)itr.next();
                    sb.append(ex.getMessage());
                }
                catch (ClassCastException exp) {
                    Logger.printThrowable(10000, LOG_CATEGORY, "UpdateStatisticsTask", "Caught ClassCastException while constructing exception message.", exp);
                }
            }
            exceptionMessage = sb.length() > 2000 ? sb.substring(0, 2000) : sb.toString();
        }
        return exceptionMessage;
    }
}

