/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp;

import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpStatusException;

public class SnmpIpAddress
extends SnmpOid {
    private static final long serialVersionUID = -844289641772067624L;
    static final String name = "IpAddress";

    public SnmpIpAddress(byte[] byArray) throws IllegalArgumentException {
        this.buildFromByteArray(byArray);
    }

    public SnmpIpAddress(long l) {
        int n = (int)l;
        byte[] byArray = new byte[]{(byte)(n >>> 24 & 0xFF), (byte)(n >>> 16 & 0xFF), (byte)(n >>> 8 & 0xFF), (byte)(n & 0xFF)};
        this.buildFromByteArray(byArray);
    }

    public SnmpIpAddress(String string) throws IllegalArgumentException {
        super(string);
        if (this.componentCount > 4 || this.components[0] > 255L || this.components[1] > 255L || this.components[2] > 255L || this.components[3] > 255L) {
            throw new IllegalArgumentException(string);
        }
    }

    public SnmpIpAddress(long l, long l2, long l3, long l4) {
        super(l, l2, l3, l4);
        if (this.components[0] > 255L || this.components[1] > 255L || this.components[2] > 255L || this.components[3] > 255L) {
            throw new IllegalArgumentException();
        }
    }

    public byte[] byteValue() {
        byte[] byArray = new byte[]{(byte)this.components[0], (byte)this.components[1], (byte)this.components[2], (byte)this.components[3]};
        return byArray;
    }

    public String stringValue() {
        return this.toString();
    }

    public static SnmpOid toOid(long[] lArray, int n) throws SnmpStatusException {
        if (n + 4 <= lArray.length) {
            try {
                return new SnmpOid(lArray[n], lArray[n + 1], lArray[n + 2], lArray[n + 3]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new SnmpStatusException(2);
            }
        }
        throw new SnmpStatusException(2);
    }

    public static int nextOid(long[] lArray, int n) throws SnmpStatusException {
        if (n + 4 <= lArray.length) {
            return n + 4;
        }
        throw new SnmpStatusException(2);
    }

    public static void appendToOid(SnmpOid snmpOid, SnmpOid snmpOid2) {
        if (snmpOid.getLength() != 4) {
            throw new IllegalArgumentException();
        }
        snmpOid2.append(snmpOid);
    }

    public final String getTypeName() {
        return name;
    }

    private void buildFromByteArray(byte[] byArray) {
        if (byArray.length != 4) {
            throw new IllegalArgumentException();
        }
        this.components = new long[4];
        this.componentCount = 4;
        this.components[0] = byArray[0] >= 0 ? (long)byArray[0] : (long)(byArray[0] + 256);
        this.components[1] = byArray[1] >= 0 ? (long)byArray[1] : (long)(byArray[1] + 256);
        this.components[2] = byArray[2] >= 0 ? (long)byArray[2] : (long)(byArray[2] + 256);
        this.components[3] = byArray[3] >= 0 ? (long)byArray[3] : (long)(byArray[3] + 256);
    }
}

