/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp;

public class BerEncoder {
    public static final int BooleanTag = 1;
    public static final int IntegerTag = 2;
    public static final int OctetStringTag = 4;
    public static final int NullTag = 5;
    public static final int OidTag = 6;
    public static final int SequenceTag = 48;
    protected final byte[] bytes;
    protected int start = -1;
    protected final int[] stackBuf = new int[200];
    protected int stackTop = 0;

    public BerEncoder(byte[] byArray) {
        this.bytes = byArray;
        this.start = byArray.length;
        this.stackTop = 0;
    }

    public int trim() {
        int n = this.bytes.length - this.start;
        if (n > 0) {
            System.arraycopy(this.bytes, this.start, this.bytes, 0, n);
        }
        this.start = this.bytes.length;
        this.stackTop = 0;
        return n;
    }

    public void putInteger(int n) {
        this.putInteger(n, 2);
    }

    public void putInteger(int n, int n2) {
        this.putIntegerValue(n);
        this.putTag(n2);
    }

    public void putInteger(long l) {
        this.putInteger(l, 2);
    }

    public void putInteger(long l, int n) {
        this.putIntegerValue(l);
        this.putTag(n);
    }

    public void putOctetString(byte[] byArray) {
        this.putOctetString(byArray, 4);
    }

    public void putOctetString(byte[] byArray, int n) {
        this.putStringValue(byArray);
        this.putTag(n);
    }

    public void putOid(long[] lArray) {
        this.putOid(lArray, 6);
    }

    public void putOid(long[] lArray, int n) {
        this.putOidValue(lArray);
        this.putTag(n);
    }

    public void putNull() {
        this.putNull(5);
    }

    public void putNull(int n) {
        this.putLength(0);
        this.putTag(n);
    }

    public void putAny(byte[] byArray) {
        this.putAny(byArray, byArray.length);
    }

    public void putAny(byte[] byArray, int n) {
        System.arraycopy(byArray, 0, this.bytes, this.start - n, n);
        this.start -= n;
    }

    public void putUnsignedLong(long l, int n) {
        this.putUnsignedLongValue(l);
        this.putTag(n);
    }

    public void openSequence() {
        this.stackBuf[this.stackTop++] = this.start;
    }

    public void closeSequence() {
        this.closeSequence(48);
    }

    public void closeSequence(int n) {
        int n2 = this.stackBuf[--this.stackTop];
        this.putLength(n2 - this.start);
        this.putTag(n);
    }

    protected final void putTag(int n) {
        if (n < 256) {
            this.bytes[--this.start] = (byte)n;
        } else {
            while (n != 0) {
                this.bytes[--this.start] = (byte)(n & 0x7F);
                n <<= 7;
            }
        }
    }

    protected final void putLength(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n < 128) {
            this.bytes[--this.start] = (byte)n;
        } else if (n < 256) {
            this.bytes[--this.start] = (byte)n;
            this.bytes[--this.start] = -127;
        } else if (n < 65536) {
            this.bytes[--this.start] = (byte)n;
            this.bytes[--this.start] = (byte)(n >> 8);
            this.bytes[--this.start] = -126;
        } else if (n < 0xFFFFA6) {
            this.bytes[--this.start] = (byte)n;
            this.bytes[--this.start] = (byte)(n >> 8);
            this.bytes[--this.start] = (byte)(n >> 16);
            this.bytes[--this.start] = -125;
        } else {
            this.bytes[--this.start] = (byte)n;
            this.bytes[--this.start] = (byte)(n >> 8);
            this.bytes[--this.start] = (byte)(n >> 16);
            this.bytes[--this.start] = (byte)(n >> 24);
            this.bytes[--this.start] = -124;
        }
    }

    protected final void putIntegerValue(int n) {
        int n2;
        int n3 = this.start;
        int n4 = 2139095040;
        if (n < 0) {
            for (n2 = 4; (n4 & n) == n4 && n2 > 1; n4 >>= 8, --n2) {
            }
        } else {
            while ((n4 & n) == 0 && n2 > 1) {
                n4 >>= 8;
                --n2;
            }
        }
        for (int i = 0; i < n2; ++i) {
            this.bytes[--this.start] = (byte)n;
            n >>= 8;
        }
        this.putLength(n3 - this.start);
    }

    protected final void putIntegerValue(long l) {
        int n;
        int n2 = this.start;
        long l2 = 9187343239835811840L;
        if (l < 0L) {
            for (n = 8; (l2 & l) == l2 && n > 1; l2 >>= 8, --n) {
            }
        } else {
            while ((l2 & l) == 0L && n > 1) {
                l2 >>= 8;
                --n;
            }
        }
        for (int i = 0; i < n; ++i) {
            this.bytes[--this.start] = (byte)l;
            l >>= 8;
        }
        this.putLength(n2 - this.start);
    }

    protected void putUnsignedLongValue(long l) {
        int n = this.start;
        long l2 = 9187343239835811840L;
        if (l < 0L) {
            int n2 = 9;
            for (int i = 0; i < n2; ++i) {
                this.bytes[--this.start] = (byte)l;
                l >>= 8;
            }
        } else {
            int n3;
            for (n3 = 8; (l2 & l) == 0L && n3 > 1; --n3) {
                l2 >>= 8;
            }
            for (int i = 0; i < n3; ++i) {
                this.bytes[--this.start] = (byte)l;
                l >>= 8;
            }
        }
        this.putLength(n - this.start);
    }

    protected final void putStringValue(byte[] byArray) {
        int n = byArray.length;
        System.arraycopy(byArray, 0, this.bytes, this.start - n, n);
        this.start -= n;
        this.putLength(n);
    }

    protected final void putOidValue(long[] lArray) {
        int n = this.start;
        int n2 = lArray.length;
        if (n2 < 2 || lArray[0] > 2L || lArray[1] >= 40L) {
            throw new IllegalArgumentException();
        }
        for (int i = n2 - 1; i >= 2; --i) {
            long l = lArray[i];
            if (l < 0L) {
                throw new IllegalArgumentException();
            }
            if (l < 128L) {
                this.bytes[--this.start] = (byte)l;
                continue;
            }
            this.bytes[--this.start] = (byte)(l & 0x7FL);
            l >>= 7;
            while (l != 0L) {
                this.bytes[--this.start] = (byte)(l | 0x80L);
                l >>= 7;
            }
        }
        this.bytes[--this.start] = (byte)(lArray[0] * 40L + lArray[1]);
        this.putLength(n - this.start);
    }
}

