/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.comm;

import com.sun.jdmk.ThreadContext;
import com.sun.management.comm.SnmpMibTree;
import com.sun.management.comm.SnmpSubRequestHandler;
import com.sun.management.internal.snmp.SnmpIncomingRequest;
import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpPdu;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpValue;
import com.sun.management.snmp.SnmpVarBind;
import com.sun.management.snmp.agent.SnmpMibAgent;

class SnmpSubNextRequestHandler
extends SnmpSubRequestHandler {
    private SnmpMibTree root = null;

    protected SnmpSubNextRequestHandler(SnmpMibAgent snmpMibAgent, SnmpPdu snmpPdu, SnmpMibTree snmpMibTree) {
        super(snmpMibAgent, snmpPdu);
        this.init(snmpPdu, snmpMibTree);
    }

    protected SnmpSubNextRequestHandler(SnmpEngine snmpEngine, SnmpIncomingRequest snmpIncomingRequest, SnmpMibAgent snmpMibAgent, SnmpPdu snmpPdu, SnmpMibTree snmpMibTree) {
        super(snmpEngine, snmpIncomingRequest, snmpMibAgent, snmpPdu);
        this.init(snmpPdu, snmpMibTree);
        if (this.logger.finestOn()) {
            this.logger.finest("SnmpSubNextRequestHandler", "Constructor :" + this);
        }
    }

    private void init(SnmpPdu snmpPdu, SnmpMibTree snmpMibTree) {
        this.root = snmpMibTree;
        int n = this.translation.length;
        SnmpVarBind[] snmpVarBindArray = snmpPdu.varBindList;
        SnmpSubRequestHandler.NonSyncVector nonSyncVector = (SnmpSubRequestHandler.NonSyncVector)this.varBind;
        for (int i = 0; i < n; ++i) {
            this.translation[i] = i;
            SnmpVarBind snmpVarBind = new SnmpVarBind(snmpVarBindArray[i].getOid(), snmpVarBindArray[i].getSnmpValue());
            nonSyncVector.addNonSyncElement(snmpVarBind);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block10: {
            try {
                ThreadContext threadContext = ThreadContext.push("SnmpUserData", this.data);
                try {
                    if (this.logger.finerOn()) {
                        this.logger.finer("run", "[" + Thread.currentThread() + "]:getNext operation on " + this.agent.getMibName());
                    }
                    this.agent.getNext(this.createMibRequest(this.varBind, 1, this.data));
                }
                finally {
                    ThreadContext.restore(threadContext);
                }
            }
            catch (SnmpStatusException snmpStatusException) {
                this.errorStatus = snmpStatusException.getStatus();
                this.errorIndex = snmpStatusException.getErrorIndex();
                if (this.logger.finestOn()) {
                    this.logger.finest("run", "[" + Thread.currentThread() + "]:a Snmp error occured during the operation");
                    this.logger.finest("run", snmpStatusException);
                }
            }
            catch (Exception exception) {
                this.errorStatus = 5;
                if (this.logger.finestOn()) {
                    this.logger.finest("run", "[" + Thread.currentThread() + "]: Unexpected exception: " + exception);
                    this.logger.finest("run", exception);
                }
                if (!this.logger.finerOn()) break block10;
                this.logger.finer("run", "[" + Thread.currentThread() + "]:a generic error occured during the operation");
            }
        }
        if (this.logger.finerOn()) {
            this.logger.finer("run", "[" + Thread.currentThread() + "]:operation completed");
        }
    }

    protected void updateRequest(SnmpVarBind snmpVarBind, int n) {
        if (this.logger.finestOn()) {
            this.logger.finest("updateRequest", "Copy :" + snmpVarBind);
        }
        int n2 = this.varBind.size();
        this.translation[n2] = n;
        SnmpVarBind snmpVarBind2 = new SnmpVarBind(snmpVarBind.getOid(), snmpVarBind.getSnmpValue());
        if (this.logger.finestOn()) {
            this.logger.finest("updateRequest", "Copied :" + snmpVarBind2);
        }
        this.varBind.addElement(snmpVarBind2);
    }

    protected void updateResult(SnmpVarBind[] snmpVarBindArray) {
        int n = this.varBind.size();
        for (int i = 0; i < n; ++i) {
            int n2 = this.translation[i];
            SnmpVarBind snmpVarBind = (SnmpVarBind)((SnmpSubRequestHandler.NonSyncVector)this.varBind).elementAtNonSync(i);
            SnmpVarBind snmpVarBind2 = snmpVarBindArray[n2];
            if (snmpVarBind2 == null) {
                snmpVarBindArray[n2] = snmpVarBind;
                continue;
            }
            SnmpValue snmpValue = snmpVarBind2.getSnmpValue();
            if (snmpValue == null || snmpValue == SnmpVarBind.endOfMibView) {
                if (snmpVarBind == null || snmpVarBind.getSnmpValue() == SnmpVarBind.endOfMibView) continue;
                snmpVarBindArray[n2] = snmpVarBind;
                continue;
            }
            if (snmpVarBind == null || snmpVarBind.getSnmpValue() == SnmpVarBind.endOfMibView) continue;
            int n3 = snmpVarBind.getOid().compareTo(snmpVarBind2.getOid());
            if (n3 < 0) {
                snmpVarBindArray[n2] = snmpVarBind;
                continue;
            }
            if (n3 != 0) continue;
            if (this.logger.finestOn()) {
                this.logger.finer("updateResult", " oid overlapping. Oid : " + snmpVarBind.getOid() + "value :" + snmpVarBind.getSnmpValue());
                this.logger.finer("updateResult", "Already present varBind : " + snmpVarBind2);
            }
            SnmpOid snmpOid = snmpVarBind2.getOid();
            SnmpMibAgent snmpMibAgent = this.root.getAgentMib(snmpOid);
            if (this.logger.finestOn()) {
                this.logger.finer("updateResult", "Deeper agent : " + snmpMibAgent);
            }
            if (snmpMibAgent != this.agent) continue;
            if (this.logger.finestOn()) {
                this.logger.finer("updateResult", "The current agent is the deeper one. Update the value with the current one");
            }
            snmpVarBindArray[n2].setSnmpValue(snmpVarBind.getSnmpValue());
        }
    }

    protected String makeDebugTag() {
        return "SnmpSubNextRequestHandler";
    }
}

