/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.security.sasl.plain;

import com.sun.jdmk.security.sasl.AuthenticateCallback;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthenticationException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;

final class PlainServer
implements SaslServer {
    private boolean completed;
    private CallbackHandler cbh;
    private String authorizationID;
    private static final byte SEPARATOR = 0;

    public PlainServer(CallbackHandler callbackHandler) {
        this.cbh = callbackHandler;
    }

    public String getMechanismName() {
        return "PLAIN";
    }

    public byte[] evaluateResponse(byte[] byArray) throws SaslException {
        String string;
        String string2;
        String string3;
        int n;
        if (this.completed) {
            throw new IllegalStateException("PLAIN authentication already completed");
        }
        this.completed = true;
        int n2 = -1;
        int n3 = -1;
        for (n = 0; n < byArray.length; ++n) {
            if (byArray[n] != 0) continue;
            if (n2 == -1) {
                n2 = n;
                continue;
            }
            if (n3 != -1) continue;
            n3 = n;
        }
        if (n2 < 0 || n3 < 0 || n2 + 1 == n3 || n3 + 1 == byArray.length) {
            throw new IllegalStateException("PLAIN authentication error: Response format should be: [authorization_id]<US-ASCII NUL>authentication_id<US-ASCII NUL>password.");
        }
        n = n2;
        int n4 = n3 - n2 - 1;
        int n5 = byArray.length - n3 - 1;
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n4];
        byte[] byArray4 = new byte[n5];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        System.arraycopy(byArray, n2 + 1, byArray3, 0, n4);
        System.arraycopy(byArray, n3 + 1, byArray4, 0, n5);
        try {
            string3 = new String(byArray3, "UTF-8");
            string2 = new String(byArray4, "UTF-8");
            for (int i = 0; i < byArray4.length; ++i) {
                byArray4[i] = 0;
            }
            byArray4 = null;
            string = byArray2.length == 0 ? string3 : new String(byArray2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SaslException("PLAIN: Cannot get UTF-8 encoding of ids", unsupportedEncodingException);
        }
        this.verifyAuthenticationCredentials(string3, string2);
        this.verifyAuthorizationID(string3, string);
        return null;
    }

    public String getAuthorizationID() {
        return this.authorizationID;
    }

    public boolean isComplete() {
        return this.completed;
    }

    public byte[] unwrap(byte[] byArray, int n, int n2) throws SaslException {
        if (this.completed) {
            throw new SaslException("PLAIN supports neither integrity nor privacy");
        }
        throw new IllegalStateException("PLAIN authentication not completed");
    }

    public byte[] wrap(byte[] byArray, int n, int n2) throws SaslException {
        if (this.completed) {
            throw new SaslException("PLAIN supports neither integrity nor privacy");
        }
        throw new IllegalStateException("PLAIN authentication not completed");
    }

    public Object getNegotiatedProperty(String string) {
        if (this.completed) {
            if (string.equals("javax.security.sasl.qop")) {
                return "auth";
            }
            return null;
        }
        throw new IllegalStateException("PLAIN authentication not completed");
    }

    public void dispose() throws SaslException {
    }

    private void verifyAuthenticationCredentials(String string, String string2) throws SaslException {
        char[] cArray = string2.toCharArray();
        AuthenticateCallback authenticateCallback = new AuthenticateCallback(string, cArray);
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = 32;
        }
        cArray = null;
        try {
            this.cbh.handle(new Callback[]{authenticateCallback});
        }
        catch (IOException iOException) {
            throw new SaslException("PLAIN: Authentication credentials verification failed!", iOException);
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new SaslException("PLAIN: Authentication credentials verification failed!", unsupportedCallbackException);
        }
        authenticateCallback.clearPassword();
        if (!authenticateCallback.isAuthenticated()) {
            throw new AuthenticationException("PLAIN: Authentication credentials verification failed!");
        }
    }

    private void verifyAuthorizationID(String string, String string2) throws SaslException {
        AuthorizeCallback authorizeCallback = new AuthorizeCallback(string, string2);
        try {
            this.cbh.handle(new Callback[]{authorizeCallback});
        }
        catch (IOException iOException) {
            throw new SaslException("PLAIN: AuthorizationID verification failed!", iOException);
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new SaslException("PLAIN: AuthorizationID verification failed!", unsupportedCallbackException);
        }
        if (!authorizeCallback.isAuthorized()) {
            throw new SaslException("PLAIN: " + string + " is not authorized to act as " + string2);
        }
        this.authorizationID = authorizeCallback.getAuthorizedID();
    }
}

