/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.internal;

import com.sun.jdmk.tasks.Task;
import com.sun.jdmk.tasks.TaskServer;
import java.util.ArrayList;

public class ThreadService
implements TaskServer {
    private ArrayList jobList = new ArrayList(0);
    private ExecutorThread[] threadList;
    private int minThreads = 1;
    private int currThreds = 0;
    private int idle = 0;
    private boolean terminated = false;
    private int priority;
    private ThreadGroup threadGroup = new ThreadGroup("ThreadService");
    private ClassLoader cloader;
    private static long counter = 0L;
    private int addedJobs = 1;
    private int doneJobs = 1;

    public ThreadService(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The thread number should bigger than zero.");
        }
        this.minThreads = n;
        this.threadList = new ExecutorThread[n];
        this.priority = Thread.currentThread().getPriority();
        this.cloader = Thread.currentThread().getContextClassLoader();
    }

    public void submitTask(Task task) throws IllegalArgumentException {
        this.submitTask((Runnable)task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitTask(Runnable runnable) throws IllegalArgumentException {
        this.stateCheck();
        if (runnable == null) {
            throw new IllegalArgumentException("No task specified.");
        }
        ArrayList arrayList = this.jobList;
        synchronized (arrayList) {
            this.jobList.add(this.jobList.size(), runnable);
            this.jobList.notify();
        }
        this.createThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable removeTask(Runnable runnable) {
        this.stateCheck();
        Runnable runnable2 = null;
        ArrayList arrayList = this.jobList;
        synchronized (arrayList) {
            int n = this.jobList.indexOf(runnable);
            if (n >= 0) {
                runnable2 = (Runnable)this.jobList.remove(n);
            }
        }
        if (runnable2 != null && runnable2 instanceof Task) {
            ((Task)runnable2).cancel();
        }
        return runnable2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Object[] objectArray;
        this.stateCheck();
        ArrayList arrayList = this.jobList;
        synchronized (arrayList) {
            objectArray = this.jobList.toArray();
            this.jobList.clear();
        }
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            if (object == null || !(object instanceof Task)) continue;
            ((Task)object).cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        if (this.terminated) {
            return;
        }
        this.terminated = true;
        ArrayList arrayList = this.jobList;
        synchronized (arrayList) {
            this.jobList.notifyAll();
        }
        this.removeAll();
        for (int i = 0; i < this.currThreds; ++i) {
            try {
                this.threadList[i].interrupt();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.threadList = null;
    }

    private void stateCheck() throws IllegalStateException {
        if (this.terminated) {
            throw new IllegalStateException("The thread service has been terminated.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createThread() {
        if (this.idle >= 1) return;
        ExecutorThread[] executorThreadArray = this.threadList;
        synchronized (this.threadList) {
            if (this.jobList.size() <= 0 || this.currThreds >= this.minThreads) return;
            ExecutorThread executorThread = new ExecutorThread();
            executorThread.start();
            this.threadList[this.currThreds++] = executorThread;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private class ExecutorThread
    extends Thread {
        public ExecutorThread() {
            super(ThreadService.this.threadGroup, "ThreadService-" + counter++);
            this.setDaemon(true);
            this.setPriority(ThreadService.this.priority);
            this.setContextClassLoader(ThreadService.this.cloader);
            ThreadService.this.idle++;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!ThreadService.this.terminated) {
                Runnable runnable = null;
                ArrayList arrayList = ThreadService.this.jobList;
                synchronized (arrayList) {
                    if (ThreadService.this.jobList.size() > 0) {
                        runnable = (Runnable)ThreadService.this.jobList.remove(0);
                        if (ThreadService.this.jobList.size() > 0) {
                            ThreadService.this.jobList.notify();
                        }
                    } else {
                        try {
                            ThreadService.this.jobList.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                if (runnable != null) {
                    try {
                        ThreadService.this.idle--;
                        runnable.run();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    finally {
                        ThreadService.this.idle++;
                    }
                }
                this.setPriority(ThreadService.this.priority);
                this.interrupted();
                this.setContextClassLoader(ThreadService.this.cloader);
            }
        }
    }
}

