/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.ClientNotificationHandler;
import com.sun.jdmk.comm.ClientNotificationHandlerInternal;
import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.ConnectorAddress;
import com.sun.jdmk.comm.RemoteNotification;
import com.sun.jdmk.internal.ClassLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;

class ClientNotificationDispatcher
implements ClientNotificationHandler {
    public static final int HANDLE_NOTIFICATION = 0;
    public static final int CONNECTOR_TEST = 1;
    private static final ClassLogger jobLogger = new ClassLogger("com.sun.jdmk.notification", "JobOfGetNotif");
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.notification", "ClientNotificationDispatcher");
    private static int DEFAULT_TIME = 1000;
    private ClientNotificationHandlerInternal connector;
    private ConnectorAddress clientAddress = null;
    private Long remoteID;
    private int forwardPeriod = DEFAULT_TIME;
    private HashMap listenerList = new HashMap();
    private JobOfGetNotif jobOfGet = null;
    private ForwardNotifs forwardNotifs = new ForwardNotifs();
    private int forwardMode = 0;
    private int discardMode = 10;
    private int cacheSize = -1;
    private boolean isConnected = false;

    public ClientNotificationDispatcher(ClientNotificationHandlerInternal clientNotificationHandlerInternal) throws IllegalArgumentException {
        if (clientNotificationHandlerInternal == null) {
            throw new IllegalArgumentException("A connector should be specified.");
        }
        if (logger.finerOn()) {
            logger.finer("Constructor", "Create a new ClientNotificationDispatcher object.");
        }
        this.connector = clientNotificationHandlerInternal;
        this.setMode(0);
    }

    public Long getNotificationClientId() {
        if (this.isConnected) {
            return this.remoteID;
        }
        return null;
    }

    public synchronized void stopListening() {
        this.stopListening(false);
    }

    public synchronized void stopListening(boolean bl) {
        if (logger.finerOn()) {
            logger.finer("stopListening", "This object is stopping listening...");
        }
        this.listenerList.clear();
        try {
            this.disconnect(bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getMode() {
        return this.forwardMode;
    }

    public synchronized void setMode(int n) throws IllegalArgumentException {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("The mode is illegal.");
        }
        if (logger.finerOn()) {
            logger.finer("setMode", "A user asks to set mode to " + n);
        }
        if (this.forwardMode != n) {
            this.forwardMode = n;
            if (this.isConnected) {
                this.internalSetMode(this.forwardMode);
            }
        }
    }

    public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        if (notificationListener == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Null listener"), "Null listener");
        }
        this.connect();
        if (logger.finerOn()) {
            logger.finer("addNotificationListener", "Ask the server to add a listener.");
        }
        Object[] objectArray = null;
        Object[] objectArray2 = new Object[]{this.remoteID, objectName, notificationFilter};
        try {
            objectArray = this.connector.remoteRequest(2, objectArray2);
        }
        catch (RuntimeOperationsException runtimeOperationsException) {
            throw runtimeOperationsException;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (CommunicationException communicationException) {
            throw communicationException;
        }
        catch (JMRuntimeException jMRuntimeException) {
            throw jMRuntimeException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Long l = (Long)objectArray[0];
        this.listenerList.put(l, new ListenerInfo(objectName, notificationListener, notificationFilter, object, l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException {
        if (logger.finerOn()) {
            logger.finer("removeNotificationListener", "Ask the server to remove a listener.");
        }
        if (objectName == null) {
            throw new InstanceNotFoundException("The MBean name doesn't correspond to a registered MBean.");
        }
        ArrayList<ListenerInfo> arrayList = new ArrayList<ListenerInfo>(1);
        Object[] objectArray = this.listenerList;
        synchronized (this.listenerList) {
            block22: {
                ListenerInfo listenerInfo;
                Iterator iterator = this.listenerList.values().iterator();
                while (iterator.hasNext()) {
                    listenerInfo = (ListenerInfo)iterator.next();
                    if (!objectName.equals(listenerInfo.mbean) || notificationListener != listenerInfo.listener) continue;
                    arrayList.add(listenerInfo);
                }
                if (arrayList.size() != 0) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        listenerInfo = (ListenerInfo)arrayList.get(i);
                        this.listenerList.remove(listenerInfo.id);
                    }
                } else {
                    throw new ListenerNotFoundException("Do not know your listener.");
                }
                // ** MonitorExit[var5_4] (shouldn't be in output)
                if (arrayList.size() != 0 && this.isConnected) {
                    while (arrayList.size() > 0) {
                        listenerInfo = (ListenerInfo)arrayList.remove(0);
                        objectArray = new Object[]{this.remoteID, listenerInfo.id};
                        try {
                            this.connector.remoteRequest(3, objectArray);
                        }
                        catch (Exception exception) {
                            if (exception instanceof InstanceNotFoundException) {
                                throw (InstanceNotFoundException)exception;
                            }
                            if (exception instanceof ListenerNotFoundException) {
                                throw (ListenerNotFoundException)exception;
                            }
                            if (exception instanceof CommunicationException) {
                                throw (CommunicationException)exception;
                            }
                            if (exception instanceof JMRuntimeException) {
                                throw (JMRuntimeException)exception;
                            }
                            if (!logger.finestOn()) continue;
                            logger.finest("removeNotificationListener exception:", exception);
                        }
                    }
                }
                if (this.listenerList.size() == 0) {
                    try {
                        if (System.getProperty("com.sun.jdmk.notification.termination") == null) {
                            this.disconnect(false);
                        } else {
                            this.disconnect(true);
                        }
                    }
                    catch (Exception exception) {
                        if (!logger.finerOn()) break block22;
                        logger.finer("removeNotificationListener", exception);
                    }
                }
            }
            return;
        }
    }

    public void setPeriod(int n) {
        if (logger.finerOn()) {
            logger.finer("setPullPeriod", "A user asks to set pull period to " + n);
        }
        this.forwardPeriod = n;
        try {
            this.jobOfGet.terminate();
            this.jobOfGet = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n > 0 && this.isConnected && this.forwardMode == 1) {
            this.jobOfGet = new JobOfGetNotif();
            this.jobOfGet.start();
        }
    }

    public int getPeriod() {
        return this.forwardPeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getNotifications() {
        Object[] objectArray;
        block14: {
            if (logger.finerOn()) {
                logger.finer("getNotification", "A user asks to get all notifications.");
            }
            if (!this.isConnected || this.forwardMode == 0) {
                return;
            }
            objectArray = null;
            try {
                Object[] objectArray2 = new Object[]{this.remoteID};
                objectArray = this.connector.remoteRequest(4, objectArray2);
            }
            catch (CommunicationException communicationException) {
                throw communicationException;
            }
            catch (JMRuntimeException jMRuntimeException) {
                throw jMRuntimeException;
            }
            catch (Exception exception) {
                if (!logger.finestOn()) break block14;
                logger.finest("getNotifications", exception);
            }
        }
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                RemoteNotification remoteNotification = (RemoteNotification)objectArray[i];
                HashMap hashMap = this.listenerList;
                synchronized (hashMap) {
                    ListenerInfo listenerInfo = (ListenerInfo)this.listenerList.get(remoteNotification.id);
                    if (listenerInfo != null) {
                        try {
                            listenerInfo.listener.handleNotification(remoteNotification.notif, listenerInfo.handback);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    continue;
                }
            }
        }
    }

    public void clearCache() {
        block4: {
            if (logger.finerOn()) {
                logger.finer("clearCache", "Ask the server to clear the notification cache.");
            }
            if (!this.isConnected || this.forwardMode == 0) {
                return;
            }
            Object[] objectArray = new Object[]{this.remoteID};
            try {
                this.connector.remoteRequest(5, objectArray);
            }
            catch (Exception exception) {
                if (!logger.finestOn()) break block4;
                logger.finest("clearNotifications", exception);
            }
        }
    }

    public int setCacheSize(int n, boolean bl) {
        if (logger.finerOn()) {
            logger.finer("setCacheSize", "Ask the server to set size of the cache.");
        }
        if (this.isConnected) {
            Object[] objectArray;
            block7: {
                Object[] objectArray2 = new Object[]{this.remoteID, new Integer(n), new Boolean(bl)};
                objectArray = null;
                try {
                    objectArray = this.connector.remoteRequest(9, objectArray2);
                }
                catch (CommunicationException communicationException) {
                    throw communicationException;
                }
                catch (JMRuntimeException jMRuntimeException) {
                    throw jMRuntimeException;
                }
                catch (Exception exception) {
                    if (!logger.finestOn()) break block7;
                    logger.finest("setCacheSize", exception);
                }
            }
            this.cacheSize = (Integer)objectArray[0];
        } else {
            this.cacheSize = n;
        }
        return this.cacheSize;
    }

    public int getCacheSize() {
        if (logger.finerOn()) {
            logger.finer("getCacheSize", "Ask the server to return the size of the cache.");
        }
        return this.cacheSize;
    }

    public void setOverflowCount(int n) {
        block6: {
            if (logger.finerOn()) {
                logger.finer("setOverflowCount", "Set the overflow count.");
            }
            if (this.isConnected) {
                Object[] objectArray = new Object[]{this.remoteID, new Integer(n)};
                try {
                    this.connector.remoteRequest(11, objectArray);
                }
                catch (CommunicationException communicationException) {
                    throw communicationException;
                }
                catch (JMRuntimeException jMRuntimeException) {
                    throw jMRuntimeException;
                }
                catch (Exception exception) {
                    if (!logger.finestOn()) break block6;
                    logger.finest("setOverflowCount", exception);
                }
            }
        }
    }

    public int getOverflowCount() {
        if (logger.finerOn()) {
            logger.finer("getOverflowCount", "Get the overflow count.");
        }
        int n = 0;
        if (this.isConnected) {
            Object[] objectArray;
            block6: {
                Object[] objectArray2 = new Object[]{this.remoteID};
                objectArray = null;
                try {
                    objectArray = this.connector.remoteRequest(12, objectArray2);
                }
                catch (CommunicationException communicationException) {
                    throw communicationException;
                }
                catch (JMRuntimeException jMRuntimeException) {
                    throw jMRuntimeException;
                }
                catch (Exception exception) {
                    if (!logger.finestOn()) break block6;
                    logger.finest("getOverflowCount", exception);
                }
            }
            n = (Integer)objectArray[0];
        }
        return n;
    }

    public void setOverflowMode(int n) throws IllegalArgumentException {
        block7: {
            if (logger.finerOn()) {
                logger.finer("setOverflowMode", "Set overflow mode.");
            }
            if (n != 11 && n != 10) {
                throw new IllegalArgumentException("Illegal overflow mode.");
            }
            if (this.isConnected) {
                Object[] objectArray = new Object[]{this.remoteID, new Integer(n)};
                try {
                    this.connector.remoteRequest(7, objectArray);
                }
                catch (CommunicationException communicationException) {
                    throw communicationException;
                }
                catch (JMRuntimeException jMRuntimeException) {
                    throw jMRuntimeException;
                }
                catch (Exception exception) {
                    if (!logger.finestOn()) break block7;
                    logger.finest("setOverflowMode", exception);
                }
            }
        }
        this.discardMode = n;
    }

    public int getOverflowMode() {
        if (logger.finerOn()) {
            logger.finer("getOverflowMode", "Get the overflow mode.");
        }
        return this.discardMode;
    }

    public Object[] remoteRequest(int n, Object[] objectArray) throws Exception {
        Object[] objectArray2 = null;
        switch (n) {
            case 0: {
                this.forwardNotifs.addNotifs(objectArray);
                objectArray2 = new Object[]{};
                break;
            }
            case 1: {
                objectArray2 = this.backConnectorTest();
                break;
            }
            default: {
                throw new JMRuntimeException("The request is unknown.");
            }
        }
        return objectArray2;
    }

    protected void finalize() throws Throwable {
        this.listenerList.clear();
        this.disconnect(true);
        this.listenerList = null;
        super.finalize();
    }

    protected Object[] backConnectorTest() {
        return new Object[0];
    }

    protected synchronized void connect() {
        block7: {
            if (this.isConnected) {
                return;
            }
            if (logger.finerOn()) {
                logger.finer("connect", "Connecting to the server ...");
            }
            Object[] objectArray = new Object[]{new Integer(this.discardMode), new Integer(this.cacheSize)};
            Object[] objectArray2 = null;
            try {
                objectArray2 = this.connector.remoteRequest(0, objectArray);
                this.remoteID = (Long)objectArray2[0];
                if (logger.finestOn()) {
                    logger.finest("connect", "Id=" + this.remoteID);
                }
            }
            catch (CommunicationException communicationException) {
                throw communicationException;
            }
            catch (JMRuntimeException jMRuntimeException) {
                throw jMRuntimeException;
            }
            catch (Exception exception) {
                if (!logger.finestOn()) break block7;
                logger.finest("connect", exception);
            }
        }
        this.internalSetMode(this.forwardMode);
        this.isConnected = true;
    }

    protected synchronized void internalSetMode(int n) {
        block12: {
            Object[] objectArray;
            Object[] objectArray2 = null;
            if (n == 0) {
                this.clientAddress = this.connector.startPush();
                objectArray2 = objectArray = new Object[]{this.remoteID, new Integer(0), this.clientAddress};
            } else if (n == 1) {
                objectArray2 = objectArray = new Object[]{this.remoteID, new Integer(1), null};
            }
            try {
                this.connector.remoteRequest(6, objectArray2);
            }
            catch (CommunicationException communicationException) {
                throw communicationException;
            }
            catch (JMRuntimeException jMRuntimeException) {
                throw jMRuntimeException;
            }
            catch (Exception exception) {
                if (!logger.finestOn()) break block12;
                logger.finest("internalSetMode", exception);
            }
        }
        if (n == 1 && this.forwardMode == 0) {
            this.connector.stopPush(this.clientAddress);
        }
        if (n == 0) {
            try {
                this.jobOfGet.terminate();
                this.jobOfGet = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!(n != 1 || this.forwardPeriod <= 0 || this.jobOfGet != null && this.jobOfGet.isAlive())) {
            this.jobOfGet = new JobOfGetNotif();
            this.jobOfGet.start();
        }
        this.forwardMode = n;
    }

    protected synchronized void disconnect() {
        this.disconnect(false);
    }

    protected synchronized void disconnect(boolean bl) {
        block9: {
            if (!this.isConnected) {
                return;
            }
            if (logger.finerOn()) {
                logger.finer("disconnect", "Disconnecting with the server...");
            }
            if (!bl) {
                if (logger.finerOn()) {
                    logger.finer("disconnect", "Send Request to the server...");
                }
                Object[] objectArray = new Object[]{this.remoteID};
                try {
                    this.connector.remoteRequest(1, objectArray);
                }
                catch (Exception exception) {
                    if (!logger.finerOn()) break block9;
                    logger.finer("disconnect", exception);
                }
            }
        }
        if (this.forwardMode == 0) {
            this.connector.stopPush(this.clientAddress);
        }
        try {
            this.jobOfGet.terminate();
            this.jobOfGet = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.listenerList.clear();
        this.isConnected = false;
    }

    private ListenerInfo findListenerInfo(ObjectName objectName, NotificationListener notificationListener) {
        ListenerInfo listenerInfo = null;
        Iterator iterator = this.listenerList.values().iterator();
        while (iterator.hasNext()) {
            ListenerInfo listenerInfo2 = (ListenerInfo)iterator.next();
            if (!objectName.equals(listenerInfo2.mbean) || notificationListener != listenerInfo2.listener) continue;
            listenerInfo = listenerInfo2;
            break;
        }
        return listenerInfo;
    }

    static /* synthetic */ int access$500() {
        return DEFAULT_TIME;
    }

    private class JobOfGetNotif
    extends Thread {
        boolean tobeTerminated = false;

        public JobOfGetNotif() {
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (jobLogger.finerOn()) {
                jobLogger.finer("run", "Start pulling...");
            }
            while (!this.tobeTerminated && ClientNotificationDispatcher.this.forwardPeriod > 0) {
                RemoteNotification[] remoteNotificationArray = null;
                try {
                    JobOfGetNotif.sleep(ClientNotificationDispatcher.this.forwardPeriod);
                    if (this.tobeTerminated || ClientNotificationDispatcher.this.forwardPeriod <= 0) break;
                    Object[] objectArray = new Object[]{ClientNotificationDispatcher.this.remoteID};
                    remoteNotificationArray = (RemoteNotification[])ClientNotificationDispatcher.this.connector.remoteRequest(4, objectArray);
                }
                catch (Exception exception) {
                    if (this.tobeTerminated) {
                        if (!jobLogger.finestOn()) break;
                        jobLogger.finest("run", "Disconnected");
                        break;
                    }
                    if (!jobLogger.finestOn()) continue;
                    jobLogger.finest("run", exception);
                    continue;
                }
                if (remoteNotificationArray == null) continue;
                for (int i = 0; i < remoteNotificationArray.length; ++i) {
                    RemoteNotification remoteNotification = remoteNotificationArray[i];
                    HashMap hashMap = ClientNotificationDispatcher.this.listenerList;
                    synchronized (hashMap) {
                        block11: {
                            try {
                                ListenerInfo listenerInfo = (ListenerInfo)ClientNotificationDispatcher.this.listenerList.get(remoteNotification.id);
                                listenerInfo.listener.handleNotification(remoteNotification.notif, listenerInfo.handback);
                            }
                            catch (Exception exception) {
                                if (!jobLogger.finestOn()) break block11;
                                jobLogger.finest("run", exception);
                            }
                        }
                        continue;
                    }
                }
            }
        }

        public void terminate() {
            if (jobLogger.finerOn()) {
                jobLogger.finer("terminate", "Stop pulling...");
            }
            this.tobeTerminated = true;
        }
    }

    private class ListenerInfo {
        public ObjectName mbean;
        public NotificationListener listener = null;
        public NotificationFilter filter;
        public Object handback;
        public int time = ClientNotificationDispatcher.access$500();
        public Long id;

        public ListenerInfo(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object, Long l) {
            this.mbean = objectName;
            this.listener = notificationListener;
            this.filter = notificationFilter;
            this.handback = object;
            this.id = l;
        }
    }

    private class ForwardNotifs {
        private TaskThread taskThread = null;
        private List notifList = Collections.synchronizedList(new ArrayList());

        public synchronized void addNotifs(Object[] objectArray) {
            this.notifList.add((RemoteNotification[])objectArray);
            if (this.taskThread == null) {
                this.taskThread = new TaskThread();
                this.taskThread.start();
            }
        }

        public void terminate() {
            if (this.taskThread != null) {
                this.taskThread.toBeTerminated = true;
            }
        }

        private class TaskThread
        extends Thread {
            boolean toBeTerminated = false;

            public TaskThread() {
                super("taskThread");
                this.setDaemon(true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (!this.toBeTerminated) {
                    RemoteNotification[] remoteNotificationArray = null;
                    Object object = ForwardNotifs.this.notifList;
                    synchronized (object) {
                        if (ForwardNotifs.this.notifList.isEmpty()) {
                            break;
                        }
                        remoteNotificationArray = (RemoteNotification[])ForwardNotifs.this.notifList.remove(0);
                    }
                    if (remoteNotificationArray == null) continue;
                    object = ClientNotificationDispatcher.this.listenerList;
                    synchronized (object) {
                        for (int i = 0; i < remoteNotificationArray.length; ++i) {
                            ListenerInfo listenerInfo = (ListenerInfo)ClientNotificationDispatcher.this.listenerList.get(remoteNotificationArray[i].id);
                            if (listenerInfo == null) {
                                if (!logger.finestOn()) continue;
                                logger.finest("forwardNotif", "Receive a notification not waited.");
                                continue;
                            }
                            try {
                                listenerInfo.listener.handleNotification(remoteNotificationArray[i].notif, listenerInfo.handback);
                                continue;
                            }
                            catch (Exception exception) {
                                if (!logger.finestOn()) continue;
                                logger.finest("forwardNotif", exception);
                            }
                        }
                    }
                }
                ForwardNotifs.this.taskThread = null;
            }
        }
    }
}

