/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4ejb.jbi.component;

import it.imolinfo.jbi4ejb.Logger;
import it.imolinfo.jbi4ejb.LoggerFactory;
import it.imolinfo.jbi4ejb.jbi.component.Jbi4EjbSUManager;
import it.imolinfo.jbi4ejb.jbi.component.runtime.AbstractMessageExchangeHandler;
import it.imolinfo.jbi4ejb.jbi.component.runtime.RuntimeHelper;
import it.imolinfo.jbi4ejb.jbi.endpoint.Jbi4EjbEndpoint;
import it.imolinfo.jbi4ejb.processor.ExchangeProcessor;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;

public class Jbi4EjbMessageExchangeHandler
extends AbstractMessageExchangeHandler {
    public static final long SEND_SYNC_TIMEOUT = 60000L;
    private static final Logger LOG = LoggerFactory.getLogger(Jbi4EjbMessageExchangeHandler.class);
    private Jbi4EjbSUManager suManager = null;

    public Jbi4EjbMessageExchangeHandler(Jbi4EjbSUManager suManager) {
        this.suManager = suManager;
    }

    protected final void processMessage() {
        InOut inOutMX = (InOut)this.getMessageExchange();
        Jbi4EjbEndpoint ejbEndpoint = this.suManager.getStartedEndpoint(inOutMX.getEndpoint());
        LOG.info("Received message invocation for the endpoint:" + ejbEndpoint.getEndpointName());
        ExchangeProcessor processor = ejbEndpoint.getExchangeProcessor();
        processor.process((MessageExchange)inOutMX);
    }

    protected void validateMessageExchange() throws MessagingException {
        MessageExchange msgExchange = this.getMessageExchange();
        if (this.getMessageExchange() == null) {
            throw new MessagingException("MessageExchange Object is null in MessageExchageHandler");
        }
        if (MessageExchange.Role.CONSUMER.equals(msgExchange.getRole())) {
            throw new MessagingException("Provider Message Exchange Handler can not have MessageExchange with CONSUMER Role");
        }
        if (!(msgExchange instanceof InOut)) {
            throw new MessagingException("InOut Message Exchange Handler MessageExchange object should be instanceof javax.jbi.messaging.InOut ");
        }
    }

    protected void processFault(Fault fault) {
        RuntimeHelper.logError("InOut Message exchange provider received FAULT");
    }

    protected void processDone() {
        RuntimeHelper.logVerbose("InOut Message Exchange Provider handler received DONE : END of service invocation");
    }

    protected void processError(Exception ex) {
        RuntimeHelper.logError("InOut Message Exchange Provider handler received Error");
        RuntimeHelper.logError(ex);
    }
}

