/*
 * Decompiled with CFR 0.152.
 */
package org.ini4j;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;

class ServiceFinder {
    ServiceFinder() {
    }

    protected static String findServiceClassName(String serviceId, String defaultService) throws IllegalArgumentException {
        if (defaultService == null) {
            throw new IllegalArgumentException("Provider for " + serviceId + " cannot be found");
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String serviceClassName = null;
        try {
            String systemProp = System.getProperty(serviceId);
            if (systemProp != null) {
                serviceClassName = systemProp;
            }
        }
        catch (SecurityException x) {
            // empty catch block
        }
        if (serviceClassName == null) {
            String servicePath = "META-INF/services/" + serviceId;
            try {
                InputStream is = null;
                is = classLoader == null ? ClassLoader.getSystemResourceAsStream(servicePath) : classLoader.getResourceAsStream(servicePath);
                if (is != null) {
                    BufferedReader rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    String line = rd.readLine();
                    rd.close();
                    if (line != null && !"".equals(line = line.trim())) {
                        serviceClassName = line.split("\\s|#")[0];
                    }
                }
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        if (serviceClassName == null) {
            serviceClassName = defaultService;
        }
        return serviceClassName;
    }

    protected static Class findServiceClass(String serviceId, String defaultService) throws IllegalArgumentException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String serviceClassName = ServiceFinder.findServiceClassName(serviceId, defaultService);
        try {
            return classLoader == null ? Class.forName(serviceClassName) : classLoader.loadClass(serviceClassName);
        }
        catch (ClassNotFoundException x) {
            throw (IllegalArgumentException)new IllegalArgumentException("Provider " + serviceClassName + " not found").initCause(x);
        }
    }

    protected static Object findService(String serviceId, String defaultService) throws IllegalArgumentException {
        try {
            return ServiceFinder.findServiceClass(serviceId, defaultService).newInstance();
        }
        catch (Exception x) {
            throw (IllegalArgumentException)new IllegalArgumentException("Provider " + serviceId + " could not be instantiated: " + x).initCause(x);
        }
    }
}

