/*
 * Decompiled with CFR 0.152.
 */
package org.ini4j;

import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.ini4j.IniPreferencesFactory;

public class IniPreferencesFactoryListener
extends IniPreferencesFactory
implements ServletContextListener {
    public static final String DEFAULT_USER_LOCATION = "/WEB-INF/user.ini";
    public static final String DEFAULT_SYSTEM_LOCATION = "/WEB-INF/system.ini";
    private ServletContext _context;

    public void contextInitialized(ServletContextEvent event) {
        this._context = event.getServletContext();
        System.setProperty("java.util.prefs.PreferencesFactory", this.getClass().getName());
    }

    public void contextDestroyed(ServletContextEvent event) {
        this._context = null;
    }

    protected String getIniLocation(String key) {
        String location = this._context.getInitParameter(key);
        if (location == null) {
            location = key.equals("org.ini4j.prefs.user") ? DEFAULT_USER_LOCATION : DEFAULT_SYSTEM_LOCATION;
        }
        return location;
    }

    protected URL getResource(String location) throws IllegalArgumentException {
        try {
            URL url = this._context.getResource(location);
            if (url == null) {
                url = super.getResource(location);
            }
            return url;
        }
        catch (MalformedURLException x) {
            throw (IllegalArgumentException)new IllegalArgumentException().initCause(x);
        }
    }
}

