/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.coco.model;

import com.sun.encoder.coco.model.CocoLanguage;
import com.sun.encoder.coco.model.CocoToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public final class CocoLexer {
    private int mRecordRow;
    private int mRecordCol;
    private ArrayList mUndoTokens;
    private final PushbackReader mInputReader;
    private boolean mDisable72ColumnLimit;

    public CocoLexer(File file) throws FileNotFoundException {
        this.mInputReader = new PushbackReader(new InputStreamReader(new FileInputStream(file)), 10);
        this.mRecordRow = 1;
        this.mRecordCol = 1;
        this.mUndoTokens = new ArrayList();
    }

    public CocoLexer(File file, String encoding) throws FileNotFoundException, UnsupportedEncodingException {
        this.mInputReader = new PushbackReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding), 10);
        this.mRecordRow = 1;
        this.mRecordCol = 1;
        this.mUndoTokens = new ArrayList();
    }

    public void dispose() {
        this.mUndoTokens.clear();
        try {
            this.mInputReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void disable72ColumnLimit(boolean doDisable) {
        this.mDisable72ColumnLimit = doDisable;
    }

    public boolean is72ColumnLimitEnforced() {
        return !this.mDisable72ColumnLimit;
    }

    public CocoToken getNextToken() throws IOException {
        if (this.mUndoTokens.size() > 0) {
            int idx = this.mUndoTokens.size() - 1;
            CocoToken undoToken = (CocoToken)this.mUndoTokens.remove(idx);
            return undoToken;
        }
        CocoToken token = null;
        try {
            int bytefat4 = this.peek();
            if (bytefat4 != -1) {
                char ch = (char)bytefat4;
                if (ch == '\n' || ch == '\r') {
                    if (ch == '\n') {
                        token = new CocoToken(" ", 3, this.mRecordRow, this.mRecordCol);
                        token.isEOL(true);
                        ++this.mRecordRow;
                        this.mRecordCol = 1;
                        this.read();
                    } else if (this.isCharsAvailable(2)) {
                        char[] peeks = new char[2];
                        this.peek(peeks);
                        char ch2 = peeks[1];
                        if (ch2 == '\n') {
                            token = new CocoToken(" ", 3, this.mRecordRow, this.mRecordCol);
                            token.isEOL(true);
                            ++this.mRecordRow;
                            this.mRecordCol = 1;
                            this.read();
                            this.read();
                        }
                    }
                } else if (Character.isDigit(ch)) {
                    token = this.getNumeric();
                } else if (Character.isLetter(ch)) {
                    token = this.isPrettyDamnAnnoyingDelimiterNext() ? this.getSeparator() : this.getAlphaNumeric();
                } else if (!CocoLanguage.isInCobolCharSet(ch)) {
                    this.read();
                    token = new CocoToken(String.valueOf(ch), 4, this.mRecordRow, this.mRecordCol);
                    this.movePosition(1);
                } else {
                    token = this.isSeparatorNext() ? this.getSeparator() : this.getCobolCharacter();
                }
            } else {
                token = new CocoToken("EOF", 5, this.mRecordRow, this.mRecordCol);
            }
        }
        catch (IOException ioe) {
            int bytefat4 = -1;
        }
        return token;
    }

    public void ungetToken(CocoToken token) throws IllegalArgumentException {
        if (token == null) {
            throw new IllegalArgumentException();
        }
        this.mUndoTokens.add(token);
    }

    private CocoToken getAlphaNumeric() throws IOException {
        StringBuffer buffer = new StringBuffer();
        while (this.isAlphaOrDigitNext()) {
            buffer.append((char)this.read());
        }
        CocoToken token = null;
        if (buffer.length() > 0) {
            token = new CocoToken(buffer.toString(), 0, this.mRecordRow, this.mRecordCol);
            this.movePosition(token.getLength());
        }
        return token;
    }

    private CocoToken getNumeric() throws IOException {
        StringBuffer buffer = new StringBuffer();
        int tokenType = 1;
        while (this.isAlphaOrDigitNext()) {
            char ch = (char)this.read();
            if (Character.isLetter(ch)) {
                tokenType = 0;
            }
            buffer.append(ch);
        }
        CocoToken token = null;
        if (buffer.length() > 0) {
            token = new CocoToken(buffer.toString(), tokenType, this.mRecordRow, this.mRecordCol);
            this.movePosition(token.getLength());
        }
        return token;
    }

    private CocoToken getCobolCharacter() throws IOException {
        CocoToken token = null;
        char ch = (char)this.peek();
        if (CocoLanguage.isInCobolCharSet(ch)) {
            token = new CocoToken(String.valueOf(ch), 2, this.mRecordRow, this.mRecordCol);
            this.movePosition(1);
            this.read();
        }
        return token;
    }

    private CocoToken getSeparator() throws IOException {
        CocoToken token = null;
        while (token == null && this.isCharsAvailable(1)) {
            char ch1;
            char ch2;
            int chi = this.read();
            char ch = (char)chi;
            if (ch == ' ') {
                if (this.isCharsAvailable(2)) {
                    char[] peeks = new char[2];
                    this.peek(peeks);
                    ch2 = peeks[0];
                    char ch3 = peeks[1];
                    if (ch2 == '=' && ch3 == '=') {
                        token = new CocoToken("==", 3, this.mRecordRow, this.mRecordCol);
                        this.movePosition(3);
                        this.read();
                        this.read();
                    }
                }
                if (token == null) {
                    if (CocoLanguage.isSeparator(ch)) {
                        token = new CocoToken(String.valueOf(ch), 3, this.mRecordRow, this.mRecordCol);
                        this.movePosition(1);
                    } else {
                        this.unread(chi);
                        break;
                    }
                }
            }
            if ("GNXZ".indexOf(ch) != -1 && this.isCharsAvailable(1) && CocoLanguage.isSeparator(ch1 = Character.toUpperCase(ch), ch2 = Character.toUpperCase((char)this.peek()))) {
                char[] c = new char[]{ch1, ch2};
                token = new CocoToken(new String(c, 0, 2), 3, this.mRecordRow, this.mRecordCol);
                this.movePosition(2);
                this.read();
            }
            if (token != null) continue;
            if (CocoLanguage.isSeparator(ch)) {
                token = new CocoToken(String.valueOf(ch), 3, this.mRecordRow, this.mRecordCol);
                this.movePosition(1);
                continue;
            }
            this.unread(chi);
            break;
        }
        return token;
    }

    private boolean isAlphaOrDigitNext() throws IOException {
        boolean isIt = false;
        int value = this.peek();
        if (value != -1) {
            char ch = (char)value;
            isIt = Character.isLetterOrDigit(ch);
        }
        return isIt;
    }

    private boolean isCobolCharNext() throws IOException {
        boolean isIt = false;
        int value = this.peek();
        if (value != -1) {
            char ch = (char)value;
            isIt = CocoLanguage.isInCobolCharSet(ch);
        }
        return isIt;
    }

    private boolean isSeparatorNext() throws IOException {
        boolean isIt = false;
        int value = this.peek();
        if (value != -1) {
            char ch = (char)value;
            isIt = CocoLanguage.isSeparator(ch);
        }
        return isIt;
    }

    private boolean isPrettyDamnAnnoyingDelimiterNext() throws IOException {
        boolean isIt = false;
        char[] c = new char[3];
        int len = this.peek(c);
        if (len >= 2) {
            switch (Character.toUpperCase(c[0])) {
                case 'G': 
                case 'N': 
                case 'X': 
                case 'Z': {
                    isIt = CocoLanguage.isSeparator(c[0], c[1]);
                    break;
                }
                case ' ': {
                    isIt = len == 3;
                    isIt = CocoLanguage.isSeparator(c[1], c[2]);
                }
            }
        }
        return isIt;
    }

    private boolean isEod() throws IOException {
        boolean isIt = false;
        int value = this.peek();
        isIt = value == -1;
        return isIt;
    }

    private void movePosition(int amount) {
        this.mRecordCol += amount;
        if (!this.mDisable72ColumnLimit && this.mRecordCol > 82) {
            this.mRecordRow += this.mRecordCol / 82;
            this.mRecordCol %= 82;
        }
    }

    private int peek() throws IOException {
        int value = this.mInputReader.read();
        if (value != -1) {
            this.mInputReader.unread(value);
        }
        return value;
    }

    private int peek(char[] c) throws IOException, NullPointerException {
        int count = 0;
        int value = 0;
        int[] buf = new int[c.length];
        while (value != -1 && count < c.length) {
            buf[count] = value = this.mInputReader.read();
            if (value == -1) continue;
            c[count++] = (char)value;
        }
        if (count > 0) {
            this.mInputReader.unread(c, 0, count);
        }
        return count;
    }

    private boolean isCharsAvailable(int mincount) throws IOException {
        int count = Math.max(0, mincount);
        char[] cr = new char[count];
        int got = this.peek(cr);
        return got == count;
    }

    private int read() throws IOException {
        return this.mInputReader.read();
    }

    private void unread(int chi) throws IOException {
        this.mInputReader.unread(chi);
    }
}

