/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.stream;

import com.sun.xml.stream.PropertyManager;
import com.sun.xml.stream.writers.XMLDOMWriterImpl;
import com.sun.xml.stream.writers.XMLEventWriterImpl;
import com.sun.xml.stream.writers.XMLStreamWriterImpl;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;

public class ZephyrWriterFactory
extends XMLOutputFactory {
    private PropertyManager fPropertyManager = new PropertyManager(2);

    public XMLEventWriter createXMLEventWriter(Result result) throws XMLStreamException {
        return new XMLEventWriterImpl(this.createXMLStreamWriter(result));
    }

    public XMLEventWriter createXMLEventWriter(Writer writer) throws XMLStreamException {
        return new XMLEventWriterImpl(this.createXMLStreamWriter(writer));
    }

    public XMLEventWriter createXMLEventWriter(OutputStream outputStream) throws XMLStreamException {
        return new XMLEventWriterImpl(this.createXMLStreamWriter(outputStream));
    }

    public XMLEventWriter createXMLEventWriter(OutputStream outputStream, String encoding) throws XMLStreamException {
        return new XMLEventWriterImpl(this.createXMLStreamWriter(outputStream, encoding));
    }

    public XMLStreamWriter createXMLStreamWriter(Result result) throws XMLStreamException {
        if (result instanceof StreamResult) {
            StreamResult streamResult = (StreamResult)result;
            if (streamResult.getWriter() != null) {
                return new XMLStreamWriterImpl(streamResult.getWriter(), new PropertyManager(this.fPropertyManager));
            }
            if (streamResult.getOutputStream() != null) {
                return new XMLStreamWriterImpl(streamResult.getOutputStream(), new PropertyManager(this.fPropertyManager));
            }
            if (streamResult.getSystemId() != null) {
                try {
                    FileWriter writer = new FileWriter(new File(streamResult.getSystemId()));
                    return new XMLStreamWriterImpl(writer, new PropertyManager(this.fPropertyManager));
                }
                catch (IOException ie) {
                    throw new XMLStreamException(ie);
                }
            }
        } else {
            if (result instanceof DOMResult) {
                return new XMLDOMWriterImpl((DOMResult)result);
            }
            if (result instanceof Result) {
                try {
                    FileWriter writer = new FileWriter(new File(result.getSystemId()));
                    return new XMLStreamWriterImpl(writer, new PropertyManager(this.fPropertyManager));
                }
                catch (IOException ie) {
                    throw new XMLStreamException(ie);
                }
            }
        }
        throw new UnsupportedOperationException();
    }

    public XMLStreamWriter createXMLStreamWriter(Writer writer) throws XMLStreamException {
        return new XMLStreamWriterImpl(writer, new PropertyManager(this.fPropertyManager));
    }

    public XMLStreamWriter createXMLStreamWriter(OutputStream outputStream) throws XMLStreamException {
        return new XMLStreamWriterImpl(outputStream, new PropertyManager(this.fPropertyManager));
    }

    public XMLStreamWriter createXMLStreamWriter(OutputStream outputStream, String encoding) throws XMLStreamException {
        try {
            return new XMLStreamWriterImpl(outputStream, encoding, new PropertyManager(this.fPropertyManager));
        }
        catch (Exception ex) {
            throw new XMLStreamException(ex);
        }
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Property not supported");
        }
        if (this.fPropertyManager.containsProperty(name)) {
            return this.fPropertyManager.getProperty(name);
        }
        throw new IllegalArgumentException("Property not supported");
    }

    public boolean isPropertySupported(String name) {
        if (name == null) {
            return false;
        }
        return this.fPropertyManager.containsProperty(name);
    }

    public void setProperty(String name, Object value) throws IllegalArgumentException {
        if (name == null || value == null || !this.fPropertyManager.containsProperty(name)) {
            throw new IllegalArgumentException("Property " + name + "is not supported");
        }
        this.fPropertyManager.setProperty(name, value);
    }
}

