%define name mplayerplug-in
%define ver 2.70
%define mozilla_dir /usr/lib/mozilla/
%define config_dir /etc
%{!?os_ver:%define os_ver fc%(cut -d' ' -f4 /etc/fedora-release )}

%define rel %{os_ver}

Name: %{name}
Version: %{ver}
Release: %{rel}
License: GPL
Group: Browser/Plugin
Summary: MPlayer Plugin for Netscape/Mozilla
URL: http://mplayerplug-in.sourceforge.net/
Packager: Kevin DeKorte <kdekorte@users.sourceforge.net>
Source0: %{name}-%{ver}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{ver}-root

BuildRequires: XFree86-devel mozilla-devel > 1.5 gtk2-devel > 2.2.1
Obsoletes: mplayerplug-in < %{version}
Provides: mplayerplug-in


%description
mplayerplug-in is a Mozilla browser plugin to allow playing embedded movies on web pages.

%prep
rm -rf %buildroot && %{__mkdir} -p %buildroot%{mozilla_dir} && %{__mkdir} -p %buildroot%{config_dir} && %{__mkdir} -p %buildroot%{mozilla_dir}plugins && %{__mkdir} -p %buildroot%{mozilla_dir}components
%setup -n %{name}

%build
./configure
%{__make}

%install
%{__install} -m755 mplayerplug-in.so %buildroot%{mozilla_dir}plugins
%{__install} -m755 mplayerplug-in.xpt %buildroot%{mozilla_dir}components
%{__install} -m755 mplayerplug-in.types %buildroot%{config_dir}
%{__install} -m755 mplayerplug-in.conf %buildroot%{config_dir}

%clean
rm -rf %buildroot

%files
%defattr (-,root,root)
%doc ChangeLog INSTALL README TODO
%{mozilla_dir}/plugins/mplayerplug-in.so
%{mozilla_dir}/components/mplayerplug-in.xpt
%config(noreplace) %{config_dir}/mplayerplug-in.conf
%config(noreplace) %{config_dir}/mplayerplug-in.types

%changelog
* Sun Sep 26 2004 Kevin DeKorte
- v2.70
	GTK1 Widget fixes
	MMS URL saving
	GTK2 improvements
	Xinerama support
	
* Sat Jun 19 2004 Kevin DeKorte
- v2.66
	Fix Gentoo NPTL locking issue / crash

* Mon Jun 14 2004 Kevin DeKorte
- v2.65
	Fix some minor crash situations
	UI fixes in all modes
	Support gecko-sdk 1.7 and higher
	
* Thu Mar 18 2004 Kevin DeKorte
- v2.50
        See ChangeLog for complete listing
	Thread locking fixes
	More URL support
	GUI fixes
	
* Sun Feb 15 2004 Kevin DeKorte
- v2.11
	Added some missing defines for older compilers
	Fixed getBaseURL crasher on SUN
	Removed -cookies option in call to mplayer because it is not present on some versions of mplayer
  v2.10
	Fix crash and double play with American Idol site
	Configure fixes, added --with-gecko-sdk option if pkg-config does not work
	Fixed bug where first file in playlist was not being cleaned up
	Fixed casting error in memmem.c
	Playback reset if frame decode error
	New option cache-percent defaulted to 25 values are [0-100] used with
		cachesize, takes value of stream size and takes larger (huge Shrek plays on DSL now)
	Fix errors on building on a solaris 9 with gcc tools environment
	Fix compile issue on slackware
	
* Fri Feb 06 2004 Kevin DeKorte
- v2.0
	Massive code reorganization to get javascript commands to work
	Conversion of C code to C++ code
	Code retains all fixes of 1.3 candidate
	Code retains almost all functionality of 1.3 candidate
	functions/options that have been removed include:
		use of gmplayer, no longer an option, built-in gui planned
		logging to a file - logging to console easier
		download option - now automatic
		other options have now been made default
	mozilla-devel package now required to compile code.
	gcc -Wall is used now, so all those errors/warnings should be fixed
	strncpy/strncat replaced with strlcpy/strlcat, files included in archive
	Fixed browser hang when player crashes or is killed

	***Code Split - 1.3 candidate***
	Fix possible buffer overflow in buildPlaylist
	Correct mplayer shutdown process
	More UI enhancements from Erich
	Even more UI enhancements
	Fix XML parse error on smil files that don't have seq tags. Which DTD does SMIL use?
	Fix videotag not found omission
	Fix UI crasher FreeUI was called with uninitialized pointers
	Parse mplayer output to determine the actual size and play size of the media
	Support RealMedia with embedded rtsp streams, allows NASA TV to work
		needs enable-real=1 in mplayerplug-in.conf
		mplayer with RealMedia codecs and support
	Fix possible crash in NPP_Destroy
	Change buildPlaylist to be called from NPP_DestroyStream rather than after a magic value in NPP_Write
		This way we are sure we have the entire playlist downloaded.
	Found possible crash in smil format decode
	Added stat.c to make Solaris compile work
	Fixed bug in getURLBase
	Fixed handling of This->baseurl
	Fixed crash in ASX format handling, should fix http://www.rbcmp3.com
	Account for CR and LF instead of just LF in RM playlists
	Solaris compile issue - change stat.c references to lstat.c
	Fixed compile issue in lstat.c
	Applied Alexandre Pereira da Silva's player manager work. Should help those with "ps" issues.

* Wed Jan 20 2004 Kevin DeKorte
- v1.2
	QuickTime streaming, speed work
	Fix crasher on url http://www.video-c.co.uk/frontend/asp/microshow.asp?vidref=benn001&FileType=ADSLprog
		This was caused by an incorrect assumption about Quicktime MOV Reference files
		rmda elements can contain rmdr and rdrf in any order, files I had only showed one order.
	When keep-download=1 write mms url's into $dload-dir/playlist for reference
	All unwanted streams are now cancelled and not downloaded with QT autospeed.
	Changed qt-speed config option from a 0-12 number to [low|medium|high], this should be final now
	Fixed crasher in smil format support when bitrate not specified.
	Fixed bug with MSN Music site where http urls are self referencing and act like MMS Streams
	Applied patch from Erich that reduces the amount of flicker when updating the status screen
	Changed Full Redraw threshhold from 50 to 80, some sites were a little crammed.
	Merged patch from Erich to display progress bar during download
	Fixed bug where video was streamed rather then downloaded, when it should be downloaded
	Proper smil format support, with nested video tags with seq tags
	Found an extra ; in the speed adjustment code that was causing med and high speeds to be off

* Tue Jan 15 2004 Kevin DeKorte
- v1.1
- Security Fixes
- Minor bug fixes with saving streams
- Build system fixes
- Title Screen enhancement
- Updated status window
- Playlist support for http streams that act like mms streams
- See ChangeLog for full list of fixes

* Tue Dec 12 2003 Kevin DeKorte
- v1.0
- Added -zoom patch from Giuseppe Ghibò <ghibo@mandrakesoft.com>
- Patch to only kill the mplayer associated with the window being destroyed.
- This allows multiple streams to play in different windows
- Cosmetic "about:plugins" patch from Benjamin Larsson <banan@student.luth.se>
- More about:plugin work to fix an issue with AtomFilms, Quicktime was not coming up
- Keep trailing ; in mimetype list
- smil format support - Clone wars

* Mon Oct 20 2003 Kevin DeKorte
- v1.0pre3
- More fixes

* Thu Oct 16 2003 Kevin DeKorte
- v1.0pre2
- compatibility with mplayer 1.0pre2

* Fri Oct 03 2003 Kevin DeKorte
- v0.95
- True streaming support
- Improved playlist capability
- Improved status window
- Mplayer 0.92 is a prerequisite

* Wed Sep 10 2003 Kevin DeKorte
- Fix errors in 0.90
- Downloading feature disabled for now.

* Sun Sep 07 2003 Kevin DeKorte
- See ChangeLog for code changes

* Mon Mar 03 2003 Michael A. Peters <mpeters@mac.com>
- created spec file
