/* 
 *   Creation Date: <1999/03/29 13:32:19 samuel>
 *   Time-stamp: <2001/06/21 15:03:47 samuel>
 *   
 *	<res_manager.h>
 *	
 *	Resource manager (also handles cmdline options)
 *   
 *   Copyright (C) 1999, 2000, 2001 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#ifndef _H_OPTIONS
#define _H_OPTIONS

typedef struct {
	char 	*name;
	ulong	flag;
} opt_entry_t;


/* interface functions */
extern void 	res_manager_init( int is_mol, int argc, char **argv );
extern void 	res_manager_cleanup( void );

extern void 	default_res( char *key, char *value );
extern void 	add_res( char *key, char *value );
extern int  	res_present( char *key );

extern int 	get_bool_res( char *key );
extern long 	get_numeric_res( char *key );
extern char*	get_lockfile( void );

extern ulong	parse_res_options( char *key, int index, int first_arg, opt_entry_t *opts, char *err_str );

extern char 	*get_str_res( char *key );
extern char 	*get_str_res_ind( char *key, int index, int argnum );


#endif   /* _H_OPTIONS */

