/* 
 *   Creation Date: <1999/07/17 13:36:38 samuel>
 *   Time-stamp: <2000/10/29 16:46:27 samuel>
 *   
 *	<gc.h>
 *	
 *	GC/mac-io IO controller
 *   
 *   Copyright (C) 1999, 2000 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#ifndef _H_GC
#define _H_GC

#include "promif.h"
#include "ioports.h"

/* private to gc.c */
typedef struct gc_range
{
	char			*name;
	io_ops_t		*ops;
	io_cleanup_fp		cleanup_fp;
	void 			*usr;

	int			offs;
	size_t			size;
	int			flags;

	struct gc_range		*next;
	int			range_id;
	int			is_mapped;
	ulong			base;
} gc_range_t;

#define get_mbase( gc_range ) \
	( (gc_range)->base )

extern int is_gc_child( mol_device_node_t *dn );

extern gc_range_t *add_gc_range( int offs, size_t size, char *name, int flags,
				 io_ops_t *ops, void *usr );

extern ulong gc_offs( ulong addr );

extern int gc_is_present( void );


#endif   /* _H_GC */





