/* EditorWindowWrapper_1_0.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.workspace.compat;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;

import org.grinvin.gred.GraphEditor;
import org.grinvin.io.IOFormatException;
import org.grinvin.io.SectionLoader;
import org.grinvin.io.SectionSaver;
import org.grinvin.io.graphs.EmbeddingLoader;
import org.grinvin.io.graphs.GraphLoader;
import org.grinvin.io.list.GraphListLoader;
import org.grinvin.list.graphs.DefaultGraphListModel;
import org.grinvin.list.graphs.GraphListModel;
import org.grinvin.workspace.DefaultWindowWrapper;

import org.jdom.DataConversionException;
import org.jdom.Element;

/**
 *
 */
public class EditorWindowWrapper_1_0 extends DefaultWindowWrapper<GraphEditor> {

    @Override
    public GraphEditor create() {
        throw new UnsupportedOperationException("This wrapper cannot be used to create new editor windows");
    }

    public String getElementName() {
        return "editorWindow";
    }
    
    @Override
    public GraphEditor load(Element element, SectionLoader sloader) throws IOException {
        String versionString = element.getAttributeValue("version");
        if (!"1.0".equals(versionString))
            throw new IOFormatException("Unknown editorwindowwrapper version: " + versionString);
        try {
            GraphListModel list = new DefaultGraphListModel();
            URI graphListURI = new URI(element.getAttributeValue("graphlistURI"));
            InputStream input = sloader.openSection(graphListURI.getSchemeSpecificPart());
            GraphListLoader.load_1_0(list, input, sloader);
            list.setURI(graphListURI);

            // create and initialize the window
            GraphEditor editor = new GraphEditor(list);
            // initialize properties of this window and of its guides tool
            loadWindowProperties(element, editor);
            editor.setDirty(element.getAttribute("dirty").getBooleanValue());

            // load the graph
            GraphLoader.load(editor.getGraph(), element.getChild("graph"));
            EmbeddingLoader.load(editor.getEmbedding(), element.getChild("embedding"));
            return editor;
        } catch (URISyntaxException ex) {
            throw new IOFormatException("Invalid URI in meta.xml", ex);
        } catch (DataConversionException ex) {
            throw new IOFormatException("Incorrect boolean attribute value", ex);
        }
    }
    
    @Override
    public void save(GraphEditor window, Element parent, SectionSaver ssaver) throws IOException {
        throw new UnsupportedOperationException("This wrapper cannot be used to save editor windows");
    }
    
}
